/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;

public class AbstractSPFilterListener
implements SPListener {
    private boolean filter = false;
    private final List<Class<? extends SPObject>> filteredClasses;
    private final SPListener nextListener;

    public AbstractSPFilterListener(List<Class<? extends SPObject>> filteredClasses, SPListener nextListener) {
        this.filteredClasses = filteredClasses;
        this.nextListener = nextListener;
        if (filteredClasses.isEmpty()) {
            throw new IllegalArgumentException("You need to specify some classes to filter.If you don't need the filter, just make an AbstractSPListener.");
        }
    }

    @Override
    public void childAdded(SPChildEvent e) {
        if (this.filter) {
            if (!this.filteredClasses.contains(e.getChildType())) {
                this.nextListener.childAdded(e);
            }
        } else {
            this.nextListener.childAdded(e);
        }
    }

    @Override
    public void childRemoved(SPChildEvent e) {
        if (this.filter) {
            if (!this.filteredClasses.contains(e.getChildType())) {
                this.nextListener.childAdded(e);
            }
        } else {
            this.nextListener.childRemoved(e);
        }
    }

    @Override
    public void propertyChanged(PropertyChangeEvent evt) {
        if (this.filter) {
            if (!this.filteredClasses.contains(evt.getSource().getClass())) {
                this.nextListener.propertyChanged(evt);
            }
        } else {
            this.nextListener.propertyChanged(evt);
        }
    }

    @Override
    public void transactionStarted(TransactionEvent e) {
        this.nextListener.transactionStarted(e);
    }

    @Override
    public void transactionEnded(TransactionEvent e) {
        this.nextListener.transactionEnded(e);
    }

    @Override
    public void transactionRollback(TransactionEvent e) {
        this.nextListener.transactionRollback(e);
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean isFilter() {
        return this.filter;
    }
}

