/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser.formats;

import org.jboss.galleon.util.formatparser.FormatErrors;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingContext;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.ParsingFormatBase;
import org.jboss.galleon.util.formatparser.formats.WildcardParsingFormat;

public class CollectionParsingFormat
extends ParsingFormatBase {
    public static final String LIST = "List";
    public static final String SET = "Set";
    public static final char OPENING_CHAR = '[';
    public static final char CLOSING_CHAR = ']';
    public static final char ITEM_SEPARATOR_CHAR = ',';
    private final char openingChar;
    private final char closingChar;
    private final ParsingFormat itemFormat;

    public static CollectionParsingFormat list() {
        return CollectionParsingFormat.newInstance(LIST);
    }

    public static CollectionParsingFormat list(ParsingFormat itemFormat) {
        return CollectionParsingFormat.newInstance(LIST, itemFormat);
    }

    public static CollectionParsingFormat list(ParsingFormat itemFormat, char openingChar, char closingChar) {
        return CollectionParsingFormat.newInstance(LIST, itemFormat, openingChar, closingChar);
    }

    public static CollectionParsingFormat set() {
        return CollectionParsingFormat.newInstance(SET);
    }

    public static CollectionParsingFormat set(ParsingFormat itemFormat) {
        return CollectionParsingFormat.newInstance(SET, itemFormat);
    }

    public static CollectionParsingFormat set(ParsingFormat itemFormat, char openingChar, char closingChar) {
        return CollectionParsingFormat.newInstance(SET, itemFormat, openingChar, closingChar);
    }

    public static CollectionParsingFormat newInstance(String type) {
        return CollectionParsingFormat.newInstance(type, WildcardParsingFormat.getInstance());
    }

    public static CollectionParsingFormat newInstance(String type, ParsingFormat itemFormat) {
        return CollectionParsingFormat.newInstance(type, itemFormat, '[', ']');
    }

    public static CollectionParsingFormat newInstance(String type, ParsingFormat itemFormat, char openingChar, char closingChar) {
        return new CollectionParsingFormat(type, openingChar, closingChar, itemFormat);
    }

    protected CollectionParsingFormat(String name, char openingChar, char closingChar, ParsingFormat itemFormat) {
        super(name);
        this.itemFormat = itemFormat;
        this.openingChar = openingChar;
        this.closingChar = closingChar;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isOpeningChar(char ch) {
        return this.openingChar == ch;
    }

    @Override
    public void pushed(ParsingContext ctx) throws FormatParsingException {
        if (ctx.charNow() != this.openingChar) {
            throw new FormatParsingException(FormatErrors.unexpectedStartingCharacter(this, this.openingChar, ctx.charNow()));
        }
    }

    @Override
    public void react(ParsingContext ctx) throws FormatParsingException {
        char charNow = ctx.charNow();
        if (charNow == ',') {
            ctx.popFormats();
            return;
        }
        if (charNow == this.closingChar) {
            ctx.end();
            return;
        }
        ctx.bounce();
    }

    @Override
    public void deal(ParsingContext ctx) throws FormatParsingException {
        if (!Character.isWhitespace(ctx.charNow())) {
            ctx.pushFormat(this.itemFormat);
        }
    }

    @Override
    public void eol(ParsingContext ctx) throws FormatParsingException {
        throw new FormatParsingException(FormatErrors.formatIncomplete(this));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.itemFormat == null ? 0 : this.itemFormat.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollectionParsingFormat other = (CollectionParsingFormat)obj;
        return !(this.itemFormat == null ? other.itemFormat != null : !this.itemFormat.equals(other.itemFormat));
    }

    @Override
    public String toString() {
        return this.name + "<" + this.itemFormat + ">";
    }
}

