/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.util.CollectionUtils;

public class ResolvedConfig
implements ProvisionedConfig {
    final ConfigId id;
    private final Map<String, String> props;
    private final Map<String, ConfigId> configDeps;
    private final List<ConfigId> layers;
    private final List<ResolvedFeature> features;

    static ResolvedConfig build(ConfigModelStack configStack) throws ProvisioningException {
        return new ResolvedConfig(configStack);
    }

    private ResolvedConfig(ConfigModelStack configStack) throws ProvisioningException {
        this.id = configStack.id;
        this.props = CollectionUtils.unmodifiable(configStack.props);
        this.configDeps = CollectionUtils.unmodifiable(configStack.configDeps);
        this.features = CollectionUtils.unmodifiable(configStack.orderFeatures(true));
        this.layers = Collections.unmodifiableList(configStack.getIncludedLayers());
    }

    @Override
    public String getName() {
        return this.id.getName();
    }

    @Override
    public String getModel() {
        return this.id.getModel();
    }

    @Override
    public boolean hasProperties() {
        return !this.props.isEmpty();
    }

    @Override
    public String getProperty(String name) {
        return this.props.get(name);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.props;
    }

    public boolean hasConfigDeps() {
        return !this.configDeps.isEmpty();
    }

    public Map<String, ConfigId> getConfigDeps() {
        return this.configDeps;
    }

    @Override
    public boolean hasLayers() {
        return !this.layers.isEmpty();
    }

    @Override
    public Collection<ConfigId> getLayers() {
        return this.layers;
    }

    @Override
    public boolean hasFeatures() {
        return !this.features.isEmpty();
    }

    @Override
    public void handle(ProvisionedConfigHandler handler) throws ProvisioningException {
        if (this.features.isEmpty()) {
            return;
        }
        handler.prepare(this);
        ResolvedSpecId lastHandledSpecId = null;
        for (ResolvedFeature feature : this.features) {
            if (feature.isBranchStart()) {
                handler.startBranch();
            }
            if (feature.isBatchStart()) {
                handler.startBatch();
            }
            if (!feature.spec.id.equals(lastHandledSpecId)) {
                if (lastHandledSpecId == null || !feature.spec.id.producer.equals(lastHandledSpecId.producer)) {
                    handler.nextFeaturePack(feature.spec.id.producer.getLocation().getFPID());
                }
                handler.nextSpec(feature.spec);
                lastHandledSpecId = feature.getSpecId();
            }
            handler.nextFeature(feature);
            if (feature.isBatchEnd()) {
                handler.endBatch();
            }
            if (!feature.isBranchEnd()) continue;
            handler.endBranch();
        }
        handler.done();
    }

    @Override
    public int size() {
        return this.features.size();
    }
}

