/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.tracking;

import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.tracking.BuildLayoutTracker;
import org.jboss.galleon.cli.tracking.CliProgressTracker;
import org.jboss.galleon.cli.tracking.ConfigsTracker;
import org.jboss.galleon.cli.tracking.ExtraConfigsTracker;
import org.jboss.galleon.cli.tracking.FindTracker;
import org.jboss.galleon.cli.tracking.JBossModulesTracker;
import org.jboss.galleon.cli.tracking.PackagesTracker;
import org.jboss.galleon.cli.tracking.UpdatesTracker;
import org.jboss.galleon.progresstracking.DefaultProgressTracker;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class ProgressTrackers {
    private static final Map<String, CliProgressTracker<?>> trackers = new HashMap();

    private ProgressTrackers() {
    }

    public static void registerTrackers(PmSession session) {
        ProgressTrackers.init(session);
        for (Map.Entry<String, CliProgressTracker<?>> entry : trackers.entrySet()) {
            session.getLayoutFactory().setProgressCallback(entry.getKey(), (ProgressCallback)entry.getValue());
        }
    }

    public static void unregisterTrackers(PmSession session) {
        for (Map.Entry<String, CliProgressTracker<?>> entry : trackers.entrySet()) {
            session.getLayoutFactory().setProgressCallback(entry.getKey(), null);
        }
    }

    public static void commandStart(PmCommandInvocation session) {
        ProgressTrackers.init(session.getPmSession());
        for (CliProgressTracker<?> tracker : trackers.values()) {
            tracker.commandStart(session);
        }
    }

    public static void commandEnd(PmCommandInvocation session) {
        ProgressTrackers.init(session.getPmSession());
        for (CliProgressTracker<?> tracker : trackers.values()) {
            tracker.commandEnd(session);
        }
    }

    private static void init(PmSession session) {
        if (trackers.isEmpty()) {
            BuildLayoutTracker layout = new BuildLayoutTracker(session);
            trackers.put("LAYOUT_BUILD", layout);
            PackagesTracker packages = new PackagesTracker(session);
            trackers.put("PACKAGES", packages);
            trackers.put("JBMODULES", new JBossModulesTracker(session));
            trackers.put("JBEXTRACONFIGS", new ExtraConfigsTracker(session));
            ConfigsTracker configs = new ConfigsTracker(session);
            trackers.put("CONFIGS", configs);
            UpdatesTracker updates = new UpdatesTracker(session);
            trackers.put("UPDATES", updates);
        }
    }

    public static ProgressTracker<FeaturePackLocation.FPID> newFindTracker(PmCommandInvocation invoc) {
        FindTracker findTracker = new FindTracker(invoc.getPmSession());
        findTracker.commandStart(invoc);
        DefaultProgressTracker<FeaturePackLocation.FPID> tracker = new DefaultProgressTracker<FeaturePackLocation.FPID>(findTracker);
        return tracker;
    }
}

