/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.installation;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.installation.AbstractInstallationCommand;

@CommandDefinition(name="set-history-limit", description="Set the history limit")
public class SetHistoryLimitCommand
extends AbstractInstallationCommand {
    @Argument(required=true, description="History maximum number of stored states")
    private String limit;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            int s;
            try {
                s = Integer.parseInt(this.limit);
            }
            catch (NumberFormatException ex) {
                throw new CommandExecutionException(CliErrors.invalidHistoryLimit(this.limit));
            }
            this.getManager(invoc.getPmSession()).setStateHistoryLimit(s);
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.setHistoryLimitFailed(), ex);
        }
    }
}

