"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyResultMapper = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const anomalyResultMapper = anomalyResults => {
  let resultData = {
    anomalies: [],
    featureData: {}
  };
  if (anomalyResults.length === 0) return resultData; //initialize features list.

  const firstAnomaly = anomalyResults[0];
  Object.values(firstAnomaly.featureData).forEach(feature => {
    resultData.featureData[feature.featureId] = [];
  });
  anomalyResults.forEach(({
    featureData,
    ...rest
  }) => {
    resultData.anomalies.push({ ...rest,
      anomalyGrade: rest.anomalyGrade != null && rest.anomalyGrade > 0 ? Number.parseFloat(rest.anomalyGrade).toFixed(2) : 0,
      confidence: rest.anomalyGrade != null && rest.anomalyGrade > 0 ? Number.parseFloat(rest.confidence).toFixed(2) : 0,
      plotTime: rest.dataStartTime + Math.floor((rest.dataEndTime - rest.dataStartTime) / 2)
    });
    featureData.forEach(feature => {
      resultData.featureData[feature.featureId].push({
        startTime: rest.dataStartTime,
        endTime: rest.dataEndTime,
        plotTime: rest.dataStartTime + Math.floor((rest.dataEndTime - rest.dataStartTime) / 2),
        data: feature.data
      });
    });
  });
  return resultData;
};

exports.anomalyResultMapper = anomalyResultMapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkSGVscGVycy5qcyJdLCJuYW1lcyI6WyJhbm9tYWx5UmVzdWx0TWFwcGVyIiwiYW5vbWFseVJlc3VsdHMiLCJyZXN1bHREYXRhIiwiYW5vbWFsaWVzIiwiZmVhdHVyZURhdGEiLCJsZW5ndGgiLCJmaXJzdEFub21hbHkiLCJPYmplY3QiLCJ2YWx1ZXMiLCJmb3JFYWNoIiwiZmVhdHVyZSIsImZlYXR1cmVJZCIsInJlc3QiLCJwdXNoIiwiYW5vbWFseUdyYWRlIiwiTnVtYmVyIiwicGFyc2VGbG9hdCIsInRvRml4ZWQiLCJjb25maWRlbmNlIiwicGxvdFRpbWUiLCJkYXRhU3RhcnRUaW1lIiwiTWF0aCIsImZsb29yIiwiZGF0YUVuZFRpbWUiLCJzdGFydFRpbWUiLCJlbmRUaW1lIiwiZGF0YSJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBRU8sTUFBTUEsbUJBQW1CLEdBQUlDLGNBQUQsSUFBb0I7QUFDckQsTUFBSUMsVUFBVSxHQUFHO0FBQ2ZDLElBQUFBLFNBQVMsRUFBRSxFQURJO0FBRWZDLElBQUFBLFdBQVcsRUFBRTtBQUZFLEdBQWpCO0FBSUEsTUFBSUgsY0FBYyxDQUFDSSxNQUFmLEtBQTBCLENBQTlCLEVBQWlDLE9BQU9ILFVBQVAsQ0FMb0IsQ0FNckQ7O0FBQ0EsUUFBTUksWUFBWSxHQUFHTCxjQUFjLENBQUMsQ0FBRCxDQUFuQztBQUNBTSxFQUFBQSxNQUFNLENBQUNDLE1BQVAsQ0FBY0YsWUFBWSxDQUFDRixXQUEzQixFQUF3Q0ssT0FBeEMsQ0FBaURDLE9BQUQsSUFBYTtBQUMzRFIsSUFBQUEsVUFBVSxDQUFDRSxXQUFYLENBQXVCTSxPQUFPLENBQUNDLFNBQS9CLElBQTRDLEVBQTVDO0FBQ0QsR0FGRDtBQUdBVixFQUFBQSxjQUFjLENBQUNRLE9BQWYsQ0FBdUIsQ0FBQztBQUFFTCxJQUFBQSxXQUFGO0FBQWUsT0FBR1E7QUFBbEIsR0FBRCxLQUE4QjtBQUNuRFYsSUFBQUEsVUFBVSxDQUFDQyxTQUFYLENBQXFCVSxJQUFyQixDQUEwQixFQUN4QixHQUFHRCxJQURxQjtBQUV4QkUsTUFBQUEsWUFBWSxFQUNWRixJQUFJLENBQUNFLFlBQUwsSUFBcUIsSUFBckIsSUFBNkJGLElBQUksQ0FBQ0UsWUFBTCxHQUFvQixDQUFqRCxHQUNJQyxNQUFNLENBQUNDLFVBQVAsQ0FBa0JKLElBQUksQ0FBQ0UsWUFBdkIsRUFBcUNHLE9BQXJDLENBQTZDLENBQTdDLENBREosR0FFSSxDQUxrQjtBQU14QkMsTUFBQUEsVUFBVSxFQUNSTixJQUFJLENBQUNFLFlBQUwsSUFBcUIsSUFBckIsSUFBNkJGLElBQUksQ0FBQ0UsWUFBTCxHQUFvQixDQUFqRCxHQUNJQyxNQUFNLENBQUNDLFVBQVAsQ0FBa0JKLElBQUksQ0FBQ00sVUFBdkIsRUFBbUNELE9BQW5DLENBQTJDLENBQTNDLENBREosR0FFSSxDQVRrQjtBQVV4QkUsTUFBQUEsUUFBUSxFQUFFUCxJQUFJLENBQUNRLGFBQUwsR0FBcUJDLElBQUksQ0FBQ0MsS0FBTCxDQUFXLENBQUNWLElBQUksQ0FBQ1csV0FBTCxHQUFtQlgsSUFBSSxDQUFDUSxhQUF6QixJQUEwQyxDQUFyRDtBQVZQLEtBQTFCO0FBWUFoQixJQUFBQSxXQUFXLENBQUNLLE9BQVosQ0FBcUJDLE9BQUQsSUFBYTtBQUMvQlIsTUFBQUEsVUFBVSxDQUFDRSxXQUFYLENBQXVCTSxPQUFPLENBQUNDLFNBQS9CLEVBQTBDRSxJQUExQyxDQUErQztBQUM3Q1csUUFBQUEsU0FBUyxFQUFFWixJQUFJLENBQUNRLGFBRDZCO0FBRTdDSyxRQUFBQSxPQUFPLEVBQUViLElBQUksQ0FBQ1csV0FGK0I7QUFHN0NKLFFBQUFBLFFBQVEsRUFBRVAsSUFBSSxDQUFDUSxhQUFMLEdBQXFCQyxJQUFJLENBQUNDLEtBQUwsQ0FBVyxDQUFDVixJQUFJLENBQUNXLFdBQUwsR0FBbUJYLElBQUksQ0FBQ1EsYUFBekIsSUFBMEMsQ0FBckQsQ0FIYztBQUk3Q00sUUFBQUEsSUFBSSxFQUFFaEIsT0FBTyxDQUFDZ0I7QUFKK0IsT0FBL0M7QUFNRCxLQVBEO0FBUUQsR0FyQkQ7QUFzQkEsU0FBT3hCLFVBQVA7QUFDRCxDQWxDTSIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuZXhwb3J0IGNvbnN0IGFub21hbHlSZXN1bHRNYXBwZXIgPSAoYW5vbWFseVJlc3VsdHMpID0+IHtcbiAgbGV0IHJlc3VsdERhdGEgPSB7XG4gICAgYW5vbWFsaWVzOiBbXSxcbiAgICBmZWF0dXJlRGF0YToge30sXG4gIH07XG4gIGlmIChhbm9tYWx5UmVzdWx0cy5sZW5ndGggPT09IDApIHJldHVybiByZXN1bHREYXRhO1xuICAvL2luaXRpYWxpemUgZmVhdHVyZXMgbGlzdC5cbiAgY29uc3QgZmlyc3RBbm9tYWx5ID0gYW5vbWFseVJlc3VsdHNbMF07XG4gIE9iamVjdC52YWx1ZXMoZmlyc3RBbm9tYWx5LmZlYXR1cmVEYXRhKS5mb3JFYWNoKChmZWF0dXJlKSA9PiB7XG4gICAgcmVzdWx0RGF0YS5mZWF0dXJlRGF0YVtmZWF0dXJlLmZlYXR1cmVJZF0gPSBbXTtcbiAgfSk7XG4gIGFub21hbHlSZXN1bHRzLmZvckVhY2goKHsgZmVhdHVyZURhdGEsIC4uLnJlc3QgfSkgPT4ge1xuICAgIHJlc3VsdERhdGEuYW5vbWFsaWVzLnB1c2goe1xuICAgICAgLi4ucmVzdCxcbiAgICAgIGFub21hbHlHcmFkZTpcbiAgICAgICAgcmVzdC5hbm9tYWx5R3JhZGUgIT0gbnVsbCAmJiByZXN0LmFub21hbHlHcmFkZSA+IDBcbiAgICAgICAgICA/IE51bWJlci5wYXJzZUZsb2F0KHJlc3QuYW5vbWFseUdyYWRlKS50b0ZpeGVkKDIpXG4gICAgICAgICAgOiAwLFxuICAgICAgY29uZmlkZW5jZTpcbiAgICAgICAgcmVzdC5hbm9tYWx5R3JhZGUgIT0gbnVsbCAmJiByZXN0LmFub21hbHlHcmFkZSA+IDBcbiAgICAgICAgICA/IE51bWJlci5wYXJzZUZsb2F0KHJlc3QuY29uZmlkZW5jZSkudG9GaXhlZCgyKVxuICAgICAgICAgIDogMCxcbiAgICAgIHBsb3RUaW1lOiByZXN0LmRhdGFTdGFydFRpbWUgKyBNYXRoLmZsb29yKChyZXN0LmRhdGFFbmRUaW1lIC0gcmVzdC5kYXRhU3RhcnRUaW1lKSAvIDIpLFxuICAgIH0pO1xuICAgIGZlYXR1cmVEYXRhLmZvckVhY2goKGZlYXR1cmUpID0+IHtcbiAgICAgIHJlc3VsdERhdGEuZmVhdHVyZURhdGFbZmVhdHVyZS5mZWF0dXJlSWRdLnB1c2goe1xuICAgICAgICBzdGFydFRpbWU6IHJlc3QuZGF0YVN0YXJ0VGltZSxcbiAgICAgICAgZW5kVGltZTogcmVzdC5kYXRhRW5kVGltZSxcbiAgICAgICAgcGxvdFRpbWU6IHJlc3QuZGF0YVN0YXJ0VGltZSArIE1hdGguZmxvb3IoKHJlc3QuZGF0YUVuZFRpbWUgLSByZXN0LmRhdGFTdGFydFRpbWUpIC8gMiksXG4gICAgICAgIGRhdGE6IGZlYXR1cmUuZGF0YSxcbiAgICAgIH0pO1xuICAgIH0pO1xuICB9KTtcbiAgcmV0dXJuIHJlc3VsdERhdGE7XG59O1xuIl19