/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;

public class PathsUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNewHome(Path homeDir) throws ProvisioningException {
        if (!Files.exists(homeDir, new LinkOption[0])) {
            return true;
        }
        if (!Files.isDirectory(homeDir, new LinkOption[0])) {
            throw new ProvisioningException(Errors.notADir(homeDir));
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(homeDir);){
            Iterator<Path> i = stream.iterator();
            boolean bl = !i.hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readDirectory(homeDir), e);
        }
    }

    public static void assertInstallationDir(Path path) throws ProvisioningException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new ProvisioningException(Errors.notADir(path));
        }
        try {
            Throwable throwable = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                Iterator<Path> i = stream.iterator();
                if (!i.hasNext()) {
                    return;
                }
                while (i.hasNext()) {
                    if (!i.next().getFileName().toString().equals(".galleon")) continue;
                    return;
                }
                try {
                    throw new ProvisioningException(Errors.homeDirNotUsable(path));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readDirectory(path), e);
        }
    }

    public static Path getProvisionedStateDir(Path home) {
        return home.resolve(".galleon");
    }

    public static Path getProvisioningXml(Path home) {
        return PathsUtils.getProvisionedStateDir(home).resolve("provisioning.xml");
    }

    public static Path getProvisionedStateXml(Path home) {
        return PathsUtils.getProvisionedStateDir(home).resolve("provisioned.xml");
    }

    public static Path getStateHistoryDir(Path home) {
        return PathsUtils.getProvisionedStateDir(home).resolve("history");
    }

    public static Path getStateHistoryFile(Path home) {
        return PathsUtils.getStateHistoryDir(home).resolve("list");
    }

    public static String toForwardSlashSeparator(String path) {
        if (File.separatorChar == '/') {
            return path;
        }
        return path.replace(File.separatorChar, '/');
    }
}

