/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ConfigCustomizations {
    protected final Boolean inheritConfigs;
    protected final boolean inheritModelOnlyConfigs;
    protected final Set<String> includedModels;
    protected final Map<String, Boolean> excludedModels;
    protected final Set<ConfigId> includedConfigs;
    protected final Set<ConfigId> excludedConfigs;
    protected final Map<ConfigId, ConfigModel> definedConfigs;
    protected final boolean hasModelOnlyConfigs;

    protected ConfigCustomizations(ConfigCustomizationsBuilder<?> builder) {
        this.inheritConfigs = builder.inheritConfigs;
        this.inheritModelOnlyConfigs = builder.inheritModelOnlyConfigs;
        this.includedModels = CollectionUtils.unmodifiable(builder.includedModels);
        this.excludedModels = CollectionUtils.unmodifiable(builder.excludedModels);
        this.includedConfigs = CollectionUtils.unmodifiable(builder.includedConfigs);
        this.excludedConfigs = CollectionUtils.unmodifiable(builder.excludedConfigs);
        this.definedConfigs = CollectionUtils.unmodifiable(builder.definedConfigs);
        this.hasModelOnlyConfigs = builder.hasModelOnlyConfigs;
    }

    public boolean isInheritConfigs(boolean defaultValue) {
        return this.inheritConfigs == null ? defaultValue : this.inheritConfigs;
    }

    public Boolean getInheritConfigs() {
        return this.inheritConfigs;
    }

    public boolean isInheritModelOnlyConfigs() {
        return this.inheritModelOnlyConfigs;
    }

    public boolean hasFullModelsIncluded() {
        return !this.includedModels.isEmpty();
    }

    public Set<String> getFullModelsIncluded() {
        return this.includedModels;
    }

    public boolean isConfigModelIncluded(ConfigId configId) {
        return this.includedModels.contains(configId.getModel());
    }

    public boolean hasFullModelsExcluded() {
        return !this.excludedModels.isEmpty();
    }

    public Map<String, Boolean> getFullModelsExcluded() {
        return this.excludedModels;
    }

    public boolean isConfigModelExcluded(ConfigId configId) {
        Boolean namedOnly = this.excludedModels.get(configId.getModel());
        if (namedOnly == null) {
            return false;
        }
        return namedOnly.booleanValue() ? configId.getName() != null : true;
    }

    public boolean hasExcludedConfigs() {
        return !this.excludedConfigs.isEmpty();
    }

    public boolean isConfigExcluded(ConfigId configId) {
        return this.excludedConfigs.contains(configId);
    }

    public Set<ConfigId> getExcludedConfigs() {
        return this.excludedConfigs;
    }

    public boolean hasIncludedConfigs() {
        return !this.includedConfigs.isEmpty();
    }

    public boolean isConfigIncluded(ConfigId id) {
        return this.includedConfigs.contains(id);
    }

    public Set<ConfigId> getIncludedConfigs() {
        return this.includedConfigs;
    }

    public boolean hasDefinedConfigs() {
        return !this.definedConfigs.isEmpty();
    }

    public Collection<ConfigModel> getDefinedConfigs() {
        return this.definedConfigs.values();
    }

    public boolean hasDefinedConfig(ConfigId configId) {
        return this.definedConfigs.containsKey(configId);
    }

    public ConfigModel getDefinedConfig(ConfigId configId) {
        return this.definedConfigs.get(configId);
    }

    public boolean hasModelOnlyConfigs() {
        return this.hasModelOnlyConfigs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definedConfigs == null ? 0 : this.definedConfigs.hashCode());
        result = 31 * result + (this.excludedConfigs == null ? 0 : this.excludedConfigs.hashCode());
        result = 31 * result + (this.excludedModels == null ? 0 : this.excludedModels.hashCode());
        result = 31 * result + (this.includedConfigs == null ? 0 : this.includedConfigs.hashCode());
        result = 31 * result + (this.includedModels == null ? 0 : this.includedModels.hashCode());
        result = 31 * result + (this.inheritConfigs == null ? 0 : this.inheritConfigs.hashCode());
        result = 31 * result + (this.inheritModelOnlyConfigs ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigCustomizations other = (ConfigCustomizations)obj;
        if (this.definedConfigs == null ? other.definedConfigs != null : !this.definedConfigs.equals(other.definedConfigs)) {
            return false;
        }
        if (this.excludedConfigs == null ? other.excludedConfigs != null : !this.excludedConfigs.equals(other.excludedConfigs)) {
            return false;
        }
        if (this.excludedModels == null ? other.excludedModels != null : !this.excludedModels.equals(other.excludedModels)) {
            return false;
        }
        if (this.includedConfigs == null ? other.includedConfigs != null : !this.includedConfigs.equals(other.includedConfigs)) {
            return false;
        }
        if (this.includedModels == null ? other.includedModels != null : !this.includedModels.equals(other.includedModels)) {
            return false;
        }
        if (this.inheritConfigs == null ? other.inheritConfigs != null : !this.inheritConfigs.equals(other.inheritConfigs)) {
            return false;
        }
        return this.inheritModelOnlyConfigs == other.inheritModelOnlyConfigs;
    }

    protected void append(StringBuilder builder) {
        if (this.inheritConfigs != null) {
            builder.append(" inheritConfigs=").append(this.inheritConfigs);
        }
        if (!this.inheritModelOnlyConfigs) {
            builder.append(" inheritModelOnlyConfigs=false");
        }
        if (!this.excludedModels.isEmpty()) {
            builder.append(" excludedModels ");
            StringUtils.append(builder, this.excludedModels.entrySet());
        }
        if (!this.includedModels.isEmpty()) {
            builder.append(" includedModels ");
            StringUtils.append(builder, this.includedModels);
        }
        if (!this.excludedConfigs.isEmpty()) {
            builder.append(" excludedConfigs ");
            StringUtils.append(builder, this.excludedConfigs);
        }
        if (!this.includedConfigs.isEmpty()) {
            builder.append(" includedConfigs ");
            StringUtils.append(builder, this.includedConfigs);
        }
        if (!this.definedConfigs.isEmpty()) {
            builder.append(" definedConfigs ");
            StringUtils.append(builder, this.definedConfigs.values());
        }
    }
}

