/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.util.PathsUtils;

public abstract class AbstractProvisionWithPlugins
extends AbstractDynamicCommand
implements CommandWithInstallationDirectory {
    public static final String DIR_OPTION_NAME = "dir";
    public static final String VERBOSE_OPTION_NAME = "verbose";

    protected AbstractProvisionWithPlugins(PmSession pmSession) {
        super(pmSession, true);
    }

    protected abstract List<ProcessedOption> getOtherOptions() throws OptionParserException;

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name(DIR_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Installation directory").completer(FileOptionCompleter.class).build());
        options.add(ProcessedOptionBuilder.builder().name(VERBOSE_OPTION_NAME).hasValue(false).type(Boolean.class).description("Whether or not the output should be verbose").optionType(OptionType.BOOLEAN).build());
        options.addAll(this.getOtherOptions());
        return options;
    }

    protected boolean isVerbose() {
        return this.contains(VERBOSE_OPTION_NAME);
    }

    private String getDir() {
        return (String)this.getValue(DIR_OPTION_NAME);
    }

    protected ProvisioningManager getManager(PmCommandInvocation session) throws ProvisioningException, IOException {
        return session.getPmSession().newProvisioningManager(this.getAbsolutePath(this.getDir(), session.getConfiguration().getAeshContext()), this.isVerbose());
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        try {
            return this.getAbsolutePath(this.getDir(), context);
        }
        catch (IOException ex) {
            CliLogging.exception(ex);
            return null;
        }
    }

    protected Path getAbsolutePath(String path, AeshContext context) throws IOException {
        return path == null ? PmSession.getWorkDir(context) : Util.resolvePath(context, path);
    }

    protected abstract void doRunCommand(PmCommandInvocation var1, Map<String, String> var2) throws CommandExecutionException;

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        if (this.isVerbose()) {
            session.getPmSession().enableMavenTrace(true);
        }
        try {
            this.doRunCommand(session, options);
        }
        finally {
            session.getPmSession().enableMavenTrace(false);
        }
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        String targetDirArg = (String)this.getValue(DIR_OPTION_NAME);
        if (targetDirArg == null) {
            targetDirArg = this.getOptionValue(DIR_OPTION_NAME);
        }
        if (targetDirArg != null) {
            return true;
        }
        Path workDir = PmSession.getWorkDir(pmSession.getAeshContext());
        return Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0]);
    }
}

