/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.reference;

import javax.annotation.Nonnull;
import org.jf.dexlib2.base.reference.BaseStringReference;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.iface.reference.Reference;

public class DexBackedStringReference
extends BaseStringReference {
    @Nonnull
    public final DexBackedDexFile dexFile;
    public final int stringIndex;

    public DexBackedStringReference(@Nonnull DexBackedDexFile dexBuf, int stringIndex) {
        this.dexFile = dexBuf;
        this.stringIndex = stringIndex;
    }

    @Override
    @Nonnull
    public String getString() {
        return (String)this.dexFile.getStringSection().get(this.stringIndex);
    }

    public int getSize() {
        int size = 4;
        int stringOffset = this.dexFile.getStringSection().getOffset(this.stringIndex);
        int stringDataOffset = this.dexFile.getBuffer().readSmallUint(stringOffset);
        DexReader reader = this.dexFile.getDataBuffer().readerAt(stringDataOffset);
        size += reader.peekSmallUleb128Size();
        int utf16Length = reader.readSmallUleb128();
        return size += reader.peekStringLength(utf16Length);
    }

    @Override
    public void validateReference() throws Reference.InvalidReferenceException {
        if (this.stringIndex < 0 || this.stringIndex >= this.dexFile.getStringSection().size()) {
            throw new Reference.InvalidReferenceException("string@" + this.stringIndex);
        }
    }
}

