/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ConfigurableReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.testing.jacoco.tasks.JacocoCoverageVerification;
import org.gradle.testing.jacoco.tasks.JacocoMerge;
import org.gradle.testing.jacoco.tasks.JacocoReport;

public class JacocoPlugin
implements Plugin<Project> {
    public static final String DEFAULT_JACOCO_VERSION = "0.8.5";
    public static final String AGENT_CONFIGURATION_NAME = "jacocoAgent";
    public static final String ANT_CONFIGURATION_NAME = "jacocoAnt";
    public static final String PLUGIN_EXTENSION_NAME = "jacoco";
    private final Instantiator instantiator;
    private Project project;

    @Inject
    public JacocoPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        this.project = project;
        this.addJacocoConfigurations();
        ProjectInternal projectInternal = (ProjectInternal)project;
        JacocoAgentJar agent = (JacocoAgentJar)this.instantiator.newInstance(JacocoAgentJar.class, new Object[]{projectInternal.getServices().get(FileOperations.class)});
        JacocoPluginExtension extension = (JacocoPluginExtension)project.getExtensions().create(PLUGIN_EXTENSION_NAME, JacocoPluginExtension.class, new Object[]{project, agent});
        extension.setToolVersion(DEFAULT_JACOCO_VERSION);
        final ReportingExtension reportingExtension = (ReportingExtension)project.getExtensions().getByName("reporting");
        extension.setReportsDir((Provider<File>)project.provider((Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return reportingExtension.file(JacocoPlugin.PLUGIN_EXTENSION_NAME);
            }
        }));
        this.configureAgentDependencies(agent, extension);
        this.configureTaskClasspathDefaults(extension);
        this.applyToDefaultTasks(extension);
        this.configureDefaultOutputPathForJacocoMerge();
        this.configureJacocoReportsDefaults(extension);
        this.addDefaultReportAndCoverageVerificationTasks(extension);
    }

    private void addJacocoConfigurations() {
        Configuration agentConf = (Configuration)this.project.getConfigurations().create(AGENT_CONFIGURATION_NAME);
        agentConf.setVisible(false);
        agentConf.setTransitive(true);
        agentConf.setDescription("The Jacoco agent to use to get coverage data.");
        Configuration antConf = (Configuration)this.project.getConfigurations().create(ANT_CONFIGURATION_NAME);
        antConf.setVisible(false);
        antConf.setTransitive(true);
        antConf.setDescription("The Jacoco ant tasks to use to get execute Gradle tasks.");
    }

    private void configureAgentDependencies(JacocoAgentJar jacocoAgentJar, final JacocoPluginExtension extension) {
        Configuration config = this.project.getConfigurations().getAt(AGENT_CONFIGURATION_NAME);
        jacocoAgentJar.setAgentConf((FileCollection)config);
        config.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)JacocoPlugin.this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.agent:" + extension.getToolVersion())));
            }
        });
    }

    private void configureTaskClasspathDefaults(final JacocoPluginExtension extension) {
        final Configuration config = this.project.getConfigurations().getAt(ANT_CONFIGURATION_NAME);
        this.project.getTasks().withType(JacocoBase.class).configureEach((Action)new Action<JacocoBase>(){

            public void execute(JacocoBase task) {
                task.setJacocoClasspath((FileCollection)config);
            }
        });
        config.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)JacocoPlugin.this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.ant:" + extension.getToolVersion())));
            }
        });
    }

    private void applyToDefaultTasks(final JacocoPluginExtension extension) {
        this.project.getTasks().withType(Test.class).configureEach((Action)new Action<Test>(){

            public void execute(Test task) {
                extension.applyTo(task);
            }
        });
    }

    private void configureDefaultOutputPathForJacocoMerge() {
        this.project.getTasks().withType(JacocoMerge.class).configureEach((Action)new Action<JacocoMerge>(){

            public void execute(final JacocoMerge task) {
                task.setDestinationFile((Provider<File>)JacocoPlugin.this.project.provider((Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(JacocoPlugin.this.project.getBuildDir(), "/jacoco/" + task.getName() + ".exec");
                    }
                }));
            }
        });
    }

    private void configureJacocoReportsDefaults(final JacocoPluginExtension extension) {
        this.project.getTasks().withType(JacocoReport.class).configureEach((Action)new Action<JacocoReport>(){

            public void execute(JacocoReport reportTask) {
                JacocoPlugin.this.configureJacocoReportDefaults(extension, reportTask);
            }
        });
    }

    private Action<ConfigurableReport> configureReportOutputDirectory(final JacocoPluginExtension extension, final JacocoReport reportTask) {
        return new Action<ConfigurableReport>(){

            public void execute(final ConfigurableReport report) {
                if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                    report.setDestination(JacocoPlugin.this.project.provider((Callable)new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            return new File(extension.getReportsDir(), reportTask.getName() + "/" + report.getName());
                        }
                    }));
                } else {
                    report.setDestination(JacocoPlugin.this.project.provider((Callable)new Callable<File>(){

                        @Override
                        public File call() throws Exception {
                            return new File(extension.getReportsDir(), reportTask.getName() + "/" + reportTask.getName() + "." + report.getName());
                        }
                    }));
                }
            }
        };
    }

    private void configureJacocoReportDefaults(JacocoPluginExtension extension, JacocoReport reportTask) {
        reportTask.getReports().all((Action)new Action<ConfigurableReport>(){

            public void execute(final ConfigurableReport report) {
                report.setEnabled(JacocoPlugin.this.project.provider((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return report.getName().equals("html");
                    }
                }));
            }
        });
        reportTask.getReports().all(this.configureReportOutputDirectory(extension, reportTask));
    }

    private void addDefaultReportAndCoverageVerificationTasks(final JacocoPluginExtension extension) {
        this.project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TaskProvider testTaskProvider = JacocoPlugin.this.project.getTasks().named("test");
                JacocoPlugin.this.addDefaultReportTask(extension, (TaskProvider<Task>)testTaskProvider);
                JacocoPlugin.this.addDefaultCoverageVerificationTask((TaskProvider<Task>)testTaskProvider);
            }
        });
    }

    private void addDefaultReportTask(final JacocoPluginExtension extension, final TaskProvider<Task> testTaskProvider) {
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME + StringUtils.capitalize((String)testTaskProvider.getName()) + "Report", JacocoReport.class, (Action)new Action<JacocoReport>(){

            public void execute(final JacocoReport reportTask) {
                reportTask.setGroup("verification");
                reportTask.setDescription(String.format("Generates code coverage report for the %s task.", testTaskProvider.getName()));
                reportTask.executionData((Task)testTaskProvider.get());
                reportTask.sourceSets((SourceSet)((SourceSetContainer)JacocoPlugin.this.project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
                reportTask.getReports().all((Action)new Action<ConfigurableReport>(){

                    public void execute(final ConfigurableReport report) {
                        if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                            report.setDestination(JacocoPlugin.this.project.provider((Callable)new Callable<File>(){

                                @Override
                                public File call() throws Exception {
                                    return new File(extension.getReportsDir(), testTaskProvider.getName() + "/" + report.getName());
                                }
                            }));
                        } else {
                            report.setDestination(JacocoPlugin.this.project.provider((Callable)new Callable<File>(){

                                @Override
                                public File call() throws Exception {
                                    return new File(extension.getReportsDir(), testTaskProvider.getName() + "/" + reportTask.getName() + "." + report.getName());
                                }
                            }));
                        }
                    }
                });
            }
        });
    }

    private void addDefaultCoverageVerificationTask(final TaskProvider<Task> testTaskProvider) {
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME + StringUtils.capitalize((String)testTaskProvider.getName()) + "CoverageVerification", JacocoCoverageVerification.class, (Action)new Action<JacocoCoverageVerification>(){

            public void execute(JacocoCoverageVerification coverageVerificationTask) {
                coverageVerificationTask.setGroup("verification");
                coverageVerificationTask.setDescription(String.format("Verifies code coverage metrics based on specified rules for the %s task.", testTaskProvider.getName()));
                coverageVerificationTask.executionData((Task)testTaskProvider.get());
                coverageVerificationTask.sourceSets((SourceSet)((SourceSetContainer)JacocoPlugin.this.project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
            }
        });
    }
}

