/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.rdfxml.RdfXmlParser;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.GraphQueryResultListener;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.QueryResultsGraphBuilder;
import org.openrdf.sesame.query.QueryResultsTable;
import org.openrdf.sesame.query.QueryResultsTableBuilder;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalRepositoryChangedListener;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.SailChangedEvent;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.memory.MemNamespaceIterator;
import org.openrdf.sesame.sailimpl.memory.Namespace;
import virtuoso.jdbc3.VirtuosoResultSet;

public class VirtuosoRepository
implements SesameRepository {
    private String _id;
    private String url;
    private String user;
    private String password;
    private Connection connection = null;
    private List _listeners;
    private String graphName;
    protected ValueFactory _valueFactory;

    public VirtuosoRepository(String string, String string2, String string3, String string4) {
        this._id = string2 + ":" + string;
        this._valueFactory = new ValueFactoryImpl();
        this.graphName = string;
        this.url = string2;
        this.user = string3;
        this.password = string4;
        if (this.connection == null) {
            try {
                this.connection = DriverManager.getConnection(this.url, this.user, this.password);
            }
            catch (Exception exception) {
                System.out.println("VirtuosoRepository.init() Connection to " + string2 + " is FAILED.");
                exception.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public boolean hasReadAccess() {
        return true;
    }

    public boolean hasWriteAccess() {
        return true;
    }

    public QueryResultsTable performTableQuery(QueryLanguage queryLanguage, String string) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        QueryResultsTableBuilder queryResultsTableBuilder = new QueryResultsTableBuilder();
        this.performTableQuery(queryLanguage, string, (TableQueryResultListener)queryResultsTableBuilder);
        return queryResultsTableBuilder.getQueryResultsTable();
    }

    public void performTableQuery(QueryLanguage queryLanguage, String string, TableQueryResultListener tableQueryResultListener) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        string = "SPARQL " + string;
        try {
            int n;
            Statement statement = this.connection.createStatement();
            VirtuosoResultSet virtuosoResultSet = (VirtuosoResultSet)statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = virtuosoResultSet.getMetaData();
            String[] stringArray = new String[resultSetMetaData.getColumnCount()];
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
                stringArray[n] = resultSetMetaData.getColumnLabel(n + 1);
            }
            tableQueryResultListener.startTableQueryResult(stringArray);
            while (virtuosoResultSet.next()) {
                tableQueryResultListener.startTuple();
                for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                    String string2 = resultSetMetaData.getColumnName(n);
                    String string3 = virtuosoResultSet.getString(string2);
                    Value value = this.parseValue(string3);
                    tableQueryResultListener.tupleValue(value);
                }
                tableQueryResultListener.endTuple();
            }
            tableQueryResultListener.endTableQueryResult();
        }
        catch (Exception exception) {
            System.out.println("VirtuosoRepository.performTableQuery() GET results are FAILED.");
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public void addData(URL uRL, String string, RDFFormat rDFFormat, boolean bl, AdminListener adminListener) throws IOException, AccessDeniedException {
        if (string == null) {
            string = this.graphName;
        }
        String string2 = "sparql load \"" + uRL + "\" into graph <" + this.graphName + ">";
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public void clear(AdminListener adminListener) throws IOException, AccessDeniedException {
        try {
            String string = "delete from RDF_QUAD where G=DB.DBA.RDF_MAKE_IID_OF_QNAME ('" + this.graphName + "')";
            Statement statement = this.connection.createStatement();
            statement.executeUpdate(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(InputStream inputStream, String string, RDFFormat rDFFormat, boolean bl, AdminListener adminListener) throws IOException, AccessDeniedException {
        try {
            TurtleParser turtleParser = null;
            HashMap hashMap = new HashMap();
            if (rDFFormat.equals((Object)RDFFormat.TURTLE)) {
                turtleParser = new TurtleParser();
            } else if (rDFFormat.equals((Object)RDFFormat.RDFXML)) {
                turtleParser = new RdfXmlParser();
            } else if (rDFFormat.equals((Object)RDFFormat.NTRIPLES)) {
                turtleParser = new NTriplesParser();
            } else {
                return;
            }
            turtleParser.setDatatypeHandling(10);
            StatementHandler statementHandler = new StatementHandler(){

                public void handleStatement(Resource resource, URI uRI, Value value) {
                    VirtuosoRepository.this.addSingleStatement(resource, uRI, value);
                }
            };
            turtleParser.setStatementHandler(statementHandler);
            turtleParser.parse(inputStream, string);
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        finally {
            inputStream.close();
        }
    }

    public void addData(File file, String string, RDFFormat rDFFormat, boolean bl, AdminListener adminListener) throws FileNotFoundException, IOException, AccessDeniedException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.addData(fileInputStream, string, rDFFormat, bl, adminListener);
    }

    public NamespaceIterator getNamespaces() {
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT distinct RP_NAME, RP_ID from DB.DBA.RDF_PREFIX");
        try {
            Statement statement = this.connection.createStatement();
            VirtuosoResultSet virtuosoResultSet = (VirtuosoResultSet)statement.executeQuery(stringBuffer.toString());
            ResultSetMetaData resultSetMetaData = virtuosoResultSet.getMetaData();
            while (virtuosoResultSet.next()) {
                String string = null;
                String string2 = null;
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string3 = resultSetMetaData.getColumnName(i);
                    if (string3.equals("RP_ID")) {
                        string = virtuosoResultSet.getString(string3);
                        continue;
                    }
                    if (!string3.equals("RP_NAME")) continue;
                    string2 = virtuosoResultSet.getString(string3);
                }
                if (string == null || string2 == null) continue;
                Namespace namespace = new Namespace(string2, string, false);
                arrayList.add(namespace);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        return new MemNamespaceIterator(arrayList);
    }

    public void addSingleStatement(Resource resource, URI uRI, Value value) {
        String string = resource.toString();
        String string2 = uRI.toString();
        String string3 = value.toString();
        string = string.replaceAll("'", "''");
        string2 = string2.replaceAll("'", "''");
        string3 = string3.replaceAll("'", "''");
        String string4 = "DB.DBA.RDF_QUAD_URI ('" + this.graphName + "', '" + string + "', '" + string2 + "', '" + string3 + "')";
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate(string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public void performGraphQuery(QueryLanguage queryLanguage, String string, GraphQueryResultListener graphQueryResultListener) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        string = "SPARQL " + string;
        try {
            Statement statement = this.connection.createStatement();
            VirtuosoResultSet virtuosoResultSet = (VirtuosoResultSet)statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = virtuosoResultSet.getMetaData();
            String[] stringArray = new String[resultSetMetaData.getColumnCount()];
            while (virtuosoResultSet.next()) {
                graphQueryResultListener.startGraphQueryResult();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    String string2 = resultSetMetaData.getColumnName(i);
                    String string3 = virtuosoResultSet.getString(string2);
                    Value value = this.parseValue(string3);
                    graphQueryResultListener.triple(null, null, null);
                }
                graphQueryResultListener.endGraphQueryResult();
            }
            graphQueryResultListener.endGraphQueryResult();
        }
        catch (Exception exception) {
            System.out.println("GET results are FAILED.");
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public Graph performGraphQuery(QueryLanguage queryLanguage, String string) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        QueryResultsGraphBuilder queryResultsGraphBuilder = new QueryResultsGraphBuilder();
        this.performGraphQuery(queryLanguage, string, (GraphQueryResultListener)queryResultsGraphBuilder);
        return queryResultsGraphBuilder.getGraph();
    }

    public void addData(String string, String string2, RDFFormat rDFFormat, boolean bl, AdminListener adminListener) throws IOException, AccessDeniedException {
        this.addData(new StringReader(string), string2, rDFFormat, bl, adminListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(SesameRepository sesameRepository, AdminListener adminListener) throws IOException, AccessDeniedException {
        if (this == sesameRepository) {
            return;
        }
        InputStream inputStream = sesameRepository.extractRDF(RDFFormat.RDFXML, true, true, true, false);
        try {
            this.addData(inputStream, "foo:bar", RDFFormat.RDFXML, false, adminListener);
        }
        finally {
            inputStream.close();
        }
    }

    public void addData(Reader reader, String string, RDFFormat rDFFormat, boolean bl, AdminListener adminListener) throws IOException, AccessDeniedException {
    }

    public InputStream extractRDF(RDFFormat rDFFormat, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, AccessDeniedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8092);
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public void extractRDF(RdfDocumentWriter rdfDocumentWriter, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, AccessDeniedException {
    }

    public void removeStatements(Resource resource, URI uRI, Value value, AdminListener adminListener) throws IOException, AccessDeniedException {
        String string = resource.toString();
        String string2 = uRI.toString();
        String string3 = value.toString();
        String string4 = "jena_remove ('" + this.graphName + "', " + "'" + string + "', " + "'" + string2 + "', " + "'" + string3 + "')";
        try {
            Statement statement = this.connection.createStatement();
            statement.executeUpdate(string4);
        }
        catch (Exception exception) {
            adminListener.error("Problem removing data", 0, 0, (org.openrdf.model.Statement)new StatementImpl(resource, uRI, value));
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public synchronized void shutDown() {
    }

    public void mergeGraph(Graph graph) throws IOException, AccessDeniedException {
        StatementIterator statementIterator = graph.getStatements();
        while (statementIterator.hasNext()) {
            org.openrdf.model.Statement statement = statementIterator.next();
            Resource resource = statement.getSubject();
            URI uRI = statement.getPredicate();
            Value value = statement.getObject();
            this.addSingleStatement(resource, uRI, value);
        }
        statementIterator.close();
    }

    public void addGraph(Graph graph) throws IOException, AccessDeniedException {
        this.addGraph(graph, true);
    }

    public void addGraph(Graph graph, boolean bl) throws IOException, AccessDeniedException {
        HashMap hashMap = null;
        ValueFactory valueFactory = null;
        if (!bl) {
            hashMap = new HashMap();
            valueFactory = this.getValueFactory();
        }
        StatementIterator statementIterator = graph.getStatements();
        while (statementIterator.hasNext()) {
            org.openrdf.model.Statement statement = statementIterator.next();
            Object object = statement.getSubject();
            URI uRI = statement.getPredicate();
            Object object2 = statement.getObject();
            if (!bl) {
                String string;
                if (object instanceof BNode) {
                    string = ((BNode)object).getID();
                    object = hashMap.containsKey(string) ? (Resource)hashMap.get(string) : valueFactory.createBNode();
                }
                if (object2 instanceof BNode) {
                    string = ((BNode)object2).getID();
                    object2 = hashMap.containsKey(string) ? (Resource)hashMap.get(string) : valueFactory.createBNode();
                }
            }
            this.addSingleStatement((Resource)object, uRI, (Value)object2);
        }
        statementIterator.close();
    }

    public void removeGraph(Graph graph) throws IOException, AccessDeniedException {
        StatementIterator statementIterator = graph.getStatements();
        while (statementIterator.hasNext()) {
            org.openrdf.model.Statement statement = statementIterator.next();
            for (int i = 0; i < this._listeners.size(); ++i) {
                if (!(this._listeners.get(i) instanceof AdminListener)) continue;
                this.removeStatements(statement.getSubject(), statement.getPredicate(), statement.getObject(), (AdminListener)this._listeners.get(i));
            }
        }
    }

    public void addGraph(QueryLanguage queryLanguage, String string) throws IOException, AccessDeniedException {
    }

    public void addGraph(QueryLanguage queryLanguage, String string, boolean bl) throws IOException, AccessDeniedException {
        try {
            Graph graph = this.performGraphQuery(queryLanguage, string);
            this.addGraph(graph, bl);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            throw new IOException(queryEvaluationException.getMessage());
        }
        catch (MalformedQueryException malformedQueryException) {
            throw new IOException(malformedQueryException.getMessage());
        }
    }

    public void removeGraph(QueryLanguage queryLanguage, String string) throws IOException, AccessDeniedException {
        try {
            Graph graph = this.performGraphQuery(queryLanguage, string);
            this.removeGraph(graph);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            throw new IOException(queryEvaluationException.getMessage());
        }
        catch (MalformedQueryException malformedQueryException) {
            throw new IOException(malformedQueryException.getMessage());
        }
    }

    public String getRepositoryId() {
        return this._id;
    }

    public String getRepository(String string) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LocalRepositoryChangedListener localRepositoryChangedListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(localRepositoryChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LocalRepositoryChangedListener localRepositoryChangedListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(localRepositoryChangedListener);
        }
    }

    public void sailChanged(SailChangedEvent sailChangedEvent) {
    }

    public ValueFactory getValueFactory() {
        return this._valueFactory;
    }

    private Value parseValue(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return new URIImpl(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return new LiteralImpl(string);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    return new BNodeImpl(string);
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    System.out.println("VirtuosoRepository.parseValue() Could not parse resource: " + string);
                    return null;
                }
            }
        }
    }

    static {
        try {
            Class.forName("virtuoso.jdbc3.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }
}

