/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.ref.DebugReflectionUtil;

class CachedValueLeakChecker {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.CachedValueChecker");
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static final Set<String> ourCheckedKeys = ContainerUtil.newConcurrentSet();

    static void checkProvider(@NotNull CachedValueProvider provider, @NotNull Key key, @NotNull UserDataHolder userDataHolder) {
        if (provider == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(0);
        }
        if (key == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(1);
        }
        if (userDataHolder == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(2);
        }
        if (!DO_CHECKS || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        if (!ourCheckedKeys.add(key.toString())) {
            return;
        }
        if (!SystemInfo.IS_AT_LEAST_JAVA9) {
            CachedValueLeakChecker.findReferencedPsi(provider, key, userDataHolder, 5);
        }
    }

    private static synchronized void findReferencedPsi(@NotNull Object root2, @NotNull Key key, @NotNull UserDataHolder toIgnore, int depth) {
        if (root2 == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(3);
        }
        if (key == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(4);
        }
        if (toIgnore == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(5);
        }
        Condition<Object> shouldExamineValue = value2 -> {
            if (value2 == toIgnore) {
                return false;
            }
            if (value2 instanceof ASTNode && (value2 = ((ASTNode)value2).getPsi()) == toIgnore) {
                return false;
            }
            if (value2 instanceof Project || value2 instanceof Module || value2 instanceof Application) {
                return false;
            }
            return !(value2 instanceof PsiElement) || !(toIgnore instanceof PsiElement) || ((PsiElement)toIgnore).getContainingFile() == null || !PsiTreeUtil.isAncestor((PsiElement)value2, (PsiElement)toIgnore, true);
        };
        Map<Object, String> roots2 = Collections.singletonMap(root2, "CachedValueProvider " + key);
        DebugReflectionUtil.walkObjects(depth, roots2, PsiElement.class, shouldExamineValue, (value2, backLink) -> {
            if (value2 instanceof PsiElement) {
                LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access, provider=" + root2 + "\n" + backLink);
                return false;
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValueLeakChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencedPsi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

