"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var d3_random_1 = require("d3-random");
function randomizeData(data, randomizedFields, randomizer, allowNegative) {
    return data.map(function (datum) {
        var randomizedData = randomizedFields.reduce(function (acc, randomizedField) {
            var value = randomizer(datum[randomizedField]);
            acc[randomizedField] = allowNegative ? value : Math.abs(value);
            return acc;
        }, {});
        return __assign(__assign({}, datum), randomizedData);
    });
}
exports.randomizeData = randomizeData;
exports.uniformRandomizer = function (amplitude) { return function (value) {
    return value + d3_random_1.randomUniform(-amplitude / 2, amplitude / 2)();
}; };
//# sourceMappingURL=randomizers.js.map