"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../state/utils");
exports.DEFAULT_SNAP_POSITION_BAND = 1;
function getSnapPosition(value, scale, totalBarsInCluster) {
    if (totalBarsInCluster === void 0) { totalBarsInCluster = 1; }
    var position = scale.scale(value);
    if (position === undefined) {
        return;
    }
    if (scale.bandwidth > 0) {
        var band = scale.bandwidth / (1 - scale.barsPadding);
        var halfPadding = (band - scale.bandwidth) / 2;
        return {
            position: position - halfPadding * totalBarsInCluster,
            band: band * totalBarsInCluster,
        };
    }
    else {
        return {
            position: position,
            band: exports.DEFAULT_SNAP_POSITION_BAND,
        };
    }
}
exports.getSnapPosition = getSnapPosition;
function getCursorLinePosition(chartRotation, chartDimensions, projectedPointerPosition) {
    var x = projectedPointerPosition.x, y = projectedPointerPosition.y;
    if (x < 0 || y < 0) {
        return void 0;
    }
    var left = chartDimensions.left, top = chartDimensions.top, width = chartDimensions.width, height = chartDimensions.height;
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    if (isHorizontalRotated) {
        var crosshairTop = projectedPointerPosition.y + top;
        return {
            left: left,
            width: width,
            top: crosshairTop,
            height: 0,
        };
    }
    else {
        var crosshairLeft = projectedPointerPosition.x + left;
        return {
            top: top,
            left: crosshairLeft,
            width: 0,
            height: height,
        };
    }
}
exports.getCursorLinePosition = getCursorLinePosition;
function getCursorBandPosition(chartRotation, chartDimensions, cursorPosition, invertedValue, snapEnabled, xScale, totalBarsInCluster) {
    var top = chartDimensions.top, left = chartDimensions.left, width = chartDimensions.width, height = chartDimensions.height;
    var x = cursorPosition.x, y = cursorPosition.y;
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    var chartWidth = isHorizontalRotated ? width : height;
    var chartHeight = isHorizontalRotated ? height : width;
    if (x > chartWidth || y > chartHeight || x < 0 || y < 0 || !invertedValue.withinBandwidth) {
        return {
            top: -1,
            left: -1,
            width: 0,
            height: 0,
            visible: false,
        };
    }
    var snappedPosition = getSnapPosition(invertedValue.value, xScale, totalBarsInCluster);
    if (!snappedPosition) {
        return {
            top: -1,
            left: -1,
            width: 0,
            height: 0,
            visible: false,
        };
    }
    var position = snappedPosition.position, band = snappedPosition.band;
    var bandOffset = xScale.bandwidth > 0 ? band : 0;
    if (isHorizontalRotated) {
        var adjustedLeft = snapEnabled ? position : cursorPosition.x;
        var leftPosition = chartRotation === 0 ? left + adjustedLeft : left + width - adjustedLeft - bandOffset;
        var adjustedWidth = band;
        if (band > 1 && leftPosition + band > left + width) {
            adjustedWidth = left + width - leftPosition;
        }
        else if (band > 1 && leftPosition < left) {
            adjustedWidth = band - (left - leftPosition);
            leftPosition = left;
        }
        return {
            top: top,
            left: leftPosition,
            width: adjustedWidth,
            height: height,
            visible: true,
        };
    }
    else {
        var adjustedTop = snapEnabled ? position : cursorPosition.x;
        var topPosition = chartRotation === 90 ? top + adjustedTop : height + top - adjustedTop - bandOffset;
        var adjustedHeight = band;
        if (band > 1 && topPosition + band > top + height) {
            adjustedHeight = band - (topPosition + band - (top + height));
        }
        else if (band > 1 && topPosition < top) {
            adjustedHeight = band - (top - topPosition);
            topPosition = top;
        }
        return {
            top: topPosition,
            left: left,
            width: width,
            height: adjustedHeight,
            visible: true,
        };
    }
}
exports.getCursorBandPosition = getCursorBandPosition;
function getTooltipPosition(chartDimensions, chartRotation, cursorBandPosition, cursorPosition, isSingleValueXScale) {
    var isHorizontalRotated = utils_1.isHorizontalRotation(chartRotation);
    var hPosition = getHorizontalTooltipPosition(cursorPosition.x, cursorBandPosition, chartDimensions, isHorizontalRotated, isSingleValueXScale);
    var vPosition = getVerticalTooltipPosition(cursorPosition.y, cursorBandPosition, chartDimensions, isHorizontalRotated, isSingleValueXScale);
    return {
        isRotatedHorizontal: isHorizontalRotated,
        vPosition: vPosition,
        hPosition: hPosition,
    };
}
exports.getTooltipPosition = getTooltipPosition;
function getHorizontalTooltipPosition(cursorXPosition, cursorBandPosition, chartDimensions, isHorizontalRotated, isSingleValueXScale) {
    if (isHorizontalRotated) {
        return {
            bandLeft: cursorBandPosition.left,
            bandWidth: isSingleValueXScale ? 0 : cursorBandPosition.width,
        };
    }
    else {
        return {
            bandWidth: 0,
            bandLeft: chartDimensions.left + cursorXPosition,
        };
    }
}
function getVerticalTooltipPosition(cursorYPosition, cursorBandPosition, chartDimensions, isHorizontalRotated, isSingleValueXScale) {
    if (isHorizontalRotated) {
        return {
            bandHeight: 0,
            bandTop: cursorYPosition + chartDimensions.top,
        };
    }
    else {
        return {
            bandHeight: isSingleValueXScale ? 0 : cursorBandPosition.height,
            bandTop: cursorBandPosition.top,
        };
    }
}
function getFinalTooltipPosition(
/** the dimensions of the chart parent container */
container, 
/** the dimensions of the tooltip container */
tooltip, 
/** the tooltip computed position not adjusted within chart bounds */
tooltipPosition, 
/** the padding to add between the tooltip position and the final position */
padding) {
    if (padding === void 0) { padding = 10; }
    var hPosition = tooltipPosition.hPosition, vPosition = tooltipPosition.vPosition, isHorizontalRotated = tooltipPosition.isRotatedHorizontal;
    var left = 0;
    var top = 0;
    if (isHorizontalRotated) {
        var leftOfBand = window.pageXOffset + container.left + hPosition.bandLeft;
        if (hPosition.bandLeft + hPosition.bandWidth + tooltip.width + padding > container.width) {
            left = leftOfBand - tooltip.width - padding;
        }
        else {
            left = leftOfBand + hPosition.bandWidth + padding;
        }
        var topOfBand = window.pageYOffset + container.top;
        if (vPosition.bandTop + tooltip.height > container.height) {
            top = topOfBand + container.height - tooltip.height;
        }
        else {
            top = topOfBand + vPosition.bandTop;
        }
    }
    else {
        var leftOfBand = window.pageXOffset + container.left;
        if (hPosition.bandLeft + hPosition.bandWidth + tooltip.width > container.width) {
            left = leftOfBand + container.width - tooltip.width;
        }
        else {
            left = leftOfBand + hPosition.bandLeft + hPosition.bandWidth;
        }
        var topOfBand = window.pageYOffset + container.top + vPosition.bandTop;
        if (vPosition.bandTop + vPosition.bandHeight + tooltip.height + padding > container.height) {
            top = topOfBand - tooltip.height - padding;
        }
        else {
            top = topOfBand + vPosition.bandHeight + padding;
        }
    }
    return {
        left: Math.round(left) + "px",
        top: Math.round(top) + "px",
    };
}
exports.getFinalTooltipPosition = getFinalTooltipPosition;
//# sourceMappingURL=crosshair_utils.js.map