/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame3.driver.config;

import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.ModelException;
import org.openrdf.repository.config.RepositoryImplConfigBase;
import org.openrdf.store.StoreConfigException;
import virtuoso.sesame3.driver.config.VirtuosoRepositorySchema;

public class VirtuosoRepositoryConfig
extends RepositoryImplConfigBase {
    private String hostlist;
    private String username;
    private String password;
    private String defGraph;
    private boolean useLazyAdd;
    private int fetchSize = 200;
    private boolean roundRobin;
    private String ruleSet;

    public VirtuosoRepositoryConfig() {
        super("openrdf:VirtuosoRepository");
    }

    public VirtuosoRepositoryConfig(String string) {
        this();
        this.setHostList(string);
    }

    public String getHostList() {
        return this.hostlist;
    }

    public void setHostList(String string) {
        this.hostlist = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDefGraph() {
        return this.defGraph;
    }

    public void setDefGraph(String string) {
        this.defGraph = string;
    }

    public boolean getUseLazyAdd() {
        return this.useLazyAdd;
    }

    public void setUseLazyAdd(boolean bl) {
        this.useLazyAdd = bl;
    }

    public boolean getRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean bl) {
        this.roundRobin = bl;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(String string) {
        this.ruleSet = string != null && string.equals("null") ? null : string;
    }

    public void validate() throws StoreConfigException {
        super.validate();
        if (this.hostlist == null) {
            throw new StoreConfigException("No HostList specified for Virtuoso repository");
        }
    }

    public Resource export(Model model) {
        Resource resource = super.export(model);
        ValueFactoryImpl valueFactoryImpl = ValueFactoryImpl.getInstance();
        if (this.hostlist != null) {
            model.add(resource, VirtuosoRepositorySchema.HOSTLIST, (Value)valueFactoryImpl.createLiteral(this.hostlist), new Resource[0]);
        }
        if (this.username != null) {
            model.add(resource, VirtuosoRepositorySchema.USERNAME, (Value)valueFactoryImpl.createLiteral(this.username), new Resource[0]);
        }
        if (this.password != null) {
            model.add(resource, VirtuosoRepositorySchema.PASSWORD, (Value)valueFactoryImpl.createLiteral(this.password), new Resource[0]);
        }
        if (this.defGraph != null) {
            model.add(resource, VirtuosoRepositorySchema.DEFGRAPH, (Value)valueFactoryImpl.createLiteral(this.defGraph), new Resource[0]);
        }
        if (this.ruleSet != null && this.ruleSet.length() > 0 && !this.ruleSet.equals("null")) {
            model.add(resource, VirtuosoRepositorySchema.RULESET, (Value)valueFactoryImpl.createLiteral(this.ruleSet), new Resource[0]);
        }
        model.add(resource, VirtuosoRepositorySchema.USELAZYADD, (Value)valueFactoryImpl.createLiteral(new Boolean(this.useLazyAdd).toString()), new Resource[0]);
        model.add(resource, VirtuosoRepositorySchema.ROUNDROBIN, (Value)valueFactoryImpl.createLiteral(new Boolean(this.roundRobin).toString()), new Resource[0]);
        model.add(resource, VirtuosoRepositorySchema.FETCHSIZE, (Value)valueFactoryImpl.createLiteral(Integer.toString(this.fetchSize, 10)), new Resource[0]);
        return resource;
    }

    public void parse(Model model, Resource resource) throws StoreConfigException {
        super.parse(model, resource);
        try {
            Literal literal;
            Literal literal2;
            Literal literal3;
            Literal literal4;
            Literal literal5;
            Literal literal6;
            Literal literal7;
            Literal literal8 = model.filter(resource, VirtuosoRepositorySchema.HOSTLIST, null, new Resource[0]).objectLiteral();
            if (literal8 != null) {
                this.setHostList(literal8.getLabel());
            }
            if ((literal7 = model.filter(resource, VirtuosoRepositorySchema.USERNAME, null, new Resource[0]).objectLiteral()) != null) {
                this.setUsername(literal7.getLabel());
            }
            if ((literal6 = model.filter(resource, VirtuosoRepositorySchema.PASSWORD, null, new Resource[0]).objectLiteral()) != null) {
                this.setPassword(literal6.getLabel());
            }
            if ((literal5 = model.filter(resource, VirtuosoRepositorySchema.DEFGRAPH, null, new Resource[0]).objectLiteral()) != null) {
                this.setDefGraph(literal5.getLabel());
            }
            if ((literal4 = model.filter(resource, VirtuosoRepositorySchema.USELAZYADD, null, new Resource[0]).objectLiteral()) != null) {
                this.setUseLazyAdd(Boolean.getBoolean(literal4.getLabel()));
            }
            if ((literal3 = model.filter(resource, VirtuosoRepositorySchema.ROUNDROBIN, null, new Resource[0]).objectLiteral()) != null) {
                this.setRoundRobin(Boolean.getBoolean(literal3.getLabel()));
            }
            if ((literal2 = model.filter(resource, VirtuosoRepositorySchema.FETCHSIZE, null, new Resource[0]).objectLiteral()) != null) {
                this.setFetchSize(Integer.parseInt(literal2.getLabel()));
            }
            if ((literal = model.filter(resource, VirtuosoRepositorySchema.RULESET, null, new Resource[0]).objectLiteral()) != null) {
                this.setRuleSet(literal.getLabel());
            }
        }
        catch (ModelException modelException) {
            throw new StoreConfigException(modelException.getMessage(), (Throwable)modelException);
        }
    }
}

