/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.signapk;

import com.googlecode.d2j.signapk.AbstractJarSign;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class SunJarSignImpl
extends AbstractJarSign {
    protected final X509Certificate cert;

    public SunJarSignImpl(X509Certificate cert, PrivateKey privateKey) {
        super(privateKey);
        this.cert = cert;
    }

    @Override
    protected void writeSignatureBlock(byte[] signature, OutputStream out) throws IOException {
        try {
            SignerInfo signerInfo = new SignerInfo(new X500Name(this.cert.getIssuerX500Principal().getName()), this.cert.getSerialNumber(), AlgorithmId.get(this.digestAlg), AlgorithmId.get("RSA"), signature);
            PKCS7 pkcs7 = new PKCS7(new AlgorithmId[]{AlgorithmId.get(this.digestAlg)}, new ContentInfo(ContentInfo.DATA_OID, null), new X509Certificate[]{this.cert}, new SignerInfo[]{signerInfo});
            pkcs7.encodeSignedData(out);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

