"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var vega_util_1 = require("vega-util");
var channel_1 = require("./channel");
var util_1 = require("./util");
function binToString(bin) {
    if (vega_util_1.isBoolean(bin)) {
        return 'bin';
    }
    return 'bin' + util_1.keys(bin).map(function (p) { return util_1.varName("_" + p + "_" + bin[p]); }).join('');
}
exports.binToString = binToString;
function autoMaxBins(channel) {
    switch (channel) {
        case channel_1.ROW:
        case channel_1.COLUMN:
        case channel_1.SIZE:
        case channel_1.COLOR:
        case channel_1.FILL:
        case channel_1.STROKE:
        case channel_1.OPACITY:
        // Facets and Size shouldn't have too many bins
        // We choose 6 like shape to simplify the rule
        case channel_1.SHAPE:
            return 6; // Vega's "shape" has 6 distinct values
        default:
            return 10;
    }
}
exports.autoMaxBins = autoMaxBins;
//# sourceMappingURL=data:application/json;base64,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