'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KuiSubmitButton = exports.KuiLinkButton = exports.KuiButton = exports.BUTTON_TYPES = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _button_icon = require('./button_icon/button_icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /*
                                                                                                                                                                                                                              * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                              * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                              * this work for additional information regarding copyright
                                                                                                                                                                                                                              * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                              * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                              * not use this file except in compliance with the License.
                                                                                                                                                                                                                              * You may obtain a copy of the License at
                                                                                                                                                                                                                              *
                                                                                                                                                                                                                              *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                              *
                                                                                                                                                                                                                              * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                              * software distributed under the License is distributed on an
                                                                                                                                                                                                                              * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                              * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                              * specific language governing permissions and limitations
                                                                                                                                                                                                                              * under the License.
                                                                                                                                                                                                                              */

var accessibleIconButton = function accessibleIconButton(props, propName, componentName) {
  if (props.children) {
    return;
  }

  if (props['aria-label']) {
    return;
  }

  if (props['aria-labelledby']) {
    return;
  }

  throw new Error(componentName + ' requires aria-label or aria-labelledby to be specified if it does not have children. ' + 'This is because we\'re assuming you\'re creating an icon-only button, which is screen-reader-inaccessible.');
};

var BUTTON_TYPES = ['basic', 'hollow', 'danger', 'warning', 'primary', 'secondary'];

var ICON_POSITIONS = ['left', 'right'];

var DEFAULT_ICON_POSITION = 'left';

var buttonTypeToClassNameMap = {
  basic: 'kuiButton--basic',
  hollow: 'kuiButton--hollow',
  danger: 'kuiButton--danger',
  warning: 'kuiButton--warning',
  primary: 'kuiButton--primary',
  secondary: 'kuiButton--secondary'
};

var getClassName = function getClassName(_ref) {
  var className = _ref.className,
      buttonType = _ref.buttonType,
      _ref$hasIcon = _ref.hasIcon,
      hasIcon = _ref$hasIcon === undefined ? false : _ref$hasIcon;
  return (0, _classnames2.default)('kuiButton', className, buttonTypeToClassNameMap[buttonType], {
    'kuiButton--iconText': hasIcon
  });
};

var ContentWithIcon = function ContentWithIcon(_ref2) {
  var children = _ref2.children,
      icon = _ref2.icon,
      iconPosition = _ref2.iconPosition,
      isLoading = _ref2.isLoading;

  var iconOrLoading = isLoading ? _react2.default.createElement(_button_icon.KuiButtonIcon, { type: 'loading' }) : icon;

  // We need to wrap the children so that the icon's :first-child etc. pseudo-selectors get applied
  // correctly.
  var wrappedChildren = children ? _react2.default.createElement(
    'span',
    null,
    children
  ) : undefined;

  switch (iconPosition) {
    case 'left':
      return _react2.default.createElement(
        'span',
        { className: 'kuiButton__inner' },
        iconOrLoading,
        wrappedChildren
      );

    case 'right':
      return _react2.default.createElement(
        'span',
        { className: 'kuiButton__inner' },
        wrappedChildren,
        iconOrLoading
      );
  }
};

var KuiButton = function KuiButton(_ref3) {
  var isLoading = _ref3.isLoading,
      _ref3$iconPosition = _ref3.iconPosition,
      iconPosition = _ref3$iconPosition === undefined ? DEFAULT_ICON_POSITION : _ref3$iconPosition,
      className = _ref3.className,
      buttonType = _ref3.buttonType,
      icon = _ref3.icon,
      children = _ref3.children,
      rest = _objectWithoutProperties(_ref3, ['isLoading', 'iconPosition', 'className', 'buttonType', 'icon', 'children']);

  return _react2.default.createElement(
    'button',
    _extends({
      className: getClassName({
        className: className,
        buttonType: buttonType,
        hasIcon: icon || isLoading
      })
    }, rest),
    _react2.default.createElement(
      ContentWithIcon,
      {
        icon: icon,
        iconPosition: iconPosition,
        isLoading: isLoading
      },
      children
    )
  );
};

KuiButton.propTypes = {
  icon: _propTypes2.default.node,
  iconPosition: _propTypes2.default.oneOf(ICON_POSITIONS),
  children: _propTypes2.default.node,
  isLoading: _propTypes2.default.bool,
  buttonType: _propTypes2.default.oneOf(BUTTON_TYPES),
  className: _propTypes2.default.string,
  'aria-label': accessibleIconButton
};

var KuiLinkButton = function KuiLinkButton(_ref4) {
  var isLoading = _ref4.isLoading,
      icon = _ref4.icon,
      _ref4$iconPosition = _ref4.iconPosition,
      iconPosition = _ref4$iconPosition === undefined ? DEFAULT_ICON_POSITION : _ref4$iconPosition,
      className = _ref4.className,
      disabled = _ref4.disabled,
      buttonType = _ref4.buttonType,
      children = _ref4.children,
      rest = _objectWithoutProperties(_ref4, ['isLoading', 'icon', 'iconPosition', 'className', 'disabled', 'buttonType', 'children']);

  var onClick = function onClick(e) {
    if (disabled) {
      e.preventDefault();
    }
  };

  var classes = (0, _classnames2.default)(getClassName({
    className: className,
    buttonType: buttonType,
    hasIcon: icon || isLoading
  }), { 'kuiButton-isDisabled': disabled });

  return _react2.default.createElement(
    'a',
    _extends({
      className: classes,
      onClick: onClick
    }, rest),
    _react2.default.createElement(
      ContentWithIcon,
      {
        icon: icon,
        iconPosition: iconPosition,
        isLoading: isLoading
      },
      children
    )
  );
};

KuiLinkButton.propTypes = {
  icon: _propTypes2.default.node,
  iconPosition: _propTypes2.default.oneOf(ICON_POSITIONS),
  isLoading: _propTypes2.default.bool,
  buttonType: _propTypes2.default.oneOf(BUTTON_TYPES),
  className: _propTypes2.default.string,
  children: _propTypes2.default.node,
  'aria-label': accessibleIconButton
};

var KuiSubmitButton = function KuiSubmitButton(_ref5) {
  var className = _ref5.className,
      buttonType = _ref5.buttonType,
      children = _ref5.children,
      rest = _objectWithoutProperties(_ref5, ['className', 'buttonType', 'children']);

  // NOTE: The `input` element is a void element and can't contain children.
  return _react2.default.createElement('input', _extends({
    type: 'submit',
    value: children,
    className: getClassName({ className: className, buttonType: buttonType })
  }, rest));
};

KuiSubmitButton.propTypes = {
  children: _propTypes2.default.string,
  buttonType: _propTypes2.default.oneOf(BUTTON_TYPES),
  className: _propTypes2.default.string
};

exports.BUTTON_TYPES = BUTTON_TYPES;
exports.KuiButton = KuiButton;
exports.KuiLinkButton = KuiLinkButton;
exports.KuiSubmitButton = KuiSubmitButton;
