'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiLineSeries = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactVis = require('react-vis');

var _chart_utils = require('../utils/chart_utils');

var _visualization_color_type = require('../utils/visualization_color_type');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EuiLineSeries = exports.EuiLineSeries = function (_AbstractSeries) {
  _inherits(EuiLineSeries, _AbstractSeries);

  function EuiLineSeries() {
    _classCallCheck(this, EuiLineSeries);

    return _possibleConstructorReturn(this, (EuiLineSeries.__proto__ || Object.getPrototypeOf(EuiLineSeries)).apply(this, arguments));
  }

  _createClass(EuiLineSeries, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          data = _props.data,
          name = _props.name,
          curve = _props.curve,
          onSeriesClick = _props.onSeriesClick,
          onValueClick = _props.onValueClick,
          showLineMarks = _props.showLineMarks,
          lineSize = _props.lineSize,
          lineMarkColor = _props.lineMarkColor,
          lineMarkSize = _props.lineMarkSize,
          color = _props.color,
          rest = _objectWithoutProperties(_props, ['data', 'name', 'curve', 'onSeriesClick', 'onValueClick', 'showLineMarks', 'lineSize', 'lineMarkColor', 'lineMarkSize', 'color']);

      return _react2.default.createElement(
        _react.Fragment,
        null,
        _react2.default.createElement(_reactVis.LineSeries, _extends({}, rest, {
          key: name + '-border',
          curve: curve,
          data: data,
          opacity: 1,
          onSeriesClick: onSeriesClick,
          style: {
            pointerEvents: 'visiblestroke',
            strokeWidth: lineSize + 2 // border margin
          },
          _colorValue: 'white'
        })),
        _react2.default.createElement(_reactVis.LineSeries, _extends({}, rest, {
          key: name,
          curve: curve,
          data: data,
          opacity: 1,
          style: {
            pointerEvents: 'visiblestroke',
            strokeWidth: lineSize
          },
          color: color
        })),
        showLineMarks && _react2.default.createElement(_reactVis.MarkSeries, _extends({}, rest, {
          key: name + '-mark',
          data: data,
          color: color || lineMarkColor,
          size: lineMarkSize,
          stroke: 'white',
          opacity: 1,
          onValueClick: onValueClick,
          strokeWidth: 2
        }))
      );
    }
  }]);

  return EuiLineSeries;
}(_reactVis.AbstractSeries);

EuiLineSeries.displayName = 'EuiLineSeries';

EuiLineSeries.propTypes = {
  /** The name used to define the data in tooltips and legends */
  name: _propTypes2.default.string.isRequired,
  /** Array<{x: string|number, y: string|number}> */
  data: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    x: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number]),
    y: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number])
  })).isRequired,
  /** An EUI visualization color, the default value is enforced by EuiXYChart */
  color: _visualization_color_type.VisualizationColorType,
  curve: _propTypes2.default.oneOf(Object.values(_chart_utils.CURVE)),
  showLineMarks: _propTypes2.default.bool,
  lineSize: _propTypes2.default.number,
  lineMarkColor: _propTypes2.default.string,
  lineMarkSize: _propTypes2.default.number,
  onSeriesClick: _propTypes2.default.func,
  onValueClick: _propTypes2.default.func
};

EuiLineSeries.defaultProps = {
  curve: _chart_utils.CURVE.LINEAR,
  showLineMarks: false,
  lineSize: 1,
  lineMarkSize: 0
};
EuiLineSeries.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiLineSeries',
  'methods': [],
  'props': {
    'name': {
      'type': {
        'name': 'string'
      },
      'required': true,
      'description': 'The name used to define the data in tooltips and legends'
    },
    'data': {
      'type': {
        'name': 'arrayOf',
        'value': {
          'name': 'shape',
          'value': {
            'x': {
              'name': 'union',
              'value': [{
                'name': 'string'
              }, {
                'name': 'number'
              }],
              'required': false
            },
            'y': {
              'name': 'union',
              'value': [{
                'name': 'string'
              }, {
                'name': 'number'
              }],
              'required': false
            }
          }
        }
      },
      'required': true,
      'description': 'Array<{x: string|number, y: string|number}>'
    },
    'color': {
      'type': {
        'name': 'custom',
        'raw': 'VisualizationColorType'
      },
      'required': false,
      'description': 'An EUI visualization color, the default value is enforced by EuiXYChart'
    },
    'curve': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'Object.values(CURVE)'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': 'CURVE.LINEAR',
        'computed': true
      }
    },
    'showLineMarks': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': 'false',
        'computed': false
      }
    },
    'lineSize': {
      'type': {
        'name': 'number'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': '1',
        'computed': false
      }
    },
    'lineMarkColor': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'lineMarkSize': {
      'type': {
        'name': 'number'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': '0',
        'computed': false
      }
    },
    'onSeriesClick': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': ''
    },
    'onValueClick': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': ''
    }
  }
}];