'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultSyntax = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _ast = require('./ast');

var _predicate = require('../../../services/predicate');

var _date_format = require('./date_format');

var _date_value = require('./date_value');

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

// eslint-disable-line import/no-unresolved

var parser = /*
              * Generated by PEG.js 0.10.0.
              *
              * http://pegjs.org/
              */function () {
  "use strict";
  function peg$subclass(child, parent) {
    function ctor() {
      this.constructor = child;
    }ctor.prototype = parent.prototype;child.prototype = new ctor();
  }function peg$SyntaxError(message, expected, found, location) {
    this.message = message;this.expected = expected;this.found = found;this.location = location;this.name = "SyntaxError";if (typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(this, peg$SyntaxError);
    }
  }peg$subclass(peg$SyntaxError, Error);peg$SyntaxError.buildMessage = function (expected, found) {
    var DESCRIBE_EXPECTATION_FNS = { literal: function literal(expectation) {
        return "\"" + literalEscape(expectation.text) + "\"";
      }, "class": function _class(expectation) {
        var escapedParts = "",
            i;for (i = 0; i < expectation.parts.length; i++) {
          escapedParts += expectation.parts[i] instanceof Array ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1]) : classEscape(expectation.parts[i]);
        }return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
      }, any: function any(expectation) {
        return "any character";
      }, end: function end(expectation) {
        return "end of input";
      }, other: function other(expectation) {
        return expectation.description;
      } };function hex(ch) {
      return ch.charCodeAt(0).toString(16).toUpperCase();
    }function literalEscape(s) {
      return s.replace(/\\/g, '\\\\').replace(/"/g, '\\"').replace(/\0/g, '\\0').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/[\x00-\x0F]/g, function (ch) {
        return '\\x0' + hex(ch);
      }).replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
        return '\\x' + hex(ch);
      });
    }function classEscape(s) {
      return s.replace(/\\/g, '\\\\').replace(/\]/g, '\\]').replace(/\^/g, '\\^').replace(/-/g, '\\-').replace(/\0/g, '\\0').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/[\x00-\x0F]/g, function (ch) {
        return '\\x0' + hex(ch);
      }).replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
        return '\\x' + hex(ch);
      });
    }function describeExpectation(expectation) {
      return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
    }function describeExpected(expected) {
      var descriptions = new Array(expected.length),
          i,
          j;for (i = 0; i < expected.length; i++) {
        descriptions[i] = describeExpectation(expected[i]);
      }descriptions.sort();if (descriptions.length > 0) {
        for (i = 1, j = 1; i < descriptions.length; i++) {
          if (descriptions[i - 1] !== descriptions[i]) {
            descriptions[j] = descriptions[i];j++;
          }
        }descriptions.length = j;
      }switch (descriptions.length) {case 1:
          return descriptions[0];case 2:
          return descriptions[0] + " or " + descriptions[1];default:
          return descriptions.slice(0, -1).join(", ") + ", or " + descriptions[descriptions.length - 1];}
    }function describeFound(found) {
      return found ? "\"" + literalEscape(found) + "\"" : "end of input";
    }return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
  };function peg$parse(input, options) {
    options = options !== void 0 ? options : {};var peg$FAILED = {},
        peg$startRuleFunctions = { Query: peg$parseQuery },
        peg$startRuleFunction = peg$parseQuery,
        peg$c0 = function peg$c0(clauses) {
      return clauses;
    },
        peg$c1 = function peg$c1() {
      return [];
    },
        peg$c2 = function peg$c2(head, clause) {
      return clause;
    },
        peg$c3 = function peg$c3(head, tail) {
      return [head].concat(_toConsumableArray(tail));
    },
        peg$c4 = "-",
        peg$c5 = peg$literalExpectation("-", false),
        peg$c6 = function peg$c6(value) {
      return AST.Term.mustNot(value);
    },
        peg$c7 = function peg$c7(value) {
      return AST.Term.must(value);
    },
        peg$c8 = function peg$c8(flag) {
      return AST.Is.mustNot(flag);
    },
        peg$c9 = function peg$c9(flag) {
      return AST.Is.must(flag);
    },
        peg$c10 = "is:",
        peg$c11 = peg$literalExpectation("is:", false),
        peg$c12 = function peg$c12(flag) {
      validateFlag(flag, location(), ctx);return flag;
    },
        peg$c13 = function peg$c13(fv) {
      return AST.Field.mustNot.eq(fv.field, fv.value);
    },
        peg$c14 = function peg$c14(fv) {
      return AST.Field.mustNot.gt(fv.field, fv.value);
    },
        peg$c15 = function peg$c15(fv) {
      return AST.Field.mustNot.gte(fv.field, fv.value);
    },
        peg$c16 = function peg$c16(fv) {
      return AST.Field.mustNot.lt(fv.field, fv.value);
    },
        peg$c17 = function peg$c17(fv) {
      return AST.Field.mustNot.lte(fv.field, fv.value);
    },
        peg$c18 = function peg$c18(fv) {
      return AST.Field.must.eq(fv.field, fv.value);
    },
        peg$c19 = function peg$c19(fv) {
      return AST.Field.must.gt(fv.field, fv.value);
    },
        peg$c20 = function peg$c20(fv) {
      return AST.Field.must.gte(fv.field, fv.value);
    },
        peg$c21 = function peg$c21(fv) {
      return AST.Field.must.lt(fv.field, fv.value);
    },
        peg$c22 = function peg$c22(fv) {
      return AST.Field.must.lte(fv.field, fv.value);
    },
        peg$c23 = ":",
        peg$c24 = peg$literalExpectation(":", false),
        peg$c25 = function peg$c25(field, valueExpression) {
      return { field: field, value: resolveFieldValue(field, valueExpression, ctx) };
    },
        peg$c26 = ">",
        peg$c27 = peg$literalExpectation(">", false),
        peg$c28 = function peg$c28(field, valueExpression) {
      return { field: field, value: resolveFieldValue(field, valueExpression, ctx) };
    },
        peg$c29 = ">=",
        peg$c30 = peg$literalExpectation(">=", false),
        peg$c31 = "<",
        peg$c32 = peg$literalExpectation("<", false),
        peg$c33 = "<=",
        peg$c34 = peg$literalExpectation("<=", false),
        peg$c35 = peg$otherExpectation("flag name"),
        peg$c36 = peg$otherExpectation("field name"),
        peg$c37 = function peg$c37() {
      return unescapeValue(text());
    },
        peg$c38 = /^[\-]/,
        peg$c39 = peg$classExpectation(["-"], false, false),
        peg$c40 = peg$otherExpectation("field value"),
        peg$c41 = peg$otherExpectation("term"),
        peg$c42 = function peg$c42(value) {
      return value.expression;
    },
        peg$c43 = "(",
        peg$c44 = peg$literalExpectation("(", false),
        peg$c45 = /^[oO]/,
        peg$c46 = peg$classExpectation(["o", "O"], false, false),
        peg$c47 = /^[rR]/,
        peg$c48 = peg$classExpectation(["r", "R"], false, false),
        peg$c49 = function peg$c49(head, value) {
      return value;
    },
        peg$c50 = ")",
        peg$c51 = peg$literalExpectation(")", false),
        peg$c52 = function peg$c52(head, tail) {
      return [head].concat(_toConsumableArray(tail));
    },
        peg$c53 = "\"",
        peg$c54 = peg$literalExpectation("\"", false),
        peg$c55 = function peg$c55(phrase) {
      return Exp.string(phrase, location());
    },
        peg$c56 = function peg$c56() {
      return Exp.string(unescapeValue(text()), location());
    },
        peg$c57 = /^[\-_*]/,
        peg$c58 = peg$classExpectation(["-", "_", "*"], false, false),
        peg$c59 = "\\",
        peg$c60 = peg$literalExpectation("\\", false),
        peg$c61 = /^[\-:\\]/,
        peg$c62 = peg$classExpectation(["-", ":", "\\"], false, false),
        peg$c63 = function peg$c63(bool) {
      return bool;
    },
        peg$c64 = peg$anyExpectation(),
        peg$c65 = /^[tT]/,
        peg$c66 = peg$classExpectation(["t", "T"], false, false),
        peg$c67 = /^[uU]/,
        peg$c68 = peg$classExpectation(["u", "U"], false, false),
        peg$c69 = /^[eE]/,
        peg$c70 = peg$classExpectation(["e", "E"], false, false),
        peg$c71 = function peg$c71() {
      return Exp.boolean(text(), location());
    },
        peg$c72 = /^[fF]/,
        peg$c73 = peg$classExpectation(["f", "F"], false, false),
        peg$c74 = /^[aA]/,
        peg$c75 = peg$classExpectation(["a", "A"], false, false),
        peg$c76 = /^[lL]/,
        peg$c77 = peg$classExpectation(["l", "L"], false, false),
        peg$c78 = /^[sS]/,
        peg$c79 = peg$classExpectation(["s", "S"], false, false),
        peg$c80 = /^[yY]/,
        peg$c81 = peg$classExpectation(["y", "Y"], false, false),
        peg$c82 = /^[nN]/,
        peg$c83 = peg$classExpectation(["n", "N"], false, false),
        peg$c84 = /^[0-9]/,
        peg$c85 = peg$classExpectation([["0", "9"]], false, false),
        peg$c86 = ".",
        peg$c87 = peg$literalExpectation(".", false),
        peg$c88 = function peg$c88() {
      return Exp.number(text(), location());
    },
        peg$c89 = "'",
        peg$c90 = peg$literalExpectation("'", false),
        peg$c91 = function peg$c91() {
      return text();
    },
        peg$c92 = function peg$c92(expression) {
      return Exp.date(expression, location());
    },
        peg$c93 = peg$otherExpectation("alpha numeric"),
        peg$c94 = /^[a-zA-Z0-9.]/,
        peg$c95 = peg$classExpectation([["a", "z"], ["A", "Z"], ["0", "9"], "."], false, false),
        peg$c96 = peg$otherExpectation("whitespace"),
        peg$c97 = /^[ \t\n\r]/,
        peg$c98 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false),
        peg$currPos = 0,
        peg$savedPos = 0,
        peg$posDetailsCache = [{ line: 1, column: 1 }],
        peg$maxFailPos = 0,
        peg$maxFailExpected = [],
        peg$silentFails = 0,
        peg$result;if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }function text() {
      return input.substring(peg$savedPos, peg$currPos);
    }function location() {
      return peg$computeLocation(peg$savedPos, peg$currPos);
    }function expected(description, location) {
      location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos);throw peg$buildStructuredError([peg$otherExpectation(description)], input.substring(peg$savedPos, peg$currPos), location);
    }function error(message, location) {
      location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos);throw peg$buildSimpleError(message, location);
    }function peg$literalExpectation(text, ignoreCase) {
      return { type: "literal", text: text, ignoreCase: ignoreCase };
    }function peg$classExpectation(parts, inverted, ignoreCase) {
      return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
    }function peg$anyExpectation() {
      return { type: "any" };
    }function peg$endExpectation() {
      return { type: "end" };
    }function peg$otherExpectation(description) {
      return { type: "other", description: description };
    }function peg$computePosDetails(pos) {
      var details = peg$posDetailsCache[pos],
          p;if (details) {
        return details;
      } else {
        p = pos - 1;while (!peg$posDetailsCache[p]) {
          p--;
        }details = peg$posDetailsCache[p];details = { line: details.line, column: details.column };while (p < pos) {
          if (input.charCodeAt(p) === 10) {
            details.line++;details.column = 1;
          } else {
            details.column++;
          }p++;
        }peg$posDetailsCache[pos] = details;return details;
      }
    }function peg$computeLocation(startPos, endPos) {
      var startPosDetails = peg$computePosDetails(startPos),
          endPosDetails = peg$computePosDetails(endPos);return { start: { offset: startPos, line: startPosDetails.line, column: startPosDetails.column }, end: { offset: endPos, line: endPosDetails.line, column: endPosDetails.column } };
    }function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) {
        return;
      }if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;peg$maxFailExpected = [];
      }peg$maxFailExpected.push(expected);
    }function peg$buildSimpleError(message, location) {
      return new peg$SyntaxError(message, null, null, location);
    }function peg$buildStructuredError(expected, found, location) {
      return new peg$SyntaxError(peg$SyntaxError.buildMessage(expected, found), expected, found, location);
    }function peg$parseQuery() {
      var s0, s1;s0 = peg$currPos;s1 = peg$parseClauses();if (s1 !== peg$FAILED) {
        peg$savedPos = s0;s1 = peg$c0(s1);
      }s0 = s1;if (s0 === peg$FAILED) {
        s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
          s1 = null;
        }if (s1 !== peg$FAILED) {
          peg$savedPos = s0;s1 = peg$c1();
        }s0 = s1;
      }return s0;
    }function peg$parseClauses() {
      var s0, s1, s2, s3, s4, s5, s6;s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
        s1 = null;
      }if (s1 !== peg$FAILED) {
        s2 = peg$parseClause();if (s2 !== peg$FAILED) {
          s3 = [];s4 = peg$currPos;s5 = peg$parsespace();if (s5 !== peg$FAILED) {
            s6 = peg$parseClause();if (s6 !== peg$FAILED) {
              peg$savedPos = s4;s5 = peg$c2(s2, s6);s4 = s5;
            } else {
              peg$currPos = s4;s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;s4 = peg$FAILED;
          }while (s4 !== peg$FAILED) {
            s3.push(s4);s4 = peg$currPos;s5 = peg$parsespace();if (s5 !== peg$FAILED) {
              s6 = peg$parseClause();if (s6 !== peg$FAILED) {
                peg$savedPos = s4;s5 = peg$c2(s2, s6);s4 = s5;
              } else {
                peg$currPos = s4;s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;s4 = peg$FAILED;
            }
          }if (s3 !== peg$FAILED) {
            s4 = peg$parsespace();if (s4 === peg$FAILED) {
              s4 = null;
            }if (s4 !== peg$FAILED) {
              peg$savedPos = s0;s1 = peg$c3(s2, s3);s0 = s1;
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parseClause() {
      var s0;s0 = peg$parseIsClause();if (s0 === peg$FAILED) {
        s0 = peg$parseFieldClause();if (s0 === peg$FAILED) {
          s0 = peg$parseTermClause();
        }
      }return s0;
    }function peg$parseTermClause() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
        s1 = null;
      }if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s2 = peg$c4;peg$currPos++;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c5);
          }
        }if (s2 !== peg$FAILED) {
          s3 = peg$parsetermValue();if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c6(s3);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }if (s0 === peg$FAILED) {
        s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
          s1 = null;
        }if (s1 !== peg$FAILED) {
          s2 = peg$parsetermValue();if (s2 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c7(s2);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      }return s0;
    }function peg$parseIsClause() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
        s1 = null;
      }if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s2 = peg$c4;peg$currPos++;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c5);
          }
        }if (s2 !== peg$FAILED) {
          s3 = peg$parseIsFlag();if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c8(s3);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }if (s0 === peg$FAILED) {
        s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
          s1 = null;
        }if (s1 !== peg$FAILED) {
          s2 = peg$parseIsFlag();if (s2 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c9(s2);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      }return s0;
    }function peg$parseIsFlag() {
      var s0, s1, s2;s0 = peg$currPos;if (input.substr(peg$currPos, 3) === peg$c10) {
        s1 = peg$c10;peg$currPos += 3;
      } else {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c11);
        }
      }if (s1 !== peg$FAILED) {
        s2 = peg$parseflagName();if (s2 !== peg$FAILED) {
          peg$savedPos = s0;s1 = peg$c12(s2);s0 = s1;
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parseFieldClause() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
        s1 = null;
      }if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s2 = peg$c4;peg$currPos++;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c5);
          }
        }if (s2 !== peg$FAILED) {
          s3 = peg$parseFieldEQValue();if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c13(s3);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }if (s0 === peg$FAILED) {
        s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
          s1 = null;
        }if (s1 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 45) {
            s2 = peg$c4;peg$currPos++;
          } else {
            s2 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c5);
            }
          }if (s2 !== peg$FAILED) {
            s3 = peg$parseFieldGTValue();if (s3 !== peg$FAILED) {
              peg$savedPos = s0;s1 = peg$c14(s3);s0 = s1;
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }if (s0 === peg$FAILED) {
          s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
            s1 = null;
          }if (s1 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 45) {
              s2 = peg$c4;peg$currPos++;
            } else {
              s2 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c5);
              }
            }if (s2 !== peg$FAILED) {
              s3 = peg$parseFieldGTEValue();if (s3 !== peg$FAILED) {
                peg$savedPos = s0;s1 = peg$c15(s3);s0 = s1;
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }if (s0 === peg$FAILED) {
            s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
              s1 = null;
            }if (s1 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 45) {
                s2 = peg$c4;peg$currPos++;
              } else {
                s2 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c5);
                }
              }if (s2 !== peg$FAILED) {
                s3 = peg$parseFieldLTValue();if (s3 !== peg$FAILED) {
                  peg$savedPos = s0;s1 = peg$c16(s3);s0 = s1;
                } else {
                  peg$currPos = s0;s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }if (s0 === peg$FAILED) {
              s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
                s1 = null;
              }if (s1 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 45) {
                  s2 = peg$c4;peg$currPos++;
                } else {
                  s2 = peg$FAILED;if (peg$silentFails === 0) {
                    peg$fail(peg$c5);
                  }
                }if (s2 !== peg$FAILED) {
                  s3 = peg$parseFieldLTEValue();if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;s1 = peg$c17(s3);s0 = s1;
                  } else {
                    peg$currPos = s0;s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }if (s0 === peg$FAILED) {
                s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
                  s1 = null;
                }if (s1 !== peg$FAILED) {
                  s2 = peg$parseFieldEQValue();if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;s1 = peg$c18(s2);s0 = s1;
                  } else {
                    peg$currPos = s0;s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;s0 = peg$FAILED;
                }if (s0 === peg$FAILED) {
                  s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
                    s1 = null;
                  }if (s1 !== peg$FAILED) {
                    s2 = peg$parseFieldGTValue();if (s2 !== peg$FAILED) {
                      peg$savedPos = s0;s1 = peg$c19(s2);s0 = s1;
                    } else {
                      peg$currPos = s0;s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;s0 = peg$FAILED;
                  }if (s0 === peg$FAILED) {
                    s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
                      s1 = null;
                    }if (s1 !== peg$FAILED) {
                      s2 = peg$parseFieldGTEValue();if (s2 !== peg$FAILED) {
                        peg$savedPos = s0;s1 = peg$c20(s2);s0 = s1;
                      } else {
                        peg$currPos = s0;s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;s0 = peg$FAILED;
                    }if (s0 === peg$FAILED) {
                      s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
                        s1 = null;
                      }if (s1 !== peg$FAILED) {
                        s2 = peg$parseFieldLTValue();if (s2 !== peg$FAILED) {
                          peg$savedPos = s0;s1 = peg$c21(s2);s0 = s1;
                        } else {
                          peg$currPos = s0;s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;s0 = peg$FAILED;
                      }if (s0 === peg$FAILED) {
                        s0 = peg$currPos;s1 = peg$parsespace();if (s1 === peg$FAILED) {
                          s1 = null;
                        }if (s1 !== peg$FAILED) {
                          s2 = peg$parseFieldLTEValue();if (s2 !== peg$FAILED) {
                            peg$savedPos = s0;s1 = peg$c22(s2);s0 = s1;
                          } else {
                            peg$currPos = s0;s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;s0 = peg$FAILED;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }return s0;
    }function peg$parseFieldEQValue() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parsefieldName();if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 58) {
          s2 = peg$c23;peg$currPos++;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c24);
          }
        }if (s2 !== peg$FAILED) {
          s3 = peg$parsefieldContainsValue();if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c25(s1, s3);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parseFieldGTValue() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parsefieldName();if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 62) {
          s2 = peg$c26;peg$currPos++;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c27);
          }
        }if (s2 !== peg$FAILED) {
          s3 = peg$parserangeValue();if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c28(s1, s3);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parseFieldGTEValue() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parsefieldName();if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c29) {
          s2 = peg$c29;peg$currPos += 2;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c30);
          }
        }if (s2 !== peg$FAILED) {
          s3 = peg$parserangeValue();if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c28(s1, s3);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parseFieldLTValue() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parsefieldName();if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 60) {
          s2 = peg$c31;peg$currPos++;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c32);
          }
        }if (s2 !== peg$FAILED) {
          s3 = peg$parserangeValue();if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c28(s1, s3);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parseFieldLTEValue() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parsefieldName();if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c33) {
          s2 = peg$c33;peg$currPos += 2;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c34);
          }
        }if (s2 !== peg$FAILED) {
          s3 = peg$parserangeValue();if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c28(s1, s3);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parseflagName() {
      var s0, s1;peg$silentFails++;s0 = peg$parseidentifier();peg$silentFails--;if (s0 === peg$FAILED) {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c35);
        }
      }return s0;
    }function peg$parsefieldName() {
      var s0, s1;peg$silentFails++;s0 = peg$parseidentifier();peg$silentFails--;if (s0 === peg$FAILED) {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c36);
        }
      }return s0;
    }function peg$parseidentifier() {
      var s0, s1, s2;s0 = peg$currPos;s1 = [];s2 = peg$parseidentifierChar();if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);s2 = peg$parseidentifierChar();
        }
      } else {
        s1 = peg$FAILED;
      }if (s1 !== peg$FAILED) {
        peg$savedPos = s0;s1 = peg$c37();
      }s0 = s1;return s0;
    }function peg$parseidentifierChar() {
      var s0;s0 = peg$parsealnum();if (s0 === peg$FAILED) {
        if (peg$c38.test(input.charAt(peg$currPos))) {
          s0 = input.charAt(peg$currPos);peg$currPos++;
        } else {
          s0 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c39);
          }
        }if (s0 === peg$FAILED) {
          s0 = peg$parseescapedChar();
        }
      }return s0;
    }function peg$parsefieldContainsValue() {
      var s0, s1;peg$silentFails++;s0 = peg$parsecontainsOrValues();if (s0 === peg$FAILED) {
        s0 = peg$parsecontainsValue();
      }peg$silentFails--;if (s0 === peg$FAILED) {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c40);
        }
      }return s0;
    }function peg$parsetermValue() {
      var s0, s1;peg$silentFails++;s0 = peg$currPos;s1 = peg$parsecontainsValue();if (s1 !== peg$FAILED) {
        peg$savedPos = s0;s1 = peg$c42(s1);
      }s0 = s1;peg$silentFails--;if (s0 === peg$FAILED) {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c41);
        }
      }return s0;
    }function peg$parsecontainsOrValues() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;s0 = peg$currPos;if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c43;peg$currPos++;
      } else {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c44);
        }
      }if (s1 !== peg$FAILED) {
        s2 = peg$parsespace();if (s2 === peg$FAILED) {
          s2 = null;
        }if (s2 !== peg$FAILED) {
          s3 = peg$parsecontainsValue();if (s3 !== peg$FAILED) {
            s4 = [];s5 = peg$currPos;s6 = peg$parsespace();if (s6 !== peg$FAILED) {
              s7 = peg$currPos;if (peg$c45.test(input.charAt(peg$currPos))) {
                s8 = input.charAt(peg$currPos);peg$currPos++;
              } else {
                s8 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c46);
                }
              }if (s8 !== peg$FAILED) {
                if (peg$c47.test(input.charAt(peg$currPos))) {
                  s9 = input.charAt(peg$currPos);peg$currPos++;
                } else {
                  s9 = peg$FAILED;if (peg$silentFails === 0) {
                    peg$fail(peg$c48);
                  }
                }if (s9 !== peg$FAILED) {
                  s8 = [s8, s9];s7 = s8;
                } else {
                  peg$currPos = s7;s7 = peg$FAILED;
                }
              } else {
                peg$currPos = s7;s7 = peg$FAILED;
              }if (s7 !== peg$FAILED) {
                s8 = peg$parsespace();if (s8 !== peg$FAILED) {
                  s9 = peg$parsecontainsValue();if (s9 !== peg$FAILED) {
                    peg$savedPos = s5;s6 = peg$c49(s3, s9);s5 = s6;
                  } else {
                    peg$currPos = s5;s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;s5 = peg$FAILED;
            }while (s5 !== peg$FAILED) {
              s4.push(s5);s5 = peg$currPos;s6 = peg$parsespace();if (s6 !== peg$FAILED) {
                s7 = peg$currPos;if (peg$c45.test(input.charAt(peg$currPos))) {
                  s8 = input.charAt(peg$currPos);peg$currPos++;
                } else {
                  s8 = peg$FAILED;if (peg$silentFails === 0) {
                    peg$fail(peg$c46);
                  }
                }if (s8 !== peg$FAILED) {
                  if (peg$c47.test(input.charAt(peg$currPos))) {
                    s9 = input.charAt(peg$currPos);peg$currPos++;
                  } else {
                    s9 = peg$FAILED;if (peg$silentFails === 0) {
                      peg$fail(peg$c48);
                    }
                  }if (s9 !== peg$FAILED) {
                    s8 = [s8, s9];s7 = s8;
                  } else {
                    peg$currPos = s7;s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;s7 = peg$FAILED;
                }if (s7 !== peg$FAILED) {
                  s8 = peg$parsespace();if (s8 !== peg$FAILED) {
                    s9 = peg$parsecontainsValue();if (s9 !== peg$FAILED) {
                      peg$savedPos = s5;s6 = peg$c49(s3, s9);s5 = s6;
                    } else {
                      peg$currPos = s5;s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;s5 = peg$FAILED;
              }
            }if (s4 !== peg$FAILED) {
              s5 = peg$parsespace();if (s5 === peg$FAILED) {
                s5 = null;
              }if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s6 = peg$c50;peg$currPos++;
                } else {
                  s6 = peg$FAILED;if (peg$silentFails === 0) {
                    peg$fail(peg$c51);
                  }
                }if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;s1 = peg$c52(s3, s4);s0 = s1;
                } else {
                  peg$currPos = s0;s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parserangeValue() {
      var s0;s0 = peg$parsenumber();if (s0 === peg$FAILED) {
        s0 = peg$parsedate();
      }return s0;
    }function peg$parsecontainsValue() {
      var s0;s0 = peg$parsenumber();if (s0 === peg$FAILED) {
        s0 = peg$parsedate();if (s0 === peg$FAILED) {
          s0 = peg$parsebooleanWord();if (s0 === peg$FAILED) {
            s0 = peg$parseword();if (s0 === peg$FAILED) {
              s0 = peg$parsephrase();
            }
          }
        }
      }return s0;
    }function peg$parsephrase() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;s0 = peg$currPos;if (input.charCodeAt(peg$currPos) === 34) {
        s1 = peg$c53;peg$currPos++;
      } else {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c54);
        }
      }if (s1 !== peg$FAILED) {
        s2 = peg$parsespace();if (s2 === peg$FAILED) {
          s2 = null;
        }if (s2 !== peg$FAILED) {
          s3 = peg$currPos;s4 = peg$parseword();if (s4 !== peg$FAILED) {
            s5 = [];s6 = peg$currPos;s7 = peg$parsespace();if (s7 !== peg$FAILED) {
              s8 = peg$parseword();if (s8 !== peg$FAILED) {
                s7 = [s7, s8];s6 = s7;
              } else {
                peg$currPos = s6;s6 = peg$FAILED;
              }
            } else {
              peg$currPos = s6;s6 = peg$FAILED;
            }while (s6 !== peg$FAILED) {
              s5.push(s6);s6 = peg$currPos;s7 = peg$parsespace();if (s7 !== peg$FAILED) {
                s8 = peg$parseword();if (s8 !== peg$FAILED) {
                  s7 = [s7, s8];s6 = s7;
                } else {
                  peg$currPos = s6;s6 = peg$FAILED;
                }
              } else {
                peg$currPos = s6;s6 = peg$FAILED;
              }
            }if (s5 !== peg$FAILED) {
              peg$savedPos = s3;s4 = peg$c37();s3 = s4;
            } else {
              peg$currPos = s3;s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;s3 = peg$FAILED;
          }if (s3 !== peg$FAILED) {
            s4 = peg$parsespace();if (s4 === peg$FAILED) {
              s4 = null;
            }if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 34) {
                s5 = peg$c53;peg$currPos++;
              } else {
                s5 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c54);
                }
              }if (s5 !== peg$FAILED) {
                peg$savedPos = s0;s1 = peg$c55(s3);s0 = s1;
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parseword() {
      var s0, s1, s2;s0 = peg$currPos;s1 = [];s2 = peg$parsewordChar();if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);s2 = peg$parsewordChar();
        }
      } else {
        s1 = peg$FAILED;
      }if (s1 !== peg$FAILED) {
        peg$savedPos = s0;s1 = peg$c56();
      }s0 = s1;return s0;
    }function peg$parsewordChar() {
      var s0;s0 = peg$parsealnum();if (s0 === peg$FAILED) {
        if (peg$c57.test(input.charAt(peg$currPos))) {
          s0 = input.charAt(peg$currPos);peg$currPos++;
        } else {
          s0 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c58);
          }
        }if (s0 === peg$FAILED) {
          s0 = peg$parseescapedChar();
        }
      }return s0;
    }function peg$parseescapedChar() {
      var s0, s1, s2;s0 = peg$currPos;if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c59;peg$currPos++;
      } else {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c60);
        }
      }if (s1 !== peg$FAILED) {
        s2 = peg$parsereservedChar();if (s2 !== peg$FAILED) {
          s1 = [s1, s2];s0 = s1;
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parsereservedChar() {
      var s0;if (peg$c61.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);peg$currPos++;
      } else {
        s0 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c62);
        }
      }return s0;
    }function peg$parsebooleanWord() {
      var s0, s1, s2, s3;s0 = peg$currPos;s1 = peg$parseboolean();if (s1 !== peg$FAILED) {
        s2 = peg$currPos;peg$silentFails++;s3 = peg$parsespace();peg$silentFails--;if (s3 !== peg$FAILED) {
          peg$currPos = s2;s2 = void 0;
        } else {
          s2 = peg$FAILED;
        }if (s2 !== peg$FAILED) {
          peg$savedPos = s0;s1 = peg$c63(s1);s0 = s1;
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }if (s0 === peg$FAILED) {
        s0 = peg$currPos;s1 = peg$parseboolean();if (s1 !== peg$FAILED) {
          s2 = peg$currPos;peg$silentFails++;if (input.length > peg$currPos) {
            s3 = input.charAt(peg$currPos);peg$currPos++;
          } else {
            s3 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c64);
            }
          }peg$silentFails--;if (s3 === peg$FAILED) {
            s2 = void 0;
          } else {
            peg$currPos = s2;s2 = peg$FAILED;
          }if (s2 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c63(s1);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      }return s0;
    }function peg$parseboolean() {
      var s0, s1, s2, s3, s4, s5;s0 = peg$currPos;if (peg$c65.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);peg$currPos++;
      } else {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c66);
        }
      }if (s1 !== peg$FAILED) {
        if (peg$c47.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);peg$currPos++;
        } else {
          s2 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c48);
          }
        }if (s2 !== peg$FAILED) {
          if (peg$c67.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);peg$currPos++;
          } else {
            s3 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c68);
            }
          }if (s3 !== peg$FAILED) {
            if (peg$c69.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);peg$currPos++;
            } else {
              s4 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c70);
              }
            }if (s4 !== peg$FAILED) {
              peg$savedPos = s0;s1 = peg$c71();s0 = s1;
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }if (s0 === peg$FAILED) {
        s0 = peg$currPos;if (peg$c72.test(input.charAt(peg$currPos))) {
          s1 = input.charAt(peg$currPos);peg$currPos++;
        } else {
          s1 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c73);
          }
        }if (s1 !== peg$FAILED) {
          if (peg$c74.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);peg$currPos++;
          } else {
            s2 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c75);
            }
          }if (s2 !== peg$FAILED) {
            if (peg$c76.test(input.charAt(peg$currPos))) {
              s3 = input.charAt(peg$currPos);peg$currPos++;
            } else {
              s3 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c77);
              }
            }if (s3 !== peg$FAILED) {
              if (peg$c78.test(input.charAt(peg$currPos))) {
                s4 = input.charAt(peg$currPos);peg$currPos++;
              } else {
                s4 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c79);
                }
              }if (s4 !== peg$FAILED) {
                if (peg$c69.test(input.charAt(peg$currPos))) {
                  s5 = input.charAt(peg$currPos);peg$currPos++;
                } else {
                  s5 = peg$FAILED;if (peg$silentFails === 0) {
                    peg$fail(peg$c70);
                  }
                }if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;s1 = peg$c71();s0 = s1;
                } else {
                  peg$currPos = s0;s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }if (s0 === peg$FAILED) {
          s0 = peg$currPos;if (peg$c80.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);peg$currPos++;
          } else {
            s1 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c81);
            }
          }if (s1 !== peg$FAILED) {
            if (peg$c69.test(input.charAt(peg$currPos))) {
              s2 = input.charAt(peg$currPos);peg$currPos++;
            } else {
              s2 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c70);
              }
            }if (s2 !== peg$FAILED) {
              if (peg$c78.test(input.charAt(peg$currPos))) {
                s3 = input.charAt(peg$currPos);peg$currPos++;
              } else {
                s3 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c79);
                }
              }if (s3 !== peg$FAILED) {
                peg$savedPos = s0;s1 = peg$c71();s0 = s1;
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }if (s0 === peg$FAILED) {
            s0 = peg$currPos;if (peg$c82.test(input.charAt(peg$currPos))) {
              s1 = input.charAt(peg$currPos);peg$currPos++;
            } else {
              s1 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c83);
              }
            }if (s1 !== peg$FAILED) {
              if (peg$c45.test(input.charAt(peg$currPos))) {
                s2 = input.charAt(peg$currPos);peg$currPos++;
              } else {
                s2 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c46);
                }
              }if (s2 !== peg$FAILED) {
                peg$savedPos = s0;s1 = peg$c71();s0 = s1;
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;s0 = peg$FAILED;
            }if (s0 === peg$FAILED) {
              s0 = peg$currPos;if (peg$c45.test(input.charAt(peg$currPos))) {
                s1 = input.charAt(peg$currPos);peg$currPos++;
              } else {
                s1 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c46);
                }
              }if (s1 !== peg$FAILED) {
                if (peg$c82.test(input.charAt(peg$currPos))) {
                  s2 = input.charAt(peg$currPos);peg$currPos++;
                } else {
                  s2 = peg$FAILED;if (peg$silentFails === 0) {
                    peg$fail(peg$c83);
                  }
                }if (s2 !== peg$FAILED) {
                  peg$savedPos = s0;s1 = peg$c71();s0 = s1;
                } else {
                  peg$currPos = s0;s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;s0 = peg$FAILED;
              }if (s0 === peg$FAILED) {
                s0 = peg$currPos;if (peg$c45.test(input.charAt(peg$currPos))) {
                  s1 = input.charAt(peg$currPos);peg$currPos++;
                } else {
                  s1 = peg$FAILED;if (peg$silentFails === 0) {
                    peg$fail(peg$c46);
                  }
                }if (s1 !== peg$FAILED) {
                  if (peg$c72.test(input.charAt(peg$currPos))) {
                    s2 = input.charAt(peg$currPos);peg$currPos++;
                  } else {
                    s2 = peg$FAILED;if (peg$silentFails === 0) {
                      peg$fail(peg$c73);
                    }
                  }if (s2 !== peg$FAILED) {
                    if (peg$c72.test(input.charAt(peg$currPos))) {
                      s3 = input.charAt(peg$currPos);peg$currPos++;
                    } else {
                      s3 = peg$FAILED;if (peg$silentFails === 0) {
                        peg$fail(peg$c73);
                      }
                    }if (s3 !== peg$FAILED) {
                      peg$savedPos = s0;s1 = peg$c71();s0 = s1;
                    } else {
                      peg$currPos = s0;s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;s0 = peg$FAILED;
                }
              }
            }
          }
        }
      }return s0;
    }function peg$parsenumber() {
      var s0, s1, s2, s3, s4, s5, s6, s7;s0 = peg$currPos;if (peg$c38.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);peg$currPos++;
      } else {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c39);
        }
      }if (s1 === peg$FAILED) {
        s1 = null;
      }if (s1 !== peg$FAILED) {
        s2 = [];if (peg$c84.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);peg$currPos++;
        } else {
          s3 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c85);
          }
        }if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);if (peg$c84.test(input.charAt(peg$currPos))) {
              s3 = input.charAt(peg$currPos);peg$currPos++;
            } else {
              s3 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c85);
              }
            }
          }
        } else {
          s2 = peg$FAILED;
        }if (s2 !== peg$FAILED) {
          s3 = [];s4 = peg$currPos;if (input.charCodeAt(peg$currPos) === 46) {
            s5 = peg$c86;peg$currPos++;
          } else {
            s5 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c87);
            }
          }if (s5 !== peg$FAILED) {
            s6 = [];if (peg$c84.test(input.charAt(peg$currPos))) {
              s7 = input.charAt(peg$currPos);peg$currPos++;
            } else {
              s7 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c85);
              }
            }if (s7 !== peg$FAILED) {
              while (s7 !== peg$FAILED) {
                s6.push(s7);if (peg$c84.test(input.charAt(peg$currPos))) {
                  s7 = input.charAt(peg$currPos);peg$currPos++;
                } else {
                  s7 = peg$FAILED;if (peg$silentFails === 0) {
                    peg$fail(peg$c85);
                  }
                }
              }
            } else {
              s6 = peg$FAILED;
            }if (s6 !== peg$FAILED) {
              s5 = [s5, s6];s4 = s5;
            } else {
              peg$currPos = s4;s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;s4 = peg$FAILED;
          }while (s4 !== peg$FAILED) {
            s3.push(s4);s4 = peg$currPos;if (input.charCodeAt(peg$currPos) === 46) {
              s5 = peg$c86;peg$currPos++;
            } else {
              s5 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c87);
              }
            }if (s5 !== peg$FAILED) {
              s6 = [];if (peg$c84.test(input.charAt(peg$currPos))) {
                s7 = input.charAt(peg$currPos);peg$currPos++;
              } else {
                s7 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c85);
                }
              }if (s7 !== peg$FAILED) {
                while (s7 !== peg$FAILED) {
                  s6.push(s7);if (peg$c84.test(input.charAt(peg$currPos))) {
                    s7 = input.charAt(peg$currPos);peg$currPos++;
                  } else {
                    s7 = peg$FAILED;if (peg$silentFails === 0) {
                      peg$fail(peg$c85);
                    }
                  }
                }
              } else {
                s6 = peg$FAILED;
              }if (s6 !== peg$FAILED) {
                s5 = [s5, s6];s4 = s5;
              } else {
                peg$currPos = s4;s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;s4 = peg$FAILED;
            }
          }if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c88();s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parsedate() {
      var s0, s1, s2, s3, s4, s5, s6;s0 = peg$currPos;if (input.charCodeAt(peg$currPos) === 39) {
        s1 = peg$c89;peg$currPos++;
      } else {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c90);
        }
      }if (s1 !== peg$FAILED) {
        s2 = peg$currPos;s3 = [];s4 = peg$currPos;s5 = peg$currPos;peg$silentFails++;if (input.charCodeAt(peg$currPos) === 39) {
          s6 = peg$c89;peg$currPos++;
        } else {
          s6 = peg$FAILED;if (peg$silentFails === 0) {
            peg$fail(peg$c90);
          }
        }peg$silentFails--;if (s6 === peg$FAILED) {
          s5 = void 0;
        } else {
          peg$currPos = s5;s5 = peg$FAILED;
        }if (s5 !== peg$FAILED) {
          if (input.length > peg$currPos) {
            s6 = input.charAt(peg$currPos);peg$currPos++;
          } else {
            s6 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c64);
            }
          }if (s6 !== peg$FAILED) {
            s5 = [s5, s6];s4 = s5;
          } else {
            peg$currPos = s4;s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;s4 = peg$FAILED;
        }if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);s4 = peg$currPos;s5 = peg$currPos;peg$silentFails++;if (input.charCodeAt(peg$currPos) === 39) {
              s6 = peg$c89;peg$currPos++;
            } else {
              s6 = peg$FAILED;if (peg$silentFails === 0) {
                peg$fail(peg$c90);
              }
            }peg$silentFails--;if (s6 === peg$FAILED) {
              s5 = void 0;
            } else {
              peg$currPos = s5;s5 = peg$FAILED;
            }if (s5 !== peg$FAILED) {
              if (input.length > peg$currPos) {
                s6 = input.charAt(peg$currPos);peg$currPos++;
              } else {
                s6 = peg$FAILED;if (peg$silentFails === 0) {
                  peg$fail(peg$c64);
                }
              }if (s6 !== peg$FAILED) {
                s5 = [s5, s6];s4 = s5;
              } else {
                peg$currPos = s4;s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;s4 = peg$FAILED;
            }
          }
        } else {
          s3 = peg$FAILED;
        }if (s3 !== peg$FAILED) {
          peg$savedPos = s2;s3 = peg$c91();
        }s2 = s3;if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 39) {
            s3 = peg$c89;peg$currPos++;
          } else {
            s3 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c90);
            }
          }if (s3 !== peg$FAILED) {
            peg$savedPos = s0;s1 = peg$c92(s2);s0 = s1;
          } else {
            peg$currPos = s0;s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;s0 = peg$FAILED;
      }return s0;
    }function peg$parsealnum() {
      var s0, s1;peg$silentFails++;if (peg$c94.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);peg$currPos++;
      } else {
        s0 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c95);
        }
      }peg$silentFails--;if (s0 === peg$FAILED) {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c93);
        }
      }return s0;
    }function peg$parsespace() {
      var s0, s1;peg$silentFails++;s0 = [];if (peg$c97.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);peg$currPos++;
      } else {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c98);
        }
      }if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);if (peg$c97.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);peg$currPos++;
          } else {
            s1 = peg$FAILED;if (peg$silentFails === 0) {
              peg$fail(peg$c98);
            }
          }
        }
      } else {
        s0 = peg$FAILED;
      }peg$silentFails--;if (s0 === peg$FAILED) {
        s1 = peg$FAILED;if (peg$silentFails === 0) {
          peg$fail(peg$c96);
        }
      }return s0;
    }var _options = options,
        AST = _options.AST,
        Exp = _options.Exp,
        unescapeValue = _options.unescapeValue,
        resolveFieldValue = _options.resolveFieldValue;
    var ctx = Object.assign({ error: error }, options);peg$result = peg$startRuleFunction();if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail(peg$endExpectation());
      }throw peg$buildStructuredError(peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1) : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
    }
  }return { SyntaxError: peg$SyntaxError, parse: peg$parse };
}();

var unescapeValue = function unescapeValue(value) {
  return value.replace(/\\([:\-\\])/, '$1');
};

var escapeValue = function escapeValue(value) {
  return value.replace(/([:\-\\])/, '\\$1');
};

var Exp = {
  date: function date(expression, location) {
    return { type: 'date', expression: expression, location: location };
  },
  number: function number(expression, location) {
    return { type: 'number', expression: expression, location: location };
  },
  string: function string(expression, location) {
    return { type: 'string', expression: expression, location: location };
  },
  boolean: function boolean(expression, location) {
    return { type: 'boolean', expression: expression, location: location };
  }
};

var validateFlag = function validateFlag(flag, location, ctx) {
  if (ctx.schema && ctx.schema.strict) {
    if (ctx.schema.flags && ctx.schema.flags.includes(flag)) {
      return;
    }
    if (ctx.schema.fields && ctx.schema.fields[flag] && ctx.schema.fields[flag].type === 'boolean') {
      return;
    }
    ctx.error('Unknown flag `' + flag + '`');
  }
};

var validateFieldValue = function validateFieldValue(field, schemaField, expression, value, location, error) {
  if (schemaField && schemaField.validate) {
    try {
      schemaField.validate(value);
    } catch (e) {
      error('Invalid value `' + expression + '` set for field `' + field + '` - ' + e.message, location);
    }
  }
};

var resolveFieldValue = function resolveFieldValue(field, valueExpression, ctx) {
  var schema = ctx.schema,
      error = ctx.error,
      parseDate = ctx.parseDate;

  if ((0, _predicate.isArray)(valueExpression)) {
    return valueExpression.map(function (exp) {
      return resolveFieldValue(field, exp, ctx);
    });
  }
  var type = valueExpression.type,
      expression = valueExpression.expression,
      location = valueExpression.location;

  if (schema && !schema.fields[field] && schema.strict) {
    error('Unknown field `' + field + '`', location);
  }
  var schemaField = schema && schema.fields[field];
  if (schemaField && schemaField.type !== type && schema.strict) {
    var valueDesc = schemaField.valueDescription || 'a ' + schemaField.type + ' value';
    error('Expected ' + valueDesc + ' for field `' + field + '`, but found `' + expression + '`', location);
  }
  switch (type) {

    case 'date':
      var date = null;
      try {
        date = parseDate(expression);
      } catch (e) {
        error('Invalid data `' + expression + '` set for field `' + field + '`', location);
      }
      validateFieldValue(field, schemaField, expression, date, location, error);
      return date;

    case 'number':
      var number = Number(expression);
      if (Number.isNaN(number)) {
        error('Invalid number `' + expression + '` set for field `' + field + '`', location);
      }
      validateFieldValue(field, schemaField, expression, number, location, error);
      return number;

    case 'boolean':
      var boolean = !!expression.match(/true|yes|on/i);
      validateFieldValue(field, schemaField, expression, boolean, location, error);
      return boolean;

    default:
      validateFieldValue(field, schemaField, expression, expression, location, error);
      return expression;
  }
};

var printValue = function printValue(value, options) {
  if ((0, _date_value.isDateValue)(value)) {
    return '\'' + value.text + '\'';
  }
  if ((0, _predicate.isDateLike)(value)) {
    var dateFormat = options.dateFormat || _date_format.dateFormat;
    return '\'' + dateFormat.print(value) + '\'';
  }
  if (!(0, _predicate.isString)(value)) {
    return value.toString();
  }
  if (value.match(/\s/)) {
    return '"' + escapeValue(value) + '"';
  }
  return escapeValue(value);
};

var resolveOperator = function resolveOperator(operator) {
  switch (operator) {
    case _ast.AST.Operator.EQ:
      return ':';
    case _ast.AST.Operator.GT:
      return '>';
    case _ast.AST.Operator.GTE:
      return '>=';
    case _ast.AST.Operator.LT:
      return '<';
    case _ast.AST.Operator.LTE:
      return '<=';
    default:
      throw new Error('unknown field/value operator [' + operator + ']');
  }
};

var defaultSyntax = exports.defaultSyntax = Object.freeze({

  parse: function parse(query) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var dateFormat = options.dateFormat || _date_format.dateFormat;
    var parseDate = (0, _date_value.dateValueParser)(dateFormat);
    var schema = options.schema || {};
    var clauses = parser.parse(query, {
      AST: _ast.AST,
      Exp: Exp,
      unescapeValue: unescapeValue,
      parseDate: parseDate,
      resolveFieldValue: resolveFieldValue,
      validateFlag: validateFlag,
      schema: _extends({ strict: false, flags: [], fields: {} }, schema)
    });
    return _ast.AST.create(clauses);
  },

  print: function print(ast) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return ast.clauses.reduce(function (text, clause) {
      var prefix = _ast.AST.Match.isMustClause(clause) ? '' : '-';
      switch (clause.type) {
        case _ast.AST.Field.TYPE:
          var op = resolveOperator(clause.operator);
          if ((0, _predicate.isArray)(clause.value)) {
            return text + ' ' + prefix + escapeValue(clause.field) + op + '(' + clause.value.map(function (val) {
              return printValue(val, options);
            }).join(' or ') + ')';
          }
          return text + ' ' + prefix + escapeValue(clause.field) + op + printValue(clause.value, options);
        case _ast.AST.Is.TYPE:
          return text + ' ' + prefix + 'is:' + escapeValue(clause.flag);case _ast.AST.Term.TYPE:
          return text + ' ' + prefix + printValue(clause.value, options);
        default:
          return text;
      }
    }, '').trim();
  }

});