'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDescribedFormGroup = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _title = require('../../title/title');

var _text = require('../../text/text');

var _flex = require('../../flex');

var _flex_group = require('../../flex/flex_group');

var _make_id = require('../form_row/make_id');

var _make_id2 = _interopRequireDefault(_make_id);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var paddingSizeToClassNameMap = {
  xxxs: 'euiDescribedFormGroup__fieldPadding--xxxsmall',
  xxs: 'euiDescribedFormGroup__fieldPadding--xxsmall',
  xs: 'euiDescribedFormGroup__fieldPadding--xsmall',
  s: 'euiDescribedFormGroup__fieldPadding--small',
  m: 'euiDescribedFormGroup__fieldPadding--medium',
  l: 'euiDescribedFormGroup__fieldPadding--large'
};

var EuiDescribedFormGroup = exports.EuiDescribedFormGroup = function (_Component) {
  _inherits(EuiDescribedFormGroup, _Component);

  function EuiDescribedFormGroup(props) {
    _classCallCheck(this, EuiDescribedFormGroup);

    var _this = _possibleConstructorReturn(this, (EuiDescribedFormGroup.__proto__ || Object.getPrototypeOf(EuiDescribedFormGroup)).call(this, props));

    _this.ariaId = props.idAria || (0, _make_id2.default)();
    return _this;
  }

  _createClass(EuiDescribedFormGroup, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          gutterSize = _props.gutterSize,
          fullWidth = _props.fullWidth,
          titleSize = _props.titleSize,
          title = _props.title,
          description = _props.description,
          userAriaId = _props.idAria,
          rest = _objectWithoutProperties(_props, ['children', 'className', 'gutterSize', 'fullWidth', 'titleSize', 'title', 'description', 'idAria']);

      var ariaId = this.ariaId;

      var classes = (0, _classnames2.default)('euiDescribedFormGroup', {
        'euiDescribedFormGroup--fullWidth': fullWidth
      }, className);

      var fieldClasses = (0, _classnames2.default)('euiDescribedFormGroup__fields', paddingSizeToClassNameMap[titleSize]);

      var ariaProps = {
        'aria-labelledby': ariaId + '-title',

        // if user has defined an aria ID, assume they have passed the ID to
        // the form row describedByIds and skip describedby here
        'aria-describedby': userAriaId ? null : ariaId
      };

      return _react2.default.createElement(
        'div',
        _extends({
          role: 'group',
          className: classes
        }, ariaProps, rest),
        _react2.default.createElement(
          _flex.EuiFlexGroup,
          { gutterSize: gutterSize },
          _react2.default.createElement(
            _flex.EuiFlexItem,
            null,
            _react2.default.createElement(
              _title.EuiTitle,
              { id: ariaId + '-title', size: titleSize, className: 'euiDescribedFormGroup__title' },
              title
            ),
            _react2.default.createElement(
              _text.EuiText,
              { id: ariaId, size: 's', color: 'subdued', className: 'euiDescribedFormGroup__description' },
              description
            )
          ),
          _react2.default.createElement(
            _flex.EuiFlexItem,
            { className: fieldClasses },
            children
          )
        )
      );
    }
  }]);

  return EuiDescribedFormGroup;
}(_react.Component);

EuiDescribedFormGroup.propTypes = {
  /**
   * One or more `EuiFormRow`s
   */
  children: _propTypes2.default.node.isRequired,
  className: _propTypes2.default.string,
  /**
   * Passed to `EuiFlexGroup`
   */
  gutterSize: _propTypes2.default.oneOf(_flex_group.GUTTER_SIZES),
  fullWidth: _propTypes2.default.bool,
  titleSize: _propTypes2.default.oneOf(_title.TITLE_SIZES),
  title: _propTypes2.default.node.isRequired,
  description: _propTypes2.default.node.isRequired,
  idAria: _propTypes2.default.string
};

EuiDescribedFormGroup.defaultProps = {
  gutterSize: 'l',
  titleSize: 'xs',
  fullWidth: false
};
EuiDescribedFormGroup.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiDescribedFormGroup',
  'methods': [],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': true,
      'description': 'One or more `EuiFormRow`s'
    },
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'gutterSize': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'GUTTER_SIZES'
      },
      'required': false,
      'description': 'Passed to `EuiFlexGroup`',
      'defaultValue': {
        'value': '\'l\'',
        'computed': false
      }
    },
    'fullWidth': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': 'false',
        'computed': false
      }
    },
    'titleSize': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'TITLE_SIZES'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': '\'xs\'',
        'computed': false
      }
    },
    'title': {
      'type': {
        'name': 'node'
      },
      'required': true,
      'description': ''
    },
    'description': {
      'type': {
        'name': 'node'
      },
      'required': true,
      'description': ''
    },
    'idAria': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    }
  }
}];