/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.micrometer.runtime.binder.vertx.EventTiming;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class VertxPoolMetrics
implements PoolMetrics<EventTiming> {
    private final String poolType;
    private final int maxPoolSize;
    private final Timer usage;
    private final AtomicReference<Double> ratio = new AtomicReference();
    private final LongAdder current = new LongAdder();
    private final LongAdder queue = new LongAdder();
    private final Counter completed;
    private final Counter rejected;
    private final Timer queueDelay;

    VertxPoolMetrics(MeterRegistry registry, String poolType, String poolName, final int maxPoolSize) {
        this.poolType = poolType;
        this.maxPoolSize = maxPoolSize;
        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"pool.type", (String)poolType), Tag.of((String)"pool.name", (String)poolName)});
        this.queueDelay = Timer.builder((String)this.name("queue.delay")).description("Time spent in the waiting queue before being processed").tags((Iterable)tags).register(registry);
        this.usage = Timer.builder((String)this.name("usage")).description("Time spent using resources from the pool").tags((Iterable)tags).register(registry);
        Gauge.builder((String)this.name("queue.size"), (Supplier)new Supplier<Number>(){

            @Override
            public Number get() {
                return VertxPoolMetrics.this.queue.doubleValue();
            }
        }).description("Number of pending elements in the waiting queue").tags((Iterable)tags).strongReference(true).register(registry);
        Gauge.builder((String)this.name("active"), (Supplier)new Supplier<Number>(){

            @Override
            public Number get() {
                return VertxPoolMetrics.this.current.doubleValue();
            }
        }).description("The number of resources from the pool currently used").tags((Iterable)tags).strongReference(true).register(registry);
        if (maxPoolSize > 0) {
            Gauge.builder((String)this.name("idle"), (Supplier)new Supplier<Number>(){

                @Override
                public Number get() {
                    return (double)maxPoolSize - VertxPoolMetrics.this.current.doubleValue();
                }
            }).description("The number of resources from the pool currently used").tags((Iterable)tags).strongReference(true).register(registry);
            Gauge.builder((String)this.name("ratio"), this.ratio::get).description("Pool usage ratio").tags((Iterable)tags).strongReference(true).register(registry);
        }
        this.completed = Counter.builder((String)this.name("completed")).description("Number of times resources from the pool have been acquired").tags((Iterable)tags).register(registry);
        this.rejected = Counter.builder((String)this.name("rejected")).description("Number of times submissions to the pool have been rejected").tags((Iterable)tags).register(registry);
    }

    private String name(String suffix) {
        return this.poolType + ".pool." + suffix;
    }

    public EventTiming submitted() {
        this.queue.increment();
        return new EventTiming(this.queueDelay);
    }

    public void rejected(EventTiming submitted) {
        this.queue.decrement();
        this.rejected.increment();
        submitted.end();
    }

    public EventTiming begin(EventTiming submitted) {
        this.queue.decrement();
        submitted.end();
        this.current.increment();
        this.computeRatio(this.current.longValue());
        return new EventTiming(this.usage);
    }

    public void end(EventTiming timer, boolean succeeded) {
        this.current.decrement();
        this.computeRatio(this.current.longValue());
        timer.end();
        this.completed.increment();
    }

    public void close() {
    }

    private void computeRatio(long inUse) {
        if (this.maxPoolSize > 0) {
            this.ratio.set((double)inUse / (double)this.maxPoolSize);
        }
    }
}

