/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;
import org.apache.log.output.AbstractTarget;
import org.apache.log.util.Closeable;

public class PriorityFilteringTarget
extends AbstractTarget {
    private final Priority m_priority;
    private final boolean m_closeWrapped;
    private LogTarget[] m_targets;

    public PriorityFilteringTarget(Priority priority, boolean closeWrappedTarget) {
        this.m_priority = priority;
        this.m_closeWrapped = closeWrappedTarget;
        this.open();
    }

    public PriorityFilteringTarget(Priority priority) {
        this(priority, false);
    }

    public void addTarget(LogTarget target) {
        if (null == this.m_targets) {
            this.m_targets = new LogTarget[]{target};
        } else {
            LogTarget[] oldTargets = this.m_targets;
            this.m_targets = new LogTarget[oldTargets.length + 1];
            System.arraycopy(oldTargets, 0, this.m_targets, 0, oldTargets.length);
            this.m_targets[this.m_targets.length - 1] = target;
        }
    }

    protected void doProcessEvent(LogEvent event) throws Exception {
        if (event != null && this.m_targets != null && !event.getPriority().isLower(this.m_priority)) {
            for (int i = 0; i < this.m_targets.length; ++i) {
                this.m_targets[i].processEvent(event);
            }
        }
    }

    public void close() {
        super.close();
        if (this.m_closeWrapped && this.m_targets != null) {
            for (int i = 0; i < this.m_targets.length; ++i) {
                if (!(this.m_targets[i] instanceof Closeable)) continue;
                ((Closeable)((Object)this.m_targets[i])).close();
            }
        }
    }
}

