/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseFrameDecoder;

public class L100FrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 10) {
            return null;
        }
        if (buf.getCharSequence(buf.readerIndex(), 4, StandardCharsets.US_ASCII).toString().equals("ATL,")) {
            return this.decodeNew(buf);
        }
        return this.decodeOld(buf);
    }

    private Object decodeOld(ByteBuf buf) {
        int index;
        boolean obd;
        byte header = buf.getByte(buf.readerIndex());
        boolean bl = obd = header == 76 || header == 72;
        if (obd) {
            index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)42);
        } else {
            index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)2);
            if (index < 0 && (index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)4)) < 0) {
                return null;
            }
        }
        if (buf.writerIndex() >= (index += 2)) {
            if (!obd) {
                buf.skipBytes(2);
            }
            ByteBuf frame = buf.readRetainedSlice(index - buf.readerIndex() - 2);
            buf.skipBytes(2);
            return frame;
        }
        return null;
    }

    private Object decodeNew(ByteBuf buf) {
        int index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)64);
        if (index < 0) {
            return null;
        }
        if (buf.writerIndex() >= index + 1) {
            ByteBuf frame = buf.readRetainedSlice(index - buf.readerIndex());
            buf.skipBytes(1);
            return frame;
        }
        return null;
    }
}

