/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ShareGroupDescribeResponse
extends AbstractResponse {
    private final ShareGroupDescribeResponseData data;

    public ShareGroupDescribeResponse(ShareGroupDescribeResponseData data) {
        super(ApiKeys.SHARE_GROUP_DESCRIBE);
        this.data = data;
    }

    @Override
    public ShareGroupDescribeResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> counts = new EnumMap<Errors, Integer>(Errors.class);
        this.data.groups().forEach(group -> ShareGroupDescribeResponse.updateErrorCounts(counts, Errors.forCode(group.errorCode())));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ShareGroupDescribeResponse parse(Readable readable, short version) {
        return new ShareGroupDescribeResponse(new ShareGroupDescribeResponseData(readable, version));
    }
}

