/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class IndexRowToBaseRowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private GeneratedMethod restriction;
    public FormatableBitSet accessedHeapCols;
    private FormatableBitSet accessedAllCols;
    public String indexName;
    private int[] indexCols;
    private DynamicCompiledOpenConglomInfo dcoci;
    private StaticCompiledOpenConglomInfo scoci;
    private ConglomerateController baseCC;
    private boolean closeBaseCCHere;
    private boolean forUpdate;
    private DataValueDescriptor[] rowArray;
    RowLocation baseRowLocation;
    boolean copiedFromSource;
    public long restrictionTime;
    private int _baseColumnCount;
    private boolean _includeRowLocation;
    private FormatableBitSet _heapColsWithoutRowLocation;

    IndexRowToBaseRowResultSet(long conglomId, int scociItem, Activation a, NoPutResultSet source, int resultRowAllocator, int resultSetNumber, String indexName, int heapColRefItem, int allColRefItem, int heapOnlyColRefItem, int indexColMapItem, GeneratedMethod restriction, boolean forUpdate, double optimizerEstimatedRowCount, double optimizerEstimatedCost, int baseColumnCount) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        GenericPreparedStatement gp = (GenericPreparedStatement)a.getPreparedStatement();
        this.scoci = (StaticCompiledOpenConglomInfo)gp.getSavedObject(scociItem);
        TransactionController tc = this.activation.getTransactionController();
        this.dcoci = tc.getDynamicCompiledConglomInfo(conglomId);
        this.source = source;
        this.indexName = indexName;
        this.forUpdate = forUpdate;
        this.restriction = restriction;
        this._baseColumnCount = baseColumnCount;
        if (heapColRefItem != -1) {
            this.accessedHeapCols = (FormatableBitSet)gp.getSavedObject(heapColRefItem);
        }
        if (allColRefItem != -1) {
            this.accessedAllCols = (FormatableBitSet)gp.getSavedObject(allColRefItem);
        }
        this.indexCols = ((ReferencedColumnsDescriptorImpl)gp.getSavedObject(indexColMapItem)).getReferencedColumnPositions();
        ExecRow resultRow = ((ExecRowBuilder)gp.getSavedObject(resultRowAllocator)).build(a.getExecutionFactory());
        this.getCompactRow(resultRow, this.accessedAllCols, false);
        if (this.accessedHeapCols == null) {
            this.rowArray = resultRow.getRowArray();
        } else {
            DataValueDescriptor[] resultRowArray = resultRow.getRowArray();
            FormatableBitSet heapOnly = (FormatableBitSet)gp.getSavedObject(heapOnlyColRefItem);
            int heapOnlyLen = heapOnly.getLength();
            this.rowArray = new DataValueDescriptor[heapOnlyLen];
            int minLen = Math.min(resultRowArray.length, heapOnlyLen);
            for (int i = 0; i < minLen; ++i) {
                if (resultRowArray[i] == null || !heapOnly.isSet(i)) continue;
                this.rowArray[i] = resultRowArray[i];
            }
        }
        boolean bl = this._includeRowLocation = this._baseColumnCount < this.accessedHeapCols.getLength();
        if (this._includeRowLocation) {
            this._heapColsWithoutRowLocation = (FormatableBitSet)this.accessedHeapCols.clone();
            this._heapColsWithoutRowLocation.clear(this.accessedHeapCols.getLength() - 1);
        }
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        boolean lockingRequired = false;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"IndexRowToBaseRowResultSet already open");
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.source.requiresRelocking()) {
            lockingRequired = true;
        }
        TransactionController tc = this.activation.getTransactionController();
        int openMode = this.forUpdate ? 4 : 0;
        int isolationLevel = this.source.getScanIsolationLevel();
        if (!lockingRequired) {
            openMode |= 0x2000;
        }
        if (this.forUpdate) {
            this.baseCC = this.activation.getHeapConglomerateController();
        }
        if (this.baseCC == null) {
            this.baseCC = tc.openCompiledConglomerate(this.activation.getResultSetHoldability(), openMode, 6, isolationLevel, this.scoci, this.dcoci);
            this.closeBaseCCHere = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"IndexRowToBaseRowResultSet already open");
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow sourceRow = null;
        ExecRow retval = null;
        boolean restrict = false;
        long beginRT = 0L;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException((String)"XCL16.S", (Object[])new Object[]{"next"});
        }
        do {
            if ((sourceRow = this.source.getNextRowCore()) != null) {
                SanityManager.ASSERT((boolean)(sourceRow.getColumn(sourceRow.nColumns()) instanceof RowLocation), (String)"Last column of source row is not a RowLocation");
                this.baseRowLocation = (RowLocation)sourceRow.getColumn(sourceRow.nColumns());
                boolean row_exists = this.baseCC.fetch(this.baseRowLocation, this.rowArray, this._includeRowLocation ? this._heapColsWithoutRowLocation : this.accessedHeapCols);
                if (row_exists) {
                    if (!this.copiedFromSource) {
                        this.copiedFromSource = true;
                        for (int index = 0; index < this.indexCols.length; ++index) {
                            if (this.indexCols[index] == -1) continue;
                            this.compactRow.setColumn(index + 1, sourceRow.getColumn(this.indexCols[index] + 1));
                        }
                    }
                    this.setCurrentRow(this.compactRow);
                    DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                    this.restrictionTime += this.getElapsedMillis(beginRT);
                    boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                }
                if (!restrict || !row_exists) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                    this.baseRowLocation = null;
                } else {
                    this.currentRow = this.compactRow;
                }
                if (this._includeRowLocation) {
                    this.currentRow.setColumn(this.currentRow.nColumns(), this.baseRowLocation);
                }
                ++this.rowsSeen;
                retval = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            this.baseRowLocation = null;
            retval = null;
        } while (sourceRow != null && !restrict);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return retval;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeBaseCCHere && this.baseCC != null) {
                this.baseCC.close();
            }
            this.baseCC = null;
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of IndexRowToBaseRowResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
        this.baseRowLocation = rl;
        this.source.positionScanAtRowLocation(rl);
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        ExecRow sourceRow = null;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"IndexRowToBaseRowResultSet is expected to be open");
        if (this.currentRow == null) {
            return null;
        }
        sourceRow = this.activation.getExecutionFactory().getValueRow(this.indexCols.length);
        sourceRow.setRowArray(this.rowArray);
        boolean row_exists = this.baseCC.fetch(this.baseRowLocation, this.rowArray, null);
        if (row_exists) {
            this.setCurrentRow(sourceRow);
        } else {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }
}

