/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.version;

import org.jitsi.utils.version.Version;

public class VersionImpl
implements Version {
    private final String applicationName;
    private final int versionMajor;
    private final int versionMinor;
    private final String nightlyBuildID;
    private final String preReleaseId;

    public VersionImpl(String applicationName, int majorVersion, int minorVersion) {
        this(applicationName, majorVersion, minorVersion, null);
    }

    public VersionImpl(String applicationName, int majorVersion, int minorVersion, String nightlyBuildID) {
        this(applicationName, majorVersion, minorVersion, nightlyBuildID, null);
    }

    public VersionImpl(String applicationName, int majorVersion, int minorVersion, String nightlyBuildID, String preReleaseId) {
        this.applicationName = applicationName;
        this.versionMajor = majorVersion;
        this.versionMinor = minorVersion;
        this.nightlyBuildID = nightlyBuildID;
        this.preReleaseId = preReleaseId;
    }

    @Override
    public int getVersionMajor() {
        return this.versionMajor;
    }

    @Override
    public int getVersionMinor() {
        return this.versionMinor;
    }

    @Override
    public boolean isNightly() {
        return this.nightlyBuildID != null;
    }

    @Override
    public String getNightlyBuildID() {
        if (!this.isNightly()) {
            return null;
        }
        return this.nightlyBuildID;
    }

    @Override
    public boolean isPreRelease() {
        return this.preReleaseId != null;
    }

    @Override
    public String getPreReleaseID() {
        return this.preReleaseId;
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return -1;
        }
        if (this.getVersionMajor() != version.getVersionMajor()) {
            return this.getVersionMajor() - version.getVersionMajor();
        }
        if (this.getVersionMinor() != version.getVersionMinor()) {
            return this.getVersionMinor() - version.getVersionMinor();
        }
        try {
            return VersionImpl.compareNightlyBuildIDByComponents(this.getNightlyBuildID(), version.getNightlyBuildID());
        }
        catch (Throwable throwable) {
            return this.getNightlyBuildID().compareTo(version.getNightlyBuildID());
        }
    }

    private static int compareNightlyBuildIDByComponents(String v1, String v2) {
        String[] s1 = v1.split("\\.");
        String[] s2 = v2.split("\\.");
        int len = Math.max(s1.length, s2.length);
        for (int i = 0; i < len; ++i) {
            int n1 = 0;
            int n2 = 0;
            if (i < s1.length) {
                n1 = Integer.parseInt(s1[i]);
            }
            if (i < s2.length) {
                n2 = Integer.parseInt(s2[i]);
            }
            if (n1 == n2) continue;
            return n1 - n2;
        }
        return 0;
    }

    @Override
    public boolean equals(Object version) {
        if (version == null) {
            return false;
        }
        return this.toString().equals(version.toString());
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer versionStringBuff = new StringBuffer();
        versionStringBuff.append(this.getVersionMajor());
        versionStringBuff.append(".");
        versionStringBuff.append(this.getVersionMinor());
        if (this.isPreRelease()) {
            versionStringBuff.append("-");
            versionStringBuff.append(this.getPreReleaseID());
        }
        if (this.isNightly()) {
            versionStringBuff.append(".");
            versionStringBuff.append(this.getNightlyBuildID());
        }
        return versionStringBuff.toString();
    }
}

