/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dcsctp4j;

import smjni.jnigen.ExposeToNative;

@ExposeToNative
public enum SendStatus {
    kSuccess(0),
    kErrorMessageEmpty(1),
    kErrorMessageTooLarge(2),
    kErrorResourceExhaustion(3),
    kErrorShuttingDown(4);

    public final int nativeStatus;

    private SendStatus(int n2) {
        this.nativeStatus = n2;
    }

    static SendStatus fromNativeStatus(int nativeStatus) {
        SendStatus javaStatus;
        switch (nativeStatus) {
            case 0: {
                javaStatus = kSuccess;
                break;
            }
            case 1: {
                javaStatus = kErrorMessageEmpty;
                break;
            }
            case 2: {
                javaStatus = kErrorMessageTooLarge;
                break;
            }
            case 3: {
                javaStatus = kErrorResourceExhaustion;
                break;
            }
            case 4: {
                javaStatus = kErrorShuttingDown;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad native status value " + nativeStatus);
            }
        }
        if (javaStatus.nativeStatus != nativeStatus) {
            throw new IllegalStateException("native status " + nativeStatus + " was mapped to java status " + javaStatus + " == " + javaStatus.nativeStatus);
        }
        return javaStatus;
    }
}

