/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.MessageProcessorFactory;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;

public class OIOMessageProcessorFactory
implements MessageProcessorFactory {
    @Override
    public MessageProcessor createMessageProcessor(SIPTransactionStack sipStack, InetAddress ipAddress, int port2, String transport) throws IOException {
        if (transport.equalsIgnoreCase("UDP")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(ipAddress, sipStack, port2);
            sipStack.udpFlag = true;
            return udpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("TCP")) {
            TCPMessageProcessor tcpMessageProcessor = new TCPMessageProcessor(ipAddress, sipStack, port2);
            return tcpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("TLS")) {
            TLSMessageProcessor tlsMessageProcessor = new TLSMessageProcessor(ipAddress, sipStack, port2);
            return tlsMessageProcessor;
        }
        if (transport.equalsIgnoreCase("SCTP")) {
            try {
                Class<?> mpc = ClassLoader.getSystemClassLoader().loadClass("gov.nist.javax.sip.stack.sctp.SCTPMessageProcessor");
                MessageProcessor mp = (MessageProcessor)mpc.newInstance();
                mp.initialize(ipAddress, port2, sipStack);
                return mp;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("SCTP not supported (needs Java 7 and SCTP jar in classpath)");
            }
            catch (InstantiationException ie) {
                throw new IllegalArgumentException("Error initializing SCTP", ie);
            }
            catch (IllegalAccessException ie) {
                throw new IllegalArgumentException("Error initializing SCTP", ie);
            }
        }
        throw new IllegalArgumentException("bad transport");
    }
}

