/*
 * (C) Copyright 2011- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

#ifndef ECCODES_ecbuild_config_h
#define ECCODES_ecbuild_config_h

/* ecbuild info */

#ifndef ECBUILD_VERSION_STR
#define ECBUILD_VERSION_STR "3.11.0"
#endif
#ifndef ECBUILD_VERSION
#define ECBUILD_VERSION "3.11.0"
#endif
#ifndef ECBUILD_MACROS_DIR
#define ECBUILD_MACROS_DIR  "/usr/obj/ports/eccodes-2.44pre66/eccodes-2.44.66-Source/cmake"
#endif

/* config info */

#define ECCODES_OS_NAME          "OpenBSD-7.8"
#define ECCODES_OS_BITS          64
#define ECCODES_OS_BITS_STR      "64"
#define ECCODES_OS_STR           "UNKNOWN.64"
#define ECCODES_OS_VERSION       "7.8"
#define ECCODES_SYS_PROCESSOR    "aarch64"

#define ECCODES_BUILD_TIMESTAMP  "20251021223825"
#define ECCODES_BUILD_TYPE       "Release"

#define ECCODES_C_COMPILER_ID      "GNU"
#define ECCODES_C_COMPILER_VERSION "8.4.0"

#define ECCODES_CXX_COMPILER_ID      "Clang"
#define ECCODES_CXX_COMPILER_VERSION "19.1.7"

#define ECCODES_C_COMPILER       "/usr/obj/ports/eccodes-2.44pre66/bin/cc"
#define ECCODES_C_FLAGS          "-O2 -pipe -pipe -DNDEBUG"

#define ECCODES_CXX_COMPILER     "/usr/obj/ports/eccodes-2.44pre66/bin/c++"
#define ECCODES_CXX_FLAGS        "-O2 -pipe -pipe -DNDEBUG"

/* Needed for finding per package config files */

#define ECCODES_INSTALL_DIR       "/usr/local"
#define ECCODES_INSTALL_BIN_DIR   "/usr/local/bin"
#define ECCODES_INSTALL_LIB_DIR   "/usr/local/lib"
#define ECCODES_INSTALL_DATA_DIR  "/usr/local/share/eccodes"

#define ECCODES_DEVELOPER_SRC_DIR "/usr/obj/ports/eccodes-2.44pre66/eccodes-2.44.66-Source"
#define ECCODES_DEVELOPER_BIN_DIR "/usr/obj/ports/eccodes-2.44pre66/build-aarch64"

/* Fortran support */

#if 1

#define ECCODES_Fortran_COMPILER_ID      "GNU"
#define ECCODES_Fortran_COMPILER_VERSION "8.4.0"

#define ECCODES_Fortran_COMPILER "/usr/obj/ports/eccodes-2.44pre66/bin/gfortran"
#define ECCODES_Fortran_FLAGS    " -DNDEBUG -funroll-all-loops -finline-functions"

#endif

#endif /* ECCODES_ecbuild_config_h */
