/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssGridAutoFlow
extends org.w3c.css.properties.css.CssGridAutoFlow {
    public static final CssIdent[] allowed_values;
    public static final CssIdent dense;
    public static final CssIdent row;
    public static final CssIdent column;

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssGridAutoFlow() {
        this.value = initial;
    }

    public CssGridAutoFlow(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        boolean got_axis = false;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 0: {
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        values.add(val);
                        break;
                    }
                    if (CssGridAutoFlow.getAllowedIdent(id) != null) {
                        if (got_axis) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        got_axis = true;
                        values.add(val);
                        break;
                    }
                    if (dense.equals(id)) {
                        if (values.size() > 0 && !got_axis) {
                            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                        }
                        values.add(val);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    public CssGridAutoFlow(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        dense = CssIdent.getIdent("dense");
        row = CssIdent.getIdent("row");
        column = CssIdent.getIdent("column");
        allowed_values = new CssIdent[]{row, column};
    }
}

