/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.TypeClass;
import com.googlecode.dex2jar.ir.expr.ArrayExpr;
import com.googlecode.dex2jar.ir.expr.BinopExpr;
import com.googlecode.dex2jar.ir.expr.CastExpr;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.FieldExpr;
import com.googlecode.dex2jar.ir.expr.FilledArrayExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.NewMutiArrayExpr;
import com.googlecode.dex2jar.ir.expr.RefExpr;
import com.googlecode.dex2jar.ir.expr.StaticFieldExpr;
import com.googlecode.dex2jar.ir.expr.TypeExpr;
import com.googlecode.dex2jar.ir.expr.UnopExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TypeTransformer
implements Transformer {
    private static final String[] possibleIntTypes = new String[]{"B", "S", "C", "I"};

    @Override
    public void transform(IrMethod irMethod) {
        TypeAnalyze ta = new TypeAnalyze(irMethod);
        List<TypeRef> refs = ta.analyze();
        for (TypeRef ref : refs) {
            String type = ref.getType();
            if (type == null) {
                System.err.println(ref);
                continue;
            }
            if (ref.value.vt == Value.VT.CONSTANT) {
                Constant cst = (Constant)ref.value;
                switch (type.charAt(0)) {
                    case 'L': 
                    case '[': {
                        int i;
                        Object[] f;
                        Object[] x;
                        if (Integer.valueOf(0).equals(cst.value)) {
                            cst.value = Constant.Null;
                        }
                        if (type.equals("[F") && cst.value instanceof int[]) {
                            x = (int[])cst.value;
                            f = new float[x.length];
                            i = 0;
                            while (i < x.length) {
                                f[i] = Float.intBitsToFloat(x[i]);
                                ++i;
                            }
                            cst.value = f;
                        }
                        if (!type.equals("[D") || !(cst.value instanceof long[])) break;
                        x = (long[])cst.value;
                        f = new double[x.length];
                        i = 0;
                        while (i < x.length) {
                            f[i] = (float)Double.longBitsToDouble(x[i]);
                            ++i;
                        }
                        cst.value = f;
                        break;
                    }
                    case 'F': {
                        if (cst.value instanceof Float) break;
                        cst.value = Float.valueOf(Float.intBitsToFloat(((Number)cst.value).intValue()));
                        break;
                    }
                    case 'D': {
                        if (cst.value instanceof Double) break;
                        cst.value = Double.longBitsToDouble(((Number)cst.value).longValue());
                    }
                }
            }
            Value value = ref.value;
            value.valueType = type;
            value.tag = null;
            ref.clear();
        }
    }

    private static class TypeAnalyze {
        protected IrMethod method;
        private List<TypeRef> refs = new ArrayList<TypeRef>();

        public TypeAnalyze(IrMethod method) {
            this.method = method;
        }

        public List<TypeRef> analyze() {
            this.sxStmt();
            this.fixTypes();
            return this.refs;
        }

        /*
         * Unable to fully structure code
         */
        private void fixTypes() {
            arrayRoots = new HashSet<TypeRef>();
            for (TypeRef t : this.refs) {
                if (t.gArrayValues == null && t.sArrayValues == null) continue;
                arrayRoots.add(t);
            }
            q = new UniqueQueue<TypeRef>();
            q.addAll((Collection<TypeRef>)this.refs);
            ** GOTO lbl38
            {
                ref = (TypeRef)q.poll();
                this.copyTypes(q, ref);
                do {
                    if (!q.isEmpty()) continue block1;
                    for (TypeRef ref : arrayRoots) {
                        provideDesc = ref.provideDesc;
                        if (provideDesc == null || provideDesc.charAt(0) != '[') continue;
                        ele = provideDesc.substring(1);
                        if (ref.gArrayValues != null) {
                            for (TypeRef p : ref.gArrayValues) {
                                if (p.updateTypeClass(TypeClass.clzOf(ele))) {
                                    q.add(p);
                                }
                                this.mergeTypeToSubRef(ele, p, q);
                            }
                        }
                        if (ref.sArrayValues == null) continue;
                        for (TypeRef p : ref.sArrayValues) {
                            if (p.updateTypeClass(TypeClass.clzOf(ele))) {
                                q.add(p);
                            }
                            if (p.uses == null) {
                                p.uses = new HashSet<String>();
                            }
                            if (!p.uses.add(ele)) continue;
                            q.add(p);
                        }
                    }
lbl38:
                    // 2 sources

                } while (!q.isEmpty());
            }
        }

        private void mergeTypeToSubRef(String type, TypeRef target, UniqueQueue<TypeRef> q) {
            if (target.provideDesc == null) {
                target.provideDesc = type;
                q.add(target);
            } else {
                String mergedType = this.mergeType(type, target.provideDesc);
                if (!mergedType.equals(target.provideDesc)) {
                    target.provideDesc = mergedType;
                    q.add(target);
                }
            }
        }

        private void copyTypes(UniqueQueue<TypeRef> q, TypeRef ref) {
            boolean allAreSet;
            TypeClass clz = ref.clz;
            switch (clz) {
                case BOOLEAN: 
                case FLOAT: 
                case DOUBLE: 
                case LONG: 
                case VOID: {
                    ref.provideDesc = clz.name;
                }
            }
            String provideDesc = ref.provideDesc;
            if (provideDesc == null && ref.parents != null && ref.parents.size() > 1 && (allAreSet = this.isAllParentSetted(ref))) {
                ref.provideDesc = provideDesc = this.mergeParentType(ref.parents);
            }
            if (ref.parents != null) {
                for (TypeRef p : ref.parents) {
                    if (p.updateTypeClass(clz)) {
                        q.add(p);
                    }
                    if (ref.uses == null) continue;
                    if (p.uses == null) {
                        p.uses = new HashSet<String>();
                    }
                    if (!p.uses.addAll(ref.uses)) continue;
                    q.add(p);
                }
            }
            if (ref.children != null) {
                for (TypeRef p : ref.children) {
                    if (p.updateTypeClass(clz)) {
                        q.add(p);
                    }
                    if (provideDesc == null) continue;
                    this.mergeTypeToSubRef(provideDesc, p, q);
                }
            }
            if (ref.sameValues != null) {
                for (TypeRef p : ref.sameValues) {
                    if (!p.updateTypeClass(clz)) continue;
                    q.add(p);
                }
            }
        }

        private boolean isAllParentSetted(TypeRef ref) {
            boolean allAreSet = true;
            for (TypeRef p : ref.parents) {
                if (p.provideDesc != null) continue;
                allAreSet = false;
                break;
            }
            return allAreSet;
        }

        private String mergeType(String a, String b) {
            if (a.equals(b)) {
                return a;
            }
            TypeClass ta = TypeClass.clzOf(a);
            TypeClass tb = TypeClass.clzOf(b);
            if (ta.fixed && !tb.fixed) {
                return a;
            }
            if (!ta.fixed && tb.fixed) {
                return b;
            }
            if (ta.fixed && tb.fixed) {
                if (ta != tb) {
                    throw new RuntimeException();
                }
                if (ta == TypeClass.INT) {
                    int i = possibleIntTypes.length - 1;
                    while (i >= 0) {
                        String t = possibleIntTypes[i];
                        if (a.equals(t) || b.equals(t)) {
                            return t;
                        }
                        --i;
                    }
                    return "I";
                }
                if (ta == TypeClass.OBJECT) {
                    int as = this.countArrayDim(a);
                    int bs = this.countArrayDim(b);
                    if (as == 0 || bs == 0) {
                        return "Ljava/lang/Object;";
                    }
                    String elementTypeA = a.substring(as);
                    String elementTypeB = a.substring(bs);
                    if (as > bs) {
                        return this.buildArray(elementTypeB.charAt(0) == 'L' ? bs : bs - 1, "Ljava/lang/Object;");
                    }
                    if (bs > as) {
                        return this.buildArray(elementTypeA.charAt(0) == 'L' ? bs : bs - 1, "Ljava/lang/Object;");
                    }
                    if (elementTypeA.charAt(0) != 'L' || elementTypeB.charAt(0) != 'L') {
                        return this.buildArray(as - 1, "Ljava/lang/Object;");
                    }
                    return this.buildArray(as, "Ljava/lang/Object;");
                }
                throw new RuntimeException();
            }
            return TypeClass.merge((TypeClass)ta, (TypeClass)tb).name;
        }

        private String buildArray(int dim, String s) {
            if (dim == 0) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < dim) {
                sb.append('[');
                ++i;
            }
            sb.append(s);
            return sb.toString();
        }

        private int countArrayDim(String a) {
            int i = 0;
            while (a.charAt(i) == '[') {
                ++i;
            }
            return i;
        }

        private String mergeParentType(Set<TypeRef> parents) {
            Iterator<TypeRef> it = parents.iterator();
            String a = it.next().provideDesc;
            while (it.hasNext()) {
                a = this.mergeType(a, it.next().provideDesc);
            }
            return a;
        }

        private void e0expr(Value.E0Expr op, boolean getValue) {
            switch (op.vt) {
                case LOCAL: {
                    break;
                }
                case NEW: {
                    NewExpr newExpr = (NewExpr)op;
                    this.provideAs(newExpr, newExpr.type);
                    break;
                }
                case EXCEPTION_REF: 
                case PARAMETER_REF: 
                case THIS_REF: {
                    RefExpr refExpr = (RefExpr)op;
                    String refType = refExpr.type;
                    if (refType == null && op.vt == Value.VT.EXCEPTION_REF) {
                        refType = "Ljava/lang/Throwable;";
                    }
                    this.provideAs(refExpr, refType);
                    break;
                }
                case STATIC_FIELD: {
                    StaticFieldExpr fe = (StaticFieldExpr)op;
                    if (getValue) {
                        this.provideAs(fe, fe.type);
                        break;
                    }
                    this.useAs(fe, fe.type);
                    break;
                }
                case CONSTANT: {
                    Constant cst = (Constant)op;
                    Object value = cst.value;
                    if (value instanceof String) {
                        this.provideAs(cst, "Ljava/lang/String;");
                        break;
                    }
                    if (value instanceof Constant.Type) {
                        this.provideAs(cst, "Ljava/lang/Class;");
                        break;
                    }
                    if (value instanceof Number) {
                        if (value instanceof Integer || value instanceof Byte || value instanceof Short) {
                            int a = ((Number)value).intValue();
                            if (a == 0) {
                                this.provideAs(cst, TypeClass.ZIFL.name);
                                break;
                            }
                            if (a == 1) {
                                this.provideAs(cst, TypeClass.ZIF.name);
                                break;
                            }
                            this.provideAs(cst, TypeClass.IF.name);
                            break;
                        }
                        if (value instanceof Long) {
                            this.provideAs(cst, "w");
                            break;
                        }
                        if (value instanceof Float) {
                            this.provideAs(cst, "F");
                            break;
                        }
                        if (!(value instanceof Double)) break;
                        this.provideAs(cst, "D");
                        break;
                    }
                    if (value instanceof Character) {
                        this.provideAs(cst, "C");
                        break;
                    }
                    this.provideAs(cst, "L");
                }
            }
        }

        private void e1expr(Value.E1Expr e1, boolean getValue) {
            Value v = e1.op;
            switch (e1.vt) {
                case CAST: {
                    CastExpr ce = (CastExpr)e1;
                    if (ce.to.equals("B")) {
                        this.useAs(v, TypeClass.ZI.name);
                        this.provideAs(e1, TypeClass.ZI.name);
                        break;
                    }
                    this.useAs(v, ce.from);
                    this.provideAs(e1, ce.to);
                    break;
                }
                case FIELD: {
                    FieldExpr fe = (FieldExpr)e1;
                    if (getValue) {
                        this.provideAs(fe, fe.type);
                    } else {
                        this.useAs(fe, fe.type);
                    }
                    if (v == null) break;
                    this.useAs(v, fe.owner);
                    break;
                }
                case CHECK_CAST: {
                    TypeExpr te = (TypeExpr)e1;
                    this.provideAs(te, te.type);
                    this.useAs(v, "L");
                    break;
                }
                case INSTANCE_OF: {
                    TypeExpr te = (TypeExpr)e1;
                    this.provideAs(te, "Z");
                    this.useAs(v, "L");
                    break;
                }
                case NEW_ARRAY: {
                    TypeExpr te = (TypeExpr)e1;
                    this.provideAs(te, "[" + te.type);
                    this.useAs(v, "I");
                    break;
                }
                case LENGTH: {
                    UnopExpr ue = (UnopExpr)e1;
                    this.provideAs(ue, "I");
                    this.useAs(v, "[?");
                    break;
                }
                case NEG: 
                case NOT: {
                    UnopExpr ue = (UnopExpr)e1;
                    this.provideAs(ue, ue.type);
                    this.useAs(v, ue.type);
                }
            }
            if (v != null) {
                this.exExpr(v);
            }
        }

        private void e2expr(Value.E2Expr e2, boolean getValue) {
            Value a = e2.op1.trim();
            Value b = e2.op2.trim();
            switch (e2.vt) {
                case ARRAY: {
                    this.useAs(b, "I");
                    String elementType = ((ArrayExpr)e2).elementType;
                    this.useAs(a, "[" + elementType);
                    if (getValue) {
                        this.provideAs(e2, elementType);
                        this.linkGetArray(a, e2);
                        break;
                    }
                    this.useAs(e2, elementType);
                    this.linkSetArray(a, e2);
                    break;
                }
                case DCMPG: 
                case DCMPL: 
                case FCMPG: 
                case FCMPL: 
                case LCMP: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                    this.provideAs(e2, "I");
                    break;
                }
                case EQ: 
                case NE: {
                    this.useAs(e2.getOp2(), TypeClass.ZIL.name);
                    this.useAs(e2.getOp1(), TypeClass.ZIL.name);
                    this.linkSameAs(e2.getOp1(), e2.getOp2());
                    this.provideAs(e2, "Z");
                    break;
                }
                case GE: 
                case GT: 
                case LE: 
                case LT: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                    this.provideAs(e2, "Z");
                    break;
                }
                case ADD: 
                case DIV: 
                case MUL: 
                case REM: 
                case SUB: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                    this.provideAs(e2, be.type);
                    break;
                }
                case AND: 
                case OR: 
                case XOR: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, be.type);
                    if ("J".equals(be.type) || "w".equals(be.type)) {
                        this.provideAs(e2, be.type);
                        break;
                    }
                    this.provideAs(e2, TypeClass.ZI.name);
                    break;
                }
                case SHL: 
                case SHR: 
                case USHR: {
                    BinopExpr be = (BinopExpr)e2;
                    this.useAs(a, be.type);
                    this.useAs(b, "I");
                    this.provideAs(e2, be.type);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (a != null) {
                this.exExpr(a);
            }
            if (b != null) {
                this.exExpr(b);
            }
        }

        private void linkSameAs(Value a, Value b) {
            TypeRef aa = this.getDefTypeRef(a);
            TypeRef bb = this.getDefTypeRef(b);
            if (aa.sameValues == null) {
                aa.sameValues = new HashSet<TypeRef>(3);
            }
            if (bb.sameValues == null) {
                bb.sameValues = new HashSet<TypeRef>(3);
            }
            aa.sameValues.add(bb);
            bb.sameValues.add(aa);
        }

        private void enexpr(Value.EnExpr enExpr) {
            Value[] vbs = enExpr.ops;
            switch (enExpr.vt) {
                case INVOKE_INTERFACE: 
                case INVOKE_NEW: 
                case INVOKE_SPECIAL: 
                case INVOKE_STATIC: 
                case INVOKE_VIRTUAL: {
                    InvokeExpr ie = (InvokeExpr)enExpr;
                    String type = ie.vt == Value.VT.INVOKE_NEW ? ie.owner : ie.ret;
                    this.provideAs(enExpr, type);
                    this.useAs(enExpr, type);
                    int start = 0;
                    if (ie.vt != Value.VT.INVOKE_STATIC && ie.vt != Value.VT.INVOKE_NEW) {
                        start = 1;
                        this.useAs(vbs[0], ie.owner);
                    }
                    int i = 0;
                    while (start < vbs.length) {
                        this.useAs(vbs[start], ie.args[i]);
                        ++start;
                        ++i;
                    }
                    break;
                }
                case FILLED_ARRAY: {
                    FilledArrayExpr fae = (FilledArrayExpr)enExpr;
                    Value[] valueArray = vbs;
                    int n = vbs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Value vb = valueArray[n2];
                        this.useAs(vb, fae.type);
                        ++n2;
                    }
                    this.provideAs(fae, "[" + fae.type);
                    break;
                }
                case NEW_MUTI_ARRAY: {
                    NewMutiArrayExpr nmae = (NewMutiArrayExpr)enExpr;
                    Value[] valueArray = vbs;
                    int n = vbs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Value vb = valueArray[n3];
                        this.useAs(vb, "I");
                        ++n3;
                    }
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < nmae.dimension) {
                        sb.append('[');
                        ++i;
                    }
                    sb.append(nmae.baseType);
                    this.provideAs(nmae, sb.toString());
                    break;
                }
                case PHI: {
                    Value[] valueArray = vbs;
                    int n = vbs.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Value vb = valueArray[n4];
                        this.linkFromTo(vb, enExpr);
                        ++n4;
                    }
                    break;
                }
            }
            Value[] valueArray = enExpr.ops;
            int n = enExpr.ops.length;
            int n5 = 0;
            while (n5 < n) {
                Value vb = valueArray[n5];
                this.exExpr(vb);
                ++n5;
            }
        }

        private void exExpr(Value op) {
            this.exExpr(op, true);
        }

        private void exExpr(Value op, boolean getValue) {
            switch (op.et) {
                case E0: {
                    this.e0expr((Value.E0Expr)op, getValue);
                    break;
                }
                case E1: {
                    this.e1expr((Value.E1Expr)op, getValue);
                    break;
                }
                case E2: {
                    this.e2expr((Value.E2Expr)op, getValue);
                    break;
                }
                case En: {
                    this.enexpr((Value.EnExpr)op);
                }
            }
        }

        private TypeRef getDefTypeRef(Value v) {
            TypeRef typeRef;
            Object object = v.tag;
            if (object == null || !(object instanceof TypeRef)) {
                typeRef = new TypeRef(v);
                this.refs.add(typeRef);
                v.tag = typeRef;
            } else {
                typeRef = (TypeRef)object;
            }
            return typeRef;
        }

        private void linkGetArray(Value array, Value v) {
            TypeRef root = this.getDefTypeRef(array);
            TypeRef value = this.getDefTypeRef(v);
            if (root.gArrayValues == null) {
                root.gArrayValues = new HashSet<TypeRef>(3);
            }
            root.gArrayValues.add(value);
        }

        private void linkSetArray(Value array, Value v) {
            TypeRef root = this.getDefTypeRef(array);
            TypeRef value = this.getDefTypeRef(v);
            if (root.sArrayValues == null) {
                root.sArrayValues = new HashSet<TypeRef>(3);
            }
            root.sArrayValues.add(value);
        }

        private void linkFromTo(Value from, Value to) {
            TypeRef tFrom = this.getDefTypeRef(from);
            TypeRef tTo = this.getDefTypeRef(to);
            if (tFrom.children == null) {
                tFrom.children = new HashSet<TypeRef>();
            }
            tFrom.children.add(tTo);
            if (tTo.parents == null) {
                tTo.parents = new HashSet<TypeRef>();
            }
            tTo.parents.add(tFrom);
        }

        private void provideAs(Value op, String type) {
            TypeRef typeRef = this.getDefTypeRef(op);
            typeRef.provideDesc = type;
            typeRef.updateTypeClass(TypeClass.clzOf(type));
        }

        private void s1stmt(Stmt.E1Stmt s) {
            if (s.st == Stmt.ST.GOTO) {
                return;
            }
            Value op = s.op;
            switch (s.st) {
                case LOOKUP_SWITCH: 
                case TABLE_SWITCH: {
                    this.useAs(op, "I");
                    break;
                }
                case GOTO: {
                    break;
                }
                case IF: {
                    this.useAs(op, "Z");
                    break;
                }
                case LOCK: 
                case UNLOCK: {
                    this.useAs(op, "L");
                    break;
                }
                case THROW: {
                    this.useAs(op, "Ljava/lang/Throwable;");
                    break;
                }
                case RETURN: {
                    this.useAs(op, this.method.ret);
                }
            }
            this.exExpr(op);
        }

        private void s2stmt(Stmt.E2Stmt s) {
            if (s.st == Stmt.ST.FILL_ARRAY_DATA) {
                this.linkFromTo(s.op1, s.op2);
            } else {
                Value from = s.op2;
                Value to = s.op1;
                this.linkFromTo(from, to);
                this.exExpr(from);
                this.exExpr(to, false);
            }
        }

        private void sxStmt() {
            Stmt p = this.method.stmts.getFirst();
            while (p != null) {
                switch (p.et) {
                    case E0: {
                        if (p.st != Stmt.ST.LABEL) break;
                        LabelStmt labelStmt = (LabelStmt)p;
                        if (labelStmt.phis == null) break;
                        for (AssignStmt phi : labelStmt.phis) {
                            this.s2stmt(phi);
                        }
                        break;
                    }
                    case E1: {
                        this.s1stmt((Stmt.E1Stmt)p);
                        break;
                    }
                    case E2: {
                        this.s2stmt((Stmt.E2Stmt)p);
                        break;
                    }
                }
                p = p.getNext();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (TypeRef ref : this.refs) {
                sb.append(ref).append("\n");
            }
            return sb.toString();
        }

        private void useAs(Value op, String type) {
            TypeRef typeRef = this.getDefTypeRef(op);
            if (typeRef.uses == null) {
                typeRef.uses = new HashSet<String>();
            }
            typeRef.uses.add(type);
            typeRef.updateTypeClass(TypeClass.clzOf(type));
        }
    }

    public static class TypeRef {
        public final Value value;
        public TypeClass clz = TypeClass.UNKNOWN;
        public Set<TypeRef> sameValues = null;
        public Set<TypeRef> gArrayValues = null;
        public Set<TypeRef> sArrayValues = null;
        public Set<TypeRef> parents = null;
        public String provideDesc = null;
        public Set<TypeRef> children = null;
        public Set<String> uses;

        public TypeRef(Value value) {
            this.value = value;
        }

        public String toString() {
            String p = this.uses == null ? "[]" : this.uses.toString();
            return (Object)((Object)this.clz) + "::" + this.value + ": " + this.provideDesc + " > {" + p.substring(1, p.length() - 1) + "}";
        }

        public String getType() {
            if (this.clz == TypeClass.OBJECT) {
                if (this.provideDesc.length() == 1) {
                    return "Ljava/lang/Object;";
                }
                return this.provideDesc;
            }
            if (this.clz.fixed && this.clz != TypeClass.INT) {
                if (this.provideDesc == null) {
                    throw new RuntimeException();
                }
                return this.provideDesc;
            }
            if (this.clz == TypeClass.JD) {
                return "J";
            }
            if (this.uses != null) {
                String[] stringArray = possibleIntTypes;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    if (this.uses.contains(t)) {
                        return t;
                    }
                    ++n2;
                }
            }
            switch (this.clz) {
                case ZI: {
                    return "I";
                }
                case ZIL: 
                case ZIFL: 
                case ZIF: {
                    return "Z";
                }
                case INT: 
                case IF: {
                    return "I";
                }
            }
            throw new RuntimeException();
        }

        public boolean updateTypeClass(TypeClass clz) {
            TypeClass merged = TypeClass.merge(this.clz, clz);
            if (merged == this.clz) {
                return false;
            }
            this.clz = merged;
            return true;
        }

        public void clear() {
            this.sArrayValues = null;
            this.gArrayValues = null;
            this.parents = null;
            this.children = null;
            this.provideDesc = null;
            this.children = null;
            this.sameValues = null;
            this.uses = null;
        }
    }
}

