/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import net.sf.saxon.number.AbstractNumberer;

public class Numberer_de
extends AbstractNumberer {
    private static String[] germanUnits = new String[]{"", "Eins", "Zwei", "Drei", "Vier", "F\u00fcnf", "Sechs", "Sieben", "Acht", "Neun", "Zehn", "Elf", "Zw\u00f6lf", "Dreizehn", "Vierzehn", "F\u00fcnfzehn", "Sechszehn", "Siebzehn", "Achtzehn", "Neunzehn"};
    private static String[] germanTens = new String[]{"", "Zehn", "Zwanzig", "Drei\u00dfig", "Vierzig", "F\u00fcnfzig", "Sechzig", "Siebzig", "Achtzig", "Neunzig"};
    private static String[] germanOrdinalUnits = new String[]{"", "Erst", "Zweit", "Dritt", "Viert", "F\u00fcnft", "Sechst", "Siebt", "Acht", "Neunt", "Zehnt", "Elft", "Zw\u00f6lft", "Dreizehnt", "Vierzehnt", "F\u00fcnfzehnt", "Sechszehnt", "Siebzehnt", "Achtzehnt", "Neunzehnt"};
    private static String[] germanMonths = new String[]{"Januar", "Februar", "M\u00e4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"};
    private static String[] germanDays = new String[]{"Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag", "Sonntag"};

    protected String ordinalSuffix(String ordinalParam, long number) {
        return ".";
    }

    public String toWords(long number) {
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            long n = number / 1000000000L;
            String s = n == 1L ? "Eine" : this.toWords(n);
            return s + " Milliarde" + (rem == 0L ? "" : ' ' + this.toWords(rem));
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            long n = number / 1000000L;
            String s = n == 1L ? "Eine" : this.toWords(n);
            return s + " Million" + (rem == 0L ? "" : ' ' + this.toWords(rem));
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            long n = number / 1000L;
            String s = n == 1L ? "Ein" : this.toWords(n);
            return s + "tausend" + (rem == 0L ? "" : ' ' + this.toWords(rem));
        }
        if (number >= 100L) {
            long rem = number % 100L;
            long n = number / 100L;
            String s = n == 1L ? "Ein" : this.toWords(n);
            return s + "hundert" + (rem == 0L ? "" : (rem > 20L ? "" : "und") + this.toWords(rem, 1));
        }
        if (number < 20L) {
            return germanUnits[(int)number];
        }
        int rem = (int)(number % 10L);
        int tens = (int)number / 10;
        return germanUnits[rem] + (tens == 0 ? "" : (rem == 0 ? "" : "und") + germanTens[tens]);
    }

    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String suffix = "e";
        if (ordinalParam.equalsIgnoreCase("-er")) {
            suffix = "er";
        } else if (ordinalParam.equalsIgnoreCase("-es")) {
            suffix = "es";
        } else if (ordinalParam.equalsIgnoreCase("-en")) {
            suffix = "en";
        }
        long mod100 = number % 100L;
        if (number < 20L) {
            String ord = germanOrdinalUnits[(int)number] + suffix;
            if (wordCase == 0) {
                return ord.toUpperCase();
            }
            if (wordCase == 1) {
                return ord.toLowerCase();
            }
            return ord;
        }
        if (mod100 < 20L && mod100 > 0L) {
            return this.toWords(number - mod100, wordCase) + this.toOrdinalWords(ordinalParam, mod100, wordCase == 2 ? 1 : wordCase);
        }
        String ending = "st" + suffix;
        if (wordCase == 0) {
            ending = ending.toUpperCase();
        }
        return this.toWords(number, wordCase) + (wordCase == 0 ? ending.toUpperCase() : ending);
    }

    public String monthName(int month, int minWidth, int maxWidth) {
        String name = germanMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + " ";
        }
        return name;
    }

    public String dayName(int day, int minWidth, int maxWidth) {
        String name = germanDays[day - 1];
        if (maxWidth < 10) {
            name = name.substring(0, 2);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        return name;
    }

    public String getOrdinalSuffixForDateTime(String component) {
        return "-e";
    }

    public String getEraName(int year) {
        return year <= 0 ? "v. Chr." : "n. Chr.";
    }

    public String getCalendarName(String code) {
        if (code.equals("AD")) {
            return "Gregorianisch";
        }
        return code;
    }
}

