"use strict";

require("jest-canvas-mock");

require("@testing-library/jest-dom/extend-expect");

var _react = require("@testing-library/react");

var _enzyme = _interopRequireDefault(require("enzyme"));

var _enzymeAdapterReact = _interopRequireDefault(require("enzyme-adapter-react-16"));

var _useContext = require("./mocks/useContext.mock");

var _DataStore = require("../public/store/DataStore");

var _services = _interopRequireDefault(require("./mocks/services"));

var _NotificationsStart = _interopRequireDefault(require("./mocks/services/notifications/NotificationsStart.mock"));

var _stringPrototype = _interopRequireDefault(require("string.prototype.replaceall"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// @ts-ignore
_stringPrototype.default.shim();

_enzyme.default.configure({
  adapter: new _enzymeAdapterReact.default()
});

(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/eui_components/form/form_row/make_id', () => () => 'some_make_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'some_html_id';
  }
})); // @ts-ignore

window.Worker = function () {
  this.postMessage = () => {}; // @ts-ignore


  this.terminate = () => {};
}; // @ts-ignore


window.URL = {
  createObjectURL: () => {
    return '';
  }
}; // https://github.com/elastic/eui/issues/2530

jest.mock('@elastic/eui/lib/eui_components/icon', () => ({
  EuiIcon: () => 'EuiIconMock',
  __esModule: true,
  IconPropType: require('@elastic/eui/lib/eui_components/icon/icon').IconPropType,
  ICON_TYPES: require('@elastic/eui/lib/eui_components/icon/icon').TYPES,
  ICON_SIZES: require('@elastic/eui/lib/eui_components/icon/icon').SIZES,
  ICON_COLORS: require('@elastic/eui/lib/eui_components/icon/icon').COLORS
}));
/**
 * Moment timezones are not working from jest so here we mock
 * moment.tz.names function
 *
 * Also, format function is mocked to return always the same value so that we can correctly test
 * functions that call this
 */

jest.mock('moment', () => {
  const moment = jest.requireActual('moment'); // Set moment tz mock

  if (!moment.tz) moment.tz = {};

  moment.tz.names = () => ['Pacific/Tahiti'];

  const momentInstance = moment();
  momentInstance.format = jest.fn().mockReturnValue('2023-01-25T10:05');

  function fakeMoment() {
    return momentInstance;
  }

  Object.assign(fakeMoment, moment);
  return fakeMoment;
});
/**
 * React useContext is mocked to return the mocked services
 * so that this works in all tests
 */

jest.mock('react', () => {
  const ActualReact = jest.requireActual('react');
  return { ...ActualReact,
    useContext: () => _useContext.contextServicesMock
  };
});
/**
 * Mocks the vega view renderer
 */

jest.mock('vega/build-es5/vega.js', () => {
  const vega = jest.requireActual('vega/build-es5/vega.js');
  return { ...vega,
    View: jest.fn().mockReturnValue({
      tooltip: jest.fn(),
      runAsync: jest.fn().mockReturnValue(new Promise(jest.fn()))
    })
  };
});

_DataStore.DataStore.init(_services.default, _NotificationsStart.default);

jest.setTimeout(10000); // in milliseconds
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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