"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '^ui/(.*)': '<rootDir>/../../src/legacy/ui/public/$1/'
  },
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.ts', '!<rootDir>/index.js', '!<rootDir>/public/app.js', '!<rootDir>/public/temporary/**', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!<rootDir>/cypress/**', '!**/vendor/**'],
  clearMocks: true,
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  modulePathIgnorePatterns: ['securityAnalyticsDashboards'],
  testEnvironment: 'jsdom',
  snapshotSerializers: ['enzyme-to-json/serializer']
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImplc3QuY29uZmlnLmpzIl0sIm5hbWVzIjpbIm1vZHVsZSIsImV4cG9ydHMiLCJyb290RGlyIiwic2V0dXBGaWxlcyIsInNldHVwRmlsZXNBZnRlckVudiIsInJvb3RzIiwiY292ZXJhZ2VEaXJlY3RvcnkiLCJtb2R1bGVOYW1lTWFwcGVyIiwiY292ZXJhZ2VSZXBvcnRlcnMiLCJ0ZXN0TWF0Y2giLCJjb2xsZWN0Q292ZXJhZ2VGcm9tIiwiY2xlYXJNb2NrcyIsInRlc3RQYXRoSWdub3JlUGF0dGVybnMiLCJtb2R1bGVQYXRoSWdub3JlUGF0dGVybnMiLCJ0ZXN0RW52aXJvbm1lbnQiLCJzbmFwc2hvdFNlcmlhbGl6ZXJzIl0sIm1hcHBpbmdzIjoiOztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBRUFBLE1BQU0sQ0FBQ0MsT0FBUCxHQUFpQjtBQUNmQyxFQUFBQSxPQUFPLEVBQUUsS0FETTtBQUVmQyxFQUFBQSxVQUFVLEVBQUUsQ0FBQyw2QkFBRCxFQUFnQyw4QkFBaEMsQ0FGRztBQUdmQyxFQUFBQSxrQkFBa0IsRUFBRSxDQUFDLDhCQUFELENBSEw7QUFJZkMsRUFBQUEsS0FBSyxFQUFFLENBQUMsV0FBRCxDQUpRO0FBS2ZDLEVBQUFBLGlCQUFpQixFQUFFLFlBTEo7QUFNZkMsRUFBQUEsZ0JBQWdCLEVBQUU7QUFDaEIsMkJBQXVCLG1DQURQO0FBRWhCLGdCQUFZO0FBRkksR0FOSDtBQVVmQyxFQUFBQSxpQkFBaUIsRUFBRSxDQUFDLE1BQUQsRUFBUyxNQUFULEVBQWlCLFdBQWpCLENBVko7QUFXZkMsRUFBQUEsU0FBUyxFQUFFLENBQUMsY0FBRCxFQUFpQixlQUFqQixFQUFrQyxjQUFsQyxFQUFrRCxlQUFsRCxDQVhJO0FBWWZDLEVBQUFBLG1CQUFtQixFQUFFLENBQ25CLFNBRG1CLEVBRW5CLFVBRm1CLEVBR25CLFNBSG1CLEVBSW5CLFVBSm1CLEVBS25CLGVBTG1CLEVBTW5CLHFCQU5tQixFQU9uQixjQVBtQixFQVFuQixxQkFSbUIsRUFTbkIsMEJBVG1CLEVBVW5CLGdDQVZtQixFQVduQiw0QkFYbUIsRUFZbkIsb0JBWm1CLEVBYW5CLHNCQWJtQixFQWNuQix3QkFkbUIsRUFlbkIsdUJBZm1CLEVBZ0JuQixxQkFoQm1CLEVBaUJuQix1QkFqQm1CLEVBa0JuQixlQWxCbUIsQ0FaTjtBQWdDZkMsRUFBQUEsVUFBVSxFQUFFLElBaENHO0FBaUNmQyxFQUFBQSxzQkFBc0IsRUFBRSxDQUFDLGtCQUFELEVBQXFCLHlCQUFyQixDQWpDVDtBQWtDZkMsRUFBQUEsd0JBQXdCLEVBQUUsQ0FBQyw2QkFBRCxDQWxDWDtBQW1DZkMsRUFBQUEsZUFBZSxFQUFFLE9BbkNGO0FBb0NmQyxFQUFBQSxtQkFBbUIsRUFBRSxDQUFDLDJCQUFEO0FBcENOLENBQWpCIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5tb2R1bGUuZXhwb3J0cyA9IHtcbiAgcm9vdERpcjogJy4uLycsXG4gIHNldHVwRmlsZXM6IFsnPHJvb3REaXI+L3Rlc3QvcG9seWZpbGxzLnRzJywgJzxyb290RGlyPi90ZXN0L3NldHVwVGVzdHMudHMnXSxcbiAgc2V0dXBGaWxlc0FmdGVyRW52OiBbJzxyb290RGlyPi90ZXN0L3NldHVwLmplc3QudHMnXSxcbiAgcm9vdHM6IFsnPHJvb3REaXI+J10sXG4gIGNvdmVyYWdlRGlyZWN0b3J5OiAnLi9jb3ZlcmFnZScsXG4gIG1vZHVsZU5hbWVNYXBwZXI6IHtcbiAgICAnXFxcXC4oY3NzfGxlc3N8c2NzcykkJzogJzxyb290RGlyPi90ZXN0L21vY2tzL3N0eWxlTW9jay50cycsXG4gICAgJ151aS8oLiopJzogJzxyb290RGlyPi8uLi8uLi9zcmMvbGVnYWN5L3VpL3B1YmxpYy8kMS8nLFxuICB9LFxuICBjb3ZlcmFnZVJlcG9ydGVyczogWydsY292JywgJ3RleHQnLCAnY29iZXJ0dXJhJ10sXG4gIHRlc3RNYXRjaDogWycqKi8qLnRlc3QuanMnLCAnKiovKi50ZXN0LmpzeCcsICcqKi8qLnRlc3QudHMnLCAnKiovKi50ZXN0LnRzeCddLFxuICBjb2xsZWN0Q292ZXJhZ2VGcm9tOiBbXG4gICAgJyoqLyoudHMnLFxuICAgICcqKi8qLnRzeCcsXG4gICAgJyoqLyouanMnLFxuICAgICcqKi8qLmpzeCcsXG4gICAgJyEqKi9tb2RlbHMvKionLFxuICAgICchKiovbm9kZV9tb2R1bGVzLyoqJyxcbiAgICAnISoqL2luZGV4LnRzJyxcbiAgICAnITxyb290RGlyPi9pbmRleC5qcycsXG4gICAgJyE8cm9vdERpcj4vcHVibGljL2FwcC5qcycsXG4gICAgJyE8cm9vdERpcj4vcHVibGljL3RlbXBvcmFyeS8qKicsXG4gICAgJyE8cm9vdERpcj4vYmFiZWwuY29uZmlnLmpzJyxcbiAgICAnITxyb290RGlyPi90ZXN0LyoqJyxcbiAgICAnITxyb290RGlyPi9zZXJ2ZXIvKionLFxuICAgICchPHJvb3REaXI+L2NvdmVyYWdlLyoqJyxcbiAgICAnITxyb290RGlyPi9zY3JpcHRzLyoqJyxcbiAgICAnITxyb290RGlyPi9idWlsZC8qKicsXG4gICAgJyE8cm9vdERpcj4vY3lwcmVzcy8qKicsXG4gICAgJyEqKi92ZW5kb3IvKionLFxuICBdLFxuICBjbGVhck1vY2tzOiB0cnVlLFxuICB0ZXN0UGF0aElnbm9yZVBhdHRlcm5zOiBbJzxyb290RGlyPi9idWlsZC8nLCAnPHJvb3REaXI+L25vZGVfbW9kdWxlcy8nXSxcbiAgbW9kdWxlUGF0aElnbm9yZVBhdHRlcm5zOiBbJ3NlY3VyaXR5QW5hbHl0aWNzRGFzaGJvYXJkcyddLFxuICB0ZXN0RW52aXJvbm1lbnQ6ICdqc2RvbScsXG4gIHNuYXBzaG90U2VyaWFsaXplcnM6IFsnZW56eW1lLXRvLWpzb24vc2VyaWFsaXplciddLFxufTtcbiJdfQ==