"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupCorrelationRoutes = setupCorrelationRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupCorrelationRoutes(services, router) {
  const {
    correlationService
  } = services;
  router.post({
    path: `${_constants.API.CORRELATION_BASE}/_search`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, correlationService.getCorrelationRules);
  router.post({
    path: `${_constants.API.CORRELATION_BASE}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, correlationService.createCorrelationRule);
  router.put({
    path: `${_constants.API.CORRELATION_BASE}/{ruleId}`,
    validate: {
      body: _configSchema.schema.any(),
      params: _configSchema.schema.object({
        ruleId: _configSchema.schema.string()
      })
    }
  }, correlationService.updateCorrelationRule);
  router.get({
    path: `${_constants.API.FINDINGS_BASE}/correlate`,
    validate: {
      query: _configSchema.schema.object({
        finding: _configSchema.schema.string(),
        detector_type: _configSchema.schema.string(),
        nearby_findings: _configSchema.schema.number()
      })
    }
  }, correlationService.getCorrelatedFindings);
  router.get({
    path: `${_constants.API.CORRELATIONS}`,
    validate: {
      query: _configSchema.schema.object({
        start_time: _configSchema.schema.string(),
        end_time: _configSchema.schema.string()
      })
    }
  }, correlationService.getAllCorrelationsInTimeRange);
  router.delete({
    path: `${_constants.API.CORRELATION_BASE}/{ruleId}`,
    validate: {
      params: _configSchema.schema.object({
        ruleId: _configSchema.schema.string()
      })
    }
  }, correlationService.deleteCorrelationRule);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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