/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.ScheduledAction;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.internal.AbstractStats;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.ExtendedAppendable;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.DiscoInfoLookupShortcutMechanism;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.ExpirationCache;

public final class ServiceDiscoveryManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ServiceDiscoveryManager.class.getName());
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static final List<DiscoInfoLookupShortcutMechanism> discoInfoLookupShortcutMechanisms = new ArrayList<DiscoInfoLookupShortcutMechanism>(2);
    private static DiscoverInfo.Identity defaultIdentity = new DiscoverInfo.Identity("client", "Smack", "pc");
    private final Set<DiscoverInfo.Identity> identities = new HashSet<DiscoverInfo.Identity>();
    private DiscoverInfo.Identity identity = defaultIdentity;
    private final Set<EntityCapabilitiesChangedListener> entityCapabilitiesChangedListeners = new CopyOnWriteArraySet<EntityCapabilitiesChangedListener>();
    private static final Map<XMPPConnection, ServiceDiscoveryManager> instances = new WeakHashMap<XMPPConnection, ServiceDiscoveryManager>();
    private final Set<String> features = new HashSet<String>();
    private List<DataForm> extendedInfos = new ArrayList<DataForm>(2);
    private final Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();
    private volatile Presence presenceSend;
    private final Cache<String, List<DiscoverInfo>> services = new ExpirationCache<String, List<DiscoverInfo>>(25, 86400000L);
    private static final int RENEW_ENTITY_CAPS_DELAY_MILLIS = 25;
    private ScheduledAction renewEntityCapsScheduledAction;
    private final AtomicInteger renewEntityCapsPerformed = new AtomicInteger();
    private int renewEntityCapsRequested = 0;
    private int scheduledRenewEntityCapsAvoided = 0;

    public static void setDefaultIdentity(DiscoverInfo.Identity identity) {
        defaultIdentity = identity;
    }

    private ServiceDiscoveryManager(XMPPConnection connection) {
        super(connection);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        connection.registerIQRequestHandler(new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#items", IQ.Type.get, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIQRequest(IQ iqRequest) {
                DiscoverItems discoverItems = (DiscoverItems)iqRequest;
                DiscoverItems response = new DiscoverItems();
                response.setType(IQ.Type.result);
                response.setTo(discoverItems.getFrom());
                response.setStanzaId(discoverItems.getStanzaId());
                response.setNode(discoverItems.getNode());
                NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                if (nodeInformationProvider != null) {
                    response.addItems(nodeInformationProvider.getNodeItems());
                    response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                } else if (discoverItems.getNode() != null) {
                    response.setType(IQ.Type.error);
                    response.setError(StanzaError.getBuilder(StanzaError.Condition.item_not_found).build());
                }
                return response;
            }
        });
        connection.registerIQRequestHandler(new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#info", IQ.Type.get, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIQRequest(IQ iqRequest) {
                DiscoverInfo discoverInfo = (DiscoverInfo)iqRequest;
                DiscoverInfoBuilder responseBuilder = DiscoverInfoBuilder.buildResponseFor(discoverInfo, IQ.ResponseType.result);
                if (discoverInfo.getNode() == null) {
                    ServiceDiscoveryManager.this.addDiscoverInfoTo(responseBuilder);
                } else {
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                    if (nodeInformationProvider != null) {
                        responseBuilder.addFeatures(nodeInformationProvider.getNodeFeatures());
                        responseBuilder.addIdentities(nodeInformationProvider.getNodeIdentities());
                        responseBuilder.addOptExtensions(nodeInformationProvider.getNodePacketExtensions());
                    } else {
                        responseBuilder.ofType(IQ.Type.error);
                        responseBuilder.setError(StanzaError.getBuilder(StanzaError.Condition.item_not_found).build());
                    }
                }
                DiscoverInfo response = responseBuilder.build();
                return response;
            }
        });
        connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (!resumed) {
                    ServiceDiscoveryManager.this.presenceSend = null;
                }
            }
        });
        connection.addStanzaSendingListener(p -> {
            this.presenceSend = (Presence)p;
        }, PresenceTypeFilter.OUTGOING_PRESENCE_BROADCAST);
    }

    public String getIdentityName() {
        return this.identity.getName();
    }

    public synchronized void setIdentity(DiscoverInfo.Identity identity) {
        this.identity = Objects.requireNonNull(identity, "Identity can not be null");
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo.Identity getIdentity() {
        return this.identity;
    }

    public String getIdentityType() {
        return this.identity.getType();
    }

    public synchronized void addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        this.renewEntityCapsVersion();
    }

    public synchronized boolean removeIdentity(DiscoverInfo.Identity identity) {
        if (identity.equals(this.identity)) {
            return false;
        }
        this.identities.remove(identity);
        this.renewEntityCapsVersion();
        return true;
    }

    public Set<DiscoverInfo.Identity> getIdentities() {
        HashSet<DiscoverInfo.Identity> res = new HashSet<DiscoverInfo.Identity>(this.identities);
        res.add(this.identity);
        return Collections.unmodifiableSet(res);
    }

    public static synchronized ServiceDiscoveryManager getInstanceFor(XMPPConnection connection) {
        ServiceDiscoveryManager sdm = instances.get(connection);
        if (sdm == null) {
            sdm = new ServiceDiscoveryManager(connection);
            instances.put(connection, sdm);
        }
        return sdm;
    }

    public synchronized void addDiscoverInfoTo(DiscoverInfoBuilder response) {
        response.addIdentities(this.getIdentities());
        for (String feature : this.getFeatures()) {
            response.addFeature(feature);
        }
        response.addExtensions(this.extendedInfos);
    }

    private NodeInformationProvider getNodeInformationProvider(String node) {
        if (node == null) {
            return null;
        }
        return this.nodeInformationProviders.get(node);
    }

    public void setNodeInformationProvider(String node, NodeInformationProvider listener) {
        this.nodeInformationProviders.put(node, listener);
    }

    public void removeNodeInformationProvider(String node) {
        this.nodeInformationProviders.remove(node);
    }

    public synchronized List<String> getFeatures() {
        return new ArrayList<String>(this.features);
    }

    public synchronized void addFeature(String feature) {
        this.features.add(feature);
        this.renewEntityCapsVersion();
    }

    public synchronized void removeFeature(String feature) {
        this.features.remove(feature);
        this.renewEntityCapsVersion();
    }

    public synchronized boolean includesFeature(String feature) {
        return this.features.contains(feature);
    }

    @Deprecated
    public synchronized void setExtendedInfo(DataForm info) {
        this.addExtendedInfo(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataForm addExtendedInfo(DataForm extendedInfo) {
        DataForm removedDataForm;
        String formType = extendedInfo.getFormType();
        StringUtils.requireNotNullNorEmpty(formType, "The data form must have a form type set");
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            removedDataForm = DataForm.remove(this.extendedInfos, formType);
            this.extendedInfos.add(extendedInfo);
            this.renewEntityCapsVersion();
        }
        return removedDataForm;
    }

    public synchronized void removeExtendedInfo(String formType) {
        DataForm removedForm = DataForm.remove(this.extendedInfos, formType);
        if (removedForm != null) {
            this.renewEntityCapsVersion();
        }
    }

    public synchronized List<DataForm> getExtendedInfo() {
        return CollectionUtil.newListWith(this.extendedInfos);
    }

    @Deprecated
    public List<DataForm> getExtendedInfoAsList() {
        return this.getExtendedInfo();
    }

    public synchronized void removeExtendedInfo() {
        int extendedInfosCount = this.extendedInfos.size();
        this.extendedInfos.clear();
        if (extendedInfosCount > 0) {
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoverInfo discoverInfo(Jid entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (entityID == null) {
            return this.discoverInfo(null, null);
        }
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            for (DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism : discoInfoLookupShortcutMechanisms) {
                DiscoverInfo info = discoInfoLookupShortcutMechanism.getDiscoverInfoByUser(this, entityID);
                if (info == null) continue;
                return info;
            }
        }
        return this.discoverInfo(entityID, null);
    }

    public DiscoverInfo discoverInfo(Jid entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        DiscoverInfo discoInfoRequest = ((DiscoverInfoBuilder)DiscoverInfo.builder(connection).to(entityID)).setNode(node).build();
        Object result2 = connection.createStanzaCollectorAndSend(discoInfoRequest).nextResultOrThrow();
        return (DiscoverInfo)result2;
    }

    public DiscoverItems discoverItems(Jid entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.discoverItems(entityID, null);
    }

    public DiscoverItems discoverItems(Jid entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems disco = new DiscoverItems();
        disco.setType(IQ.Type.get);
        disco.setTo(entityID);
        disco.setNode(node);
        Object result2 = this.connection().createStanzaCollectorAndSend(disco).nextResultOrThrow();
        return (DiscoverItems)result2;
    }

    public boolean serverSupportsFeature(CharSequence feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serverSupportsFeatures(feature);
    }

    public boolean serverSupportsFeatures(CharSequence ... features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serverSupportsFeatures(Arrays.asList(features));
    }

    public boolean serverSupportsFeatures(Collection<? extends CharSequence> features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures((Jid)this.connection().getXMPPServiceDomain(), features);
    }

    public boolean accountSupportsFeatures(CharSequence ... features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.accountSupportsFeatures(Arrays.asList(features));
    }

    public boolean accountSupportsFeatures(Collection<? extends CharSequence> features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        EntityBareJid accountJid = this.connection().getUser().asEntityBareJid();
        return this.supportsFeatures((Jid)accountJid, features);
    }

    public boolean supportsFeature(Jid jid, CharSequence feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures(jid, feature);
    }

    public boolean supportsFeatures(Jid jid, CharSequence ... features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures(jid, Arrays.asList(features));
    }

    public boolean supportsFeatures(Jid jid, Collection<? extends CharSequence> features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo result2 = this.discoverInfo(jid);
        for (CharSequence charSequence : features) {
            if (result2.containsFeature(charSequence)) continue;
            return false;
        }
        return true;
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(String feature, boolean stopOnFirst, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.findServicesDiscoverInfo(feature, stopOnFirst, useCache, null);
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(String feature, boolean stopOnFirst, boolean useCache, Map<? super Jid, Exception> encounteredExceptions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DomainBareJid serviceName = this.connection().getXMPPServiceDomain();
        return this.findServicesDiscoverInfo(serviceName, feature, stopOnFirst, useCache, encounteredExceptions);
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(DomainBareJid serviceName, String feature, boolean stopOnFirst, boolean useCache, Map<? super Jid, Exception> encounteredExceptions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems items;
        DiscoverInfo info;
        LinkedList<DiscoverInfo> serviceDiscoInfo;
        if (useCache && (serviceDiscoInfo = this.services.lookup(feature)) != null) {
            return serviceDiscoInfo;
        }
        serviceDiscoInfo = new LinkedList();
        try {
            info = this.discoverInfo(serviceName);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (encounteredExceptions != null) {
                encounteredExceptions.put(serviceName, e);
            }
            return serviceDiscoInfo;
        }
        if (info.containsFeature(feature)) {
            serviceDiscoInfo.add(info);
            if (stopOnFirst) {
                if (useCache) {
                    this.services.put(feature, serviceDiscoInfo);
                }
                return serviceDiscoInfo;
            }
        }
        try {
            items = this.discoverItems(serviceName);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (encounteredExceptions != null) {
                encounteredExceptions.put(serviceName, e);
            }
            return serviceDiscoInfo;
        }
        for (DiscoverItems.Item item : items.getItems()) {
            Jid address = item.getEntityID();
            try {
                info = this.discoverInfo(address);
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                if (encounteredExceptions == null) continue;
                encounteredExceptions.put(address, e);
                continue;
            }
            if (!info.containsFeature(feature)) continue;
            serviceDiscoInfo.add(info);
            if (!stopOnFirst) continue;
            break;
        }
        if (useCache) {
            this.services.put(feature, serviceDiscoInfo);
        }
        return serviceDiscoInfo;
    }

    public List<DomainBareJid> findServices(String feature, boolean stopOnFirst, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        List<DiscoverInfo> services = this.findServicesDiscoverInfo(feature, stopOnFirst, useCache);
        ArrayList<DomainBareJid> res = new ArrayList<DomainBareJid>(services.size());
        for (DiscoverInfo info : services) {
            res.add(info.getFrom().asDomainBareJid());
        }
        return res;
    }

    public DomainBareJid findService(String feature, boolean useCache, String category, String type2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        boolean noCategory = StringUtils.isNullOrEmpty((CharSequence)category);
        boolean noType = StringUtils.isNullOrEmpty((CharSequence)type2);
        if (noType != noCategory) {
            throw new IllegalArgumentException("Must specify either both, category and type, or none");
        }
        List<DiscoverInfo> services = this.findServicesDiscoverInfo(feature, false, useCache);
        if (services.isEmpty()) {
            return null;
        }
        if (!noCategory && !noType) {
            for (DiscoverInfo info : services) {
                if (!info.hasIdentity(category, type2)) continue;
                return info.getFrom().asDomainBareJid();
            }
        }
        return services.get(0).getFrom().asDomainBareJid();
    }

    public DomainBareJid findService(String feature, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.findService(feature, useCache, null, null);
    }

    public boolean addEntityCapabilitiesChangedListener(EntityCapabilitiesChangedListener entityCapabilitiesChangedListener) {
        return this.entityCapabilitiesChangedListeners.add(entityCapabilitiesChangedListener);
    }

    private synchronized void renewEntityCapsVersion() {
        boolean canceled;
        ++this.renewEntityCapsRequested;
        if (this.renewEntityCapsScheduledAction != null && (canceled = this.renewEntityCapsScheduledAction.cancel())) {
            ++this.scheduledRenewEntityCapsAvoided;
        }
        XMPPConnection connection = this.connection();
        this.renewEntityCapsScheduledAction = ServiceDiscoveryManager.scheduleBlocking(() -> {
            this.renewEntityCapsPerformed.incrementAndGet();
            DiscoverInfoBuilder discoverInfoBuilder = (DiscoverInfoBuilder)DiscoverInfo.builder("synthetized-disco-info-response").ofType(IQ.Type.result);
            this.addDiscoverInfoTo(discoverInfoBuilder);
            DiscoverInfo synthesizedDiscoveryInfo = discoverInfoBuilder.build();
            for (EntityCapabilitiesChangedListener entityCapabilitiesChangedListener : this.entityCapabilitiesChangedListeners) {
                entityCapabilitiesChangedListener.onEntityCapabilitiesChanged(synthesizedDiscoveryInfo);
            }
            Presence presenceSend = this.presenceSend;
            if (connection.isAuthenticated() && presenceSend != null) {
                Presence presence = presenceSend.asBuilder(connection).build();
                try {
                    connection.sendStanza(presence);
                }
                catch (InterruptedException | SmackException.NotConnectedException e) {
                    LOGGER.log(Level.WARNING, "Could could not update presence with caps info", e);
                }
            }
        }, 25L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDiscoInfoLookupShortcutMechanism(DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism) {
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            discoInfoLookupShortcutMechanisms.add(discoInfoLookupShortcutMechanism);
            Collections.sort(discoInfoLookupShortcutMechanisms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDiscoInfoLookupShortcutMechanism(DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism) {
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            discoInfoLookupShortcutMechanisms.remove(discoInfoLookupShortcutMechanism);
        }
    }

    public synchronized Stats getStats() {
        return new Stats(this);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection);
            }
        });
    }

    public static final class Stats
    extends AbstractStats {
        public final int renewEntityCapsRequested;
        public final int renewEntityCapsPerformed;
        public final int scheduledRenewEntityCapsAvoided;

        private Stats(ServiceDiscoveryManager serviceDiscoveryManager) {
            this.renewEntityCapsRequested = serviceDiscoveryManager.renewEntityCapsRequested;
            this.renewEntityCapsPerformed = serviceDiscoveryManager.renewEntityCapsPerformed.get();
            this.scheduledRenewEntityCapsAvoided = serviceDiscoveryManager.scheduledRenewEntityCapsAvoided;
        }

        @Override
        public void appendStatsTo(ExtendedAppendable appendable) throws IOException {
            StringUtils.appendHeading(appendable, "ServiceDiscoveryManager stats", '#').append('\n');
            appendable.append("renew-entitycaps-requested: ").append(this.renewEntityCapsRequested).append('\n');
            appendable.append("renew-entitycaps-performed: ").append(this.renewEntityCapsPerformed).append('\n');
            appendable.append("scheduled-renew-entitycaps-avoided: ").append(this.scheduledRenewEntityCapsAvoided).append('\n');
        }
    }
}

