/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.lipsynchack;

import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.Participant;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.Source;
import org.jitsi.protocol.xmpp.JingleRequestHandler;
import org.jitsi.protocol.xmpp.JingleSession;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jxmpp.jid.Jid;

public class LipSyncHack
implements OperationSetJingle {
    private final JitsiMeetConference conference;
    private final OperationSetJingle jingleImpl;
    private final Logger logger;

    private static boolean hasValidStreamId(Source source) {
        String streamId = LipSyncHack.getStreamId(source);
        return streamId != null && !"default".equalsIgnoreCase(streamId.trim()) && !"-".equals(streamId.trim());
    }

    private static String getStreamId(Source source) {
        String streamId;
        String msid = source.getMsid();
        if (msid == null) {
            return null;
        }
        String[] streamAndTrack = msid.split(" ");
        String string = streamId = streamAndTrack.length == 2 ? streamAndTrack[0] : null;
        if (streamId != null && (streamId = streamId.trim()).isEmpty()) {
            streamId = null;
        }
        return streamId;
    }

    private static String getTrackId(Source source) {
        String trackId;
        String msid = source.getMsid();
        if (msid == null) {
            return null;
        }
        String[] streamAndTrack = msid.split(" ");
        String string = trackId = streamAndTrack.length == 2 ? streamAndTrack[1] : null;
        if (trackId != null && (trackId = trackId.trim()).isEmpty()) {
            trackId = null;
        }
        return trackId;
    }

    public LipSyncHack(@NotNull JitsiMeetConference conference, @NotNull OperationSetJingle jingleImpl, @NotNull Logger parentLogger) {
        this.conference = conference;
        this.jingleImpl = jingleImpl;
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
    }

    private boolean receiverSupportsLipSync(Jid receiverJid) {
        Participant receiver = this.conference.getParticipant(receiverJid);
        return receiver != null && receiver.hasLipSyncSupport();
    }

    private EndpointSourceSet mergeVideoIntoAudio(EndpointSourceSet sourceSet) {
        Source audioSource = sourceSet.getSources().stream().filter(s2 -> s2.getMediaType() == MediaType.AUDIO).filter(LipSyncHack::hasValidStreamId).findFirst().orElse(null);
        if (audioSource == null) {
            return sourceSet;
        }
        String audioStreamId = LipSyncHack.getStreamId(audioSource);
        HashSet<Source> mergedSources = new HashSet<Source>();
        for (Source source : sourceSet.getSources()) {
            if (source.getMediaType() != MediaType.VIDEO) {
                mergedSources.add(source);
                continue;
            }
            if (!LipSyncHack.hasValidStreamId(source)) {
                mergedSources.add(source);
                continue;
            }
            String trackId = LipSyncHack.getTrackId(source);
            mergedSources.add(new Source(source.getSsrc(), source.getMediaType(), source.getName(), audioStreamId + " " + trackId, source.getVideoType()));
            this.logger.debug("Merged video SSRC " + source.getSsrc() + " into " + audioSource);
        }
        return new EndpointSourceSet(mergedSources, sourceSet.getSsrcGroups());
    }

    private ConferenceSourceMap mergeVideoIntoAudio(ConferenceSourceMap sources) {
        ConferenceSourceMap mergedSources = new ConferenceSourceMap();
        for (Map.Entry<Jid, EndpointSourceSet> entry : sources.entrySet()) {
            Jid ownerJid = entry.getKey();
            mergedSources.add(ownerJid, this.mergeVideoIntoAudio(entry.getValue()));
        }
        return mergedSources;
    }

    @Override
    public boolean initiateSession(Jid to, List<ContentPacketExtension> contents, List<ExtensionElement> additionalExtensions, JingleRequestHandler requestHandler, ConferenceSourceMap sources, boolean encodeSourcesAsJson) throws SmackException.NotConnectedException {
        ConferenceSourceMap mergedSources = sources;
        if (this.receiverSupportsLipSync(to)) {
            this.logger.debug("Using lip-sync for " + to);
            mergedSources = this.mergeVideoIntoAudio(sources);
        }
        return this.jingleImpl.initiateSession(to, contents, additionalExtensions, requestHandler, mergedSources, encodeSourcesAsJson);
    }

    @Override
    public Jid getOurJID() {
        return this.jingleImpl.getOurJID();
    }

    @Override
    public boolean replaceTransport(@NotNull JingleSession session, List<ContentPacketExtension> contents, List<ExtensionElement> additionalExtensions, ConferenceSourceMap sources, boolean encodeSourcesAsJson) throws SmackException.NotConnectedException {
        ConferenceSourceMap mergedSources = sources;
        if (this.receiverSupportsLipSync(session.getAddress())) {
            this.logger.debug("Using lip-sync for " + session.getAddress());
            mergedSources = this.mergeVideoIntoAudio(sources);
        }
        return this.jingleImpl.replaceTransport(session, contents, additionalExtensions, mergedSources, encodeSourcesAsJson);
    }

    @Override
    public void sendAddSourceIQ(ConferenceSourceMap sources, JingleSession session, boolean encodeSourcesAsJson) {
        ConferenceSourceMap mergedSources = new ConferenceSourceMap();
        for (Map.Entry<Jid, EndpointSourceSet> entry : sources.entrySet()) {
            EndpointSourceSet existingOwnerSources;
            Participant owner;
            Jid ownerJid = entry.getKey();
            EndpointSourceSet ownerSources = entry.getValue();
            boolean haveValidAudioSource = ownerSources.getSources().stream().anyMatch(s2 -> s2.getMediaType() == MediaType.AUDIO && LipSyncHack.hasValidStreamId(s2));
            Source existingAudioSource = null;
            if (!haveValidAudioSource && (owner = this.conference.getParticipant(ownerJid)) != null && (existingOwnerSources = owner.getSources().get(ownerJid)) != null) {
                existingAudioSource = existingOwnerSources.getSources().stream().filter(s2 -> s2.getMediaType() == MediaType.AUDIO && LipSyncHack.hasValidStreamId(s2)).findFirst().orElse(null);
            }
            if (!haveValidAudioSource && existingAudioSource == null) {
                this.logger.debug("Cannot merge video into audio, no audio source exists for owner " + ownerJid + ".");
                mergedSources.add(ownerJid, ownerSources);
                continue;
            }
            if (haveValidAudioSource) {
                mergedSources.add(ownerJid, this.mergeVideoIntoAudio(ownerSources));
                continue;
            }
            HashSet<Source> ownerSourcesPlusExistingAudio = new HashSet<Source>(ownerSources.getSources());
            ownerSourcesPlusExistingAudio.add(existingAudioSource);
            EndpointSourceSet mergedOwnerSourcesPlusExistingAudio = this.mergeVideoIntoAudio(new EndpointSourceSet(ownerSourcesPlusExistingAudio, ownerSources.getSsrcGroups()));
            HashSet<Source> mergedOwnerSourcesWithoutExistingAudio = new HashSet<Source>(mergedOwnerSourcesPlusExistingAudio.getSources());
            mergedOwnerSourcesWithoutExistingAudio.remove(existingAudioSource);
            mergedSources.add(ownerJid, new EndpointSourceSet(mergedOwnerSourcesWithoutExistingAudio, ownerSources.getSsrcGroups()));
        }
        this.jingleImpl.sendAddSourceIQ(mergedSources, session, encodeSourcesAsJson);
    }

    @Override
    public void sendRemoveSourceIQ(ConferenceSourceMap sourcesToRemove, JingleSession session, boolean encodeSourcesAsJson) {
        this.jingleImpl.sendRemoveSourceIQ(sourcesToRemove, session, encodeSourcesAsJson);
    }

    @Override
    public void terminateSession(JingleSession session, Reason reason, String msg, boolean sendTerminate) {
        this.jingleImpl.terminateSession(session, reason, msg, sendTerminate);
    }

    @Override
    public void terminateHandlersSessions(JingleRequestHandler requestHandler) {
        this.jingleImpl.terminateHandlersSessions(requestHandler);
    }
}

