/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.XmppProvider;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.EntityFullJid;

public class DiscoveryUtil {
    private static final Logger logger = new LoggerImpl(DiscoveryUtil.class.getName());
    public static final String FEATURE_AUDIO = "urn:xmpp:jingle:apps:rtp:audio";
    public static final String FEATURE_VIDEO = "urn:xmpp:jingle:apps:rtp:video";
    public static final String FEATURE_SCTP = "urn:xmpp:jingle:transports:dtls-sctp:1";
    public static final String FEATURE_RTX = "urn:ietf:rfc:4588";
    public static final String FEATURE_REMB = "http://jitsi.org/remb";
    public static final String FEATURE_TCC = "http://jitsi.org/tcc";
    public static final String FEATURE_SOURCE_NAMES = "http://jitsi.org/source-name";
    public static final String FEATURE_RECEIVE_MULTIPLE_STREAMS = "http://jitsi.org/receive-multiple-video-streams";
    public static final String FEATURE_JSON_SOURCES = "http://jitsi.org/json-encoded-sources";
    public static final String FEATURE_OPUS_RED = "http://jitsi.org/opus-red";
    public static final String FEATURE_LIPSYNC = "http://jitsi.org/meet/lipsync";
    public static final String FEATURE_AUDIO_MUTE = "http://jitsi.org/protocol/audio-mute";
    private static final List<String> defaultFeatures = List.of("urn:xmpp:jingle:apps:rtp:audio", "urn:xmpp:jingle:apps:rtp:video", "urn:xmpp:jingle:transports:dtls-sctp:1");

    public static List<String> getDefaultParticipantFeatureSet() {
        return new ArrayList<String>(defaultFeatures);
    }

    @NotNull
    public static List<String> discoverParticipantFeatures(@NotNull XmppProvider xmppProvider, EntityFullJid address) {
        AbstractXMPPConnection xmppConnection = xmppProvider.getXmppConnection();
        if (!xmppConnection.isConnected()) {
            logger.error("XMPP not connected " + xmppProvider);
            return DiscoveryUtil.getDefaultParticipantFeatureSet();
        }
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor(xmppConnection);
        if (discoveryManager == null) {
            logger.error("Service discovery not supported by " + xmppProvider);
            return DiscoveryUtil.getDefaultParticipantFeatureSet();
        }
        long start2 = System.currentTimeMillis();
        List<String> participantFeatures = null;
        try {
            DiscoverInfo info = discoveryManager.discoverInfo(address);
            if (info != null) {
                participantFeatures = info.getFeatures().stream().map(DiscoverInfo.Feature::getVar).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.warn(String.format("Failed to discover features for %s: %s", address, e.getMessage()));
        }
        long tookMillis = System.currentTimeMillis() - start2;
        if (participantFeatures == null) {
            logger.warn("Failed to discover features for " + address + " assuming default feature set. Took " + tookMillis + " ms.");
            return DiscoveryUtil.getDefaultParticipantFeatureSet();
        }
        logger.info("Discovered features for " + address + " in " + tookMillis + " ms.");
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(address).append(", features: ").append(String.join((CharSequence)", ", participantFeatures)).append(", in: ").append(tookMillis);
            logger.debug(sb);
        } else {
            logger.info(String.format("Successfully discovered features for %s in %d", address, tookMillis));
        }
        return participantFeatures;
    }
}

