/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeSelectionStrategy;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

class SplitBridgeSelectionStrategy
extends BridgeSelectionStrategy {
    private static final Logger logger = new LoggerImpl(SplitBridgeSelectionStrategy.class.getName());

    @Override
    public Bridge doSelect(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        Optional<Bridge> bridgeNotYetInConf = bridges.stream().filter(b -> !conferenceBridges.containsKey(b)).findFirst();
        return bridgeNotYetInConf.orElseGet(() -> conferenceBridges.entrySet().stream().filter(b -> bridges.contains(b.getKey())).min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null));
    }

    @Override
    public Bridge select(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion, boolean allowMultiBridge) {
        if (!allowMultiBridge) {
            logger.warn("Force-enabling octo for SplitBridgeSelectionStrategy. To suppress this warning, enable octo in jicofo.conf.");
        }
        return super.select(bridges, conferenceBridges, participantRegion, true);
    }
}

