/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DownloadArtifactBuildOperationType;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class ArtifactBackedResolvedVariant
implements ResolvedVariant {
    private final VariantResolveMetadata.Identifier identifier;
    private final DisplayName displayName;
    private final AttributeContainerInternal attributes;
    private final ResolvedArtifactSet artifacts;

    private ArtifactBackedResolvedVariant(@Nullable VariantResolveMetadata.Identifier identifier, DisplayName displayName, AttributeContainerInternal attributes, ResolvedArtifactSet artifacts) {
        this.identifier = identifier;
        this.displayName = displayName;
        this.attributes = attributes;
        this.artifacts = artifacts;
    }

    public static ResolvedVariant create(@Nullable VariantResolveMetadata.Identifier identifier, DisplayName displayName, AttributeContainerInternal attributes, Collection<? extends ResolvableArtifact> artifacts) {
        if (artifacts.isEmpty()) {
            return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, ResolvedArtifactSet.EMPTY);
        }
        if (artifacts.size() == 1) {
            return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, new SingleArtifactSet(displayName, (AttributeContainer)attributes, artifacts.iterator().next()));
        }
        ArrayList<SingleArtifactSet> artifactSets = new ArrayList<SingleArtifactSet>(artifacts.size());
        for (ResolvableArtifact resolvableArtifact : artifacts) {
            artifactSets.add(new SingleArtifactSet(displayName, (AttributeContainer)attributes, resolvableArtifact));
        }
        return new ArtifactBackedResolvedVariant(identifier, displayName, attributes, CompositeResolvedArtifactSet.of(artifactSets));
    }

    @Override
    public VariantResolveMetadata.Identifier getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return this.displayName;
    }

    @Override
    public ResolvedArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.attributes;
    }

    private static class DownloadArtifactFile
    implements RunnableBuildOperation {
        private final ResolvableArtifact artifact;
        private final SingleArtifactSet owner;
        private final ResolvedArtifactSet.AsyncArtifactListener listener;

        DownloadArtifactFile(ResolvableArtifact artifact, SingleArtifactSet owner, ResolvedArtifactSet.AsyncArtifactListener visitor) {
            this.artifact = artifact;
            this.owner = owner;
            this.listener = visitor;
        }

        public void run(BuildOperationContext context) {
            try {
                this.artifact.getFile();
                this.listener.artifactAvailable(this.artifact);
                if (context != null) {
                    context.setResult((Object)DownloadArtifactBuildOperationType.RESULT);
                }
            }
            catch (Exception t) {
                this.owner.failure = t;
            }
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)("Resolve " + this.artifact)).details((Object)new DownloadArtifactBuildOperationType.DetailsImpl(this.artifact.getId().getDisplayName()));
        }
    }

    public static class SingleLocalArtifactSet
    implements ResolvedArtifactSet.LocalArtifactSet {
        private final ResolvableArtifact artifact;

        public SingleLocalArtifactSet(ResolvableArtifact artifact) {
            this.artifact = artifact;
        }

        public ResolvableArtifact getArtifact() {
            return this.artifact;
        }

        @Override
        public Object getId() {
            return this.artifact.getId();
        }

        @Override
        public String getDisplayName() {
            return this.artifact.getId().getDisplayName();
        }

        @Override
        public TaskDependencyContainer getTaskDependencies() {
            return this.artifact;
        }

        @Override
        public TransformationSubject calculateSubject() {
            return TransformationSubject.initial(this.artifact.getId(), this.artifact.getFile());
        }

        @Override
        public ResolvableArtifact transformedTo(File output) {
            return this.artifact.transformedTo(output);
        }
    }

    private static class SingleArtifactSet
    implements ResolvedArtifactSet,
    ResolvedArtifactSet.Completion {
        private final DisplayName variantName;
        private final AttributeContainer variantAttributes;
        private final ResolvableArtifact artifact;
        private volatile Throwable failure;

        SingleArtifactSet(DisplayName variantName, AttributeContainer variantAttributes, ResolvableArtifact artifact) {
            this.variantName = variantName;
            this.variantAttributes = variantAttributes;
            this.artifact = artifact;
        }

        @Override
        public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
            if (listener.requireArtifactFiles()) {
                if (this.artifact.isResolveSynchronously()) {
                    new DownloadArtifactFile(this.artifact, this, listener).run(null);
                } else {
                    actions.add((BuildOperation)new DownloadArtifactFile(this.artifact, this, listener));
                }
            }
            return this;
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            if (this.failure != null) {
                visitor.visitFailure(this.failure);
            } else {
                visitor.visitArtifact(this.variantName, this.variantAttributes, this.artifact);
                visitor.endVisitCollection(FileCollectionInternal.OTHER);
            }
        }

        @Override
        public void visitLocalArtifacts(ResolvedArtifactSet.LocalArtifactVisitor visitor) {
            if (this.artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
                visitor.visitArtifact(new SingleLocalArtifactSet(this.artifact));
            }
        }

        @Override
        public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
            if (!(this.artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                visitor.execute((Object)this.artifact);
            }
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add((Object)this.artifact);
        }

        public String toString() {
            return this.artifact.getId().getDisplayName();
        }
    }
}

