/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.FileBasedInstallationFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class SdkmanInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private Provider<String> candidatesDir = this.getEnvironmentProperty("SDKMAN_CANDIDATES_DIR");

    @Inject
    public SdkmanInstallationSupplier(ProviderFactory factory) {
        super(factory);
    }

    @Override
    protected Set<InstallationLocation> findCandidates() {
        return (Set)this.candidatesDir.map(this.findJavaCandidates()).getOrElse(Collections.emptySet());
    }

    private Transformer<Set<InstallationLocation>, String> findJavaCandidates() {
        return candidatesDir -> {
            File root = new File((String)candidatesDir, "java");
            return FileBasedInstallationFactory.fromDirectory(root, "SDKMAN");
        };
    }
}

