# -*- coding: utf-8 -*-
"""This file contains the Windows NT Language identifiers."""

from __future__ import unicode_literals


LANGUAGE_IDENTIFIERS = {
    'af': [0x0036, 'Afrikaans'],
    'af-ZA': [0x0436, 'Afrikaans, South Africa'],
    'am': [0x005e, 'Amharic'],
    'am-ET': [0x045e, 'Amharic, Ethiopia'],
    'ar': [0x0001, 'Arabic'],
    'ar-AE': [0x3801, 'Arabic, United Arab Emirates'],
    'ar-BH': [0x3c01, 'Arabic, Bahrain'],
    'ar-DZ': [0x1401, 'Arabic, Algeria'],
    'ar-EG': [0x0c01, 'Arabic, Egypt'],
    'ar-IQ': [0x0801, 'Arabic, Iraq'],
    'ar-JO': [0x2c01, 'Arabic, Jordan'],
    'ar-KW': [0x3401, 'Arabic, Kuwait'],
    'ar-LB': [0x3001, 'Arabic, Lebanon'],
    'ar-LY': [0x1001, 'Arabic, Libyan Arab Jamahiriya'],
    'ar-MA': [0x1801, 'Arabic, Morocco'],
    'arn': [0x007a, 'Mapudungun'],
    'arn-CL': [0x047a, 'Mapudungun, Chile'],
    'ar-OM': [0x2001, 'Arabic, Oman'],
    'ar-QA': [0x4001, 'Arabic, Qatar'],
    'ar-SA': [0x0401, 'Arabic, Saudi Arabia'],
    'ar-SY': [0x2801, 'Arabic, Syrian Arab Republic'],
    'ar-TN': [0x1c01, 'Arabic, Tunisia'],
    'ar-YE': [0x2401, 'Arabic, Yemen'],
    'as': [0x004d, 'Assamese'],
    'as-IN': [0x044d, 'Assamese, India'],
    'az': [0x002c, 'Azerbaijani'],
    'az-Cyrl': [0x742c, 'Azerbaijani, Cyrillic'],
    'az-Cyrl-AZ': [0x082c, 'Azerbaijani, Cyrillic, Azerbaijan'],
    'az-Latn': [0x782c, 'Azerbaijani, Latin'],
    'az-Latn-AZ': [0x042c, 'Azerbaijani, Latin, Azerbaijan'],
    'ba': [0x006d, 'Bashkir'],
    'ba-RU': [0x046d, 'Bashkir, Russian Federation'],
    'be': [0x0023, 'Belarusian'],
    'be-BY': [0x0423, 'Belarusian, Belarus'],
    'bg': [0x0002, 'Bulgarian'],
    'bg-BG': [0x0402, 'Bulgarian, Bulgaria'],
    'bin-NG': [0x0466, 'Bini, Nigeria'],
    'bn': [0x0045, 'Bengali'],
    'bn-BD': [0x0845, 'Bengali, Bangladesh'],
    'bn-IN': [0x0445, 'Bengali, India'],
    'bo': [0x0051, 'Tibetan'],
    'bo-BT': [0x0851, 'Tibetan, Bhutan'],
    'bo-CN': [0x0451, 'Tibetan, China'],
    'br': [0x007e, 'Breton'],
    'br-FR': [0x047e, 'Breton, France'],
    'bs': [0x781a, 'Bosnian'],
    'bs-Cyrl': [0x641a, 'Bosnian, Cyrillic'],
    'bs-Cyrl-BA': [0x201a, 'Bosnian, Cyrillic, Bosnia and Herzegovina'],
    'bs-Latn': [0x681a, 'Bosnian, Latin'],
    'bs-Latn-BA': [0x141a, 'Bosnian, Latin, Bosnia and Herzegovina'],
    'ca': [0x0003, 'Catalan'],
    'ca-ES': [0x0403, 'Catalan, Spain'],
    'chr-US': [0x045c, 'Cherokee, United States'],
    'co': [0x0083, 'Corsican'],
    'co-FR': [0x0483, 'Corsican, France'],
    'cs': [0x0005, 'Czech'],
    'cs-CZ': [0x0405, 'Czech, Czech Republic'],
    'cy': [0x0052, 'Welsh'],
    'cy-GB': [0x0452, 'Welsh, United Kingdom'],
    'da': [0x0006, 'Danish'],
    'da-DK': [0x0406, 'Danish, Denmark'],
    'de': [0x0007, 'German'],
    'de-AT': [0x0c07, 'German, Austria'],
    'de-CH': [0x0807, 'German, Switzerland'],
    'de-DE': [0x0407, 'German, Germany'],
    'de-LI': [0x1407, 'German, Liechtenstein'],
    'de-LU': [0x1007, 'German, Luxembourg'],
    'dsb': [0x7c2e, 'Lower Sorbian'],
    'dsb-DE': [0x082e, 'Lower Sorbian, Germany'],
    'dv': [0x0065, 'Dhivehi'],
    'dv-MV': [0x0465, 'Dhivehi, Maldives'],
    'el': [0x0008, 'Modern Greek (1453 and later)'],
    'el-GR': [0x0408, 'Modern Greek (1453-), Greece'],
    'en': [0x0009, 'English'],
    'en-AU': [0x0c09, 'English, Australia'],
    'en-BZ': [0x2809, 'English, Belize'],
    'en-CA': [0x1009, 'English, Canada'],
    'en-CB': [0x2409, 'English'],
    'en-GB': [0x0809, 'English, United Kingdom'],
    'en-HK': [0x3c09, 'English, Hong Kong'],
    'en-ID': [0x3809, 'English, Indonesia'],
    'en-IE': [0x1809, 'English, Ireland'],
    'en-IN': [0x4009, 'English, India'],
    'en-JM': [0x2009, 'English, Jamaica'],
    'en-MY': [0x4409, 'English, Malaysia'],
    'en-NZ': [0x1409, 'English, New Zealand'],
    'en-PH': [0x3409, 'English, Philippines'],
    'en-SG': [0x4809, 'English, Singapore'],
    'en-TT': [0x2c09, 'English, Trinidad and Tobago'],
    'en-US': [0x0409, 'English, United States'],
    'en-ZA': [0x1c09, 'English, South Africa'],
    'en-ZW': [0x3009, 'English, Zimbabwe'],
    'es': [0x000a, 'Spanish'],
    'es-AR': [0x2c0a, 'Spanish, Argentina'],
    'es-BO': [0x400a, 'Spanish, Bolivia'],
    'es-CL': [0x340a, 'Spanish, Chile'],
    'es-CO': [0x240a, 'Spanish, Colombia'],
    'es-CR': [0x140a, 'Spanish, Costa Rica'],
    'es-DO': [0x1c0a, 'Spanish, Dominican Republic'],
    'es-EC': [0x300a, 'Spanish, Ecuador'],
    'es-ES': [0x0c0a, 'Spanish, Spain'],
    'es-ES_tradnl': [0x040a, 'Spanish'],
    'es-GT': [0x100a, 'Spanish, Guatemala'],
    'es-HN': [0x480a, 'Spanish, Honduras'],
    'es-MX': [0x080a, 'Spanish, Mexico'],
    'es-NI': [0x4c0a, 'Spanish, Nicaragua'],
    'es-PA': [0x180a, 'Spanish, Panama'],
    'es-PE': [0x280a, 'Spanish, Peru'],
    'es-PR': [0x500a, 'Spanish, Puerto Rico'],
    'es-PY': [0x3c0a, 'Spanish, Paraguay'],
    'es-SV': [0x440a, 'Spanish, El Salvador'],
    'es-US': [0x540a, 'Spanish, United States'],
    'es-UY': [0x380a, 'Spanish, Uruguay'],
    'es-VE': [0x200a, 'Spanish, Venezuela'],
    'et': [0x0025, 'Estonian'],
    'et-EE': [0x0425, 'Estonian, Estonia'],
    'eu': [0x002d, 'Basque'],
    'eu-ES': [0x042d, 'Basque, Spain'],
    'fa': [0x0029, 'Persian'],
    'fa-IR': [0x0429, 'Persian, Islamic Republic of Iran'],
    'fi': [0x000b, 'Finnish'],
    'fi-FI': [0x040b, 'Finnish, Finland'],
    'fil': [0x0064, 'Filipino'],
    'fil-PH': [0x0464, 'Filipino, Philippines'],
    'fo': [0x0038, 'Faroese'],
    'fo-FO': [0x0438, 'Faroese, Faroe Islands'],
    'fr': [0x000c, 'French'],
    'fr-BE': [0x080c, 'French, Belgium'],
    'fr-CA': [0x0c0c, 'French, Canada'],
    'fr-CG': [0x240c, 'French, Congo'],
    'fr-CH': [0x100c, 'French, Switzerland'],
    'fr-CI': [0x300c, 'French, Côte d\'Ivoire'],
    'fr-CM': [0x2c0c, 'French, Cameroon'],
    'fr-FR': [0x040c, 'French, France'],
    'fr-HT': [0x3c0c, 'French, Haiti'],
    'fr-LU': [0x140c, 'French, Luxembourg'],
    'fr-MA': [0x380c, 'French, Morocco'],
    'fr-MC': [0x180c, 'French, Monaco'],
    'fr-ML': [0x340c, 'French, Mali'],
    'fr-RE': [0x200c, 'French, Réunion'],
    'fr-SN': [0x280c, 'French, Senegal'],
    'fr-West': [0x1c0c, 'French'],
    'fuv-NG': [0x0467, 'Nigerian Fulfulde, Nigeria'],
    'fy': [0x0062, 'Western Frisian'],
    'fy-NL': [0x0462, 'Western Frisian, Netherlands'],
    'ga': [0x003c, 'Irish'],
    'ga-IE': [0x083c, 'Irish, Ireland'],
    'gaz-ET': [0x0472, 'West Central Oromo, Ethiopia'],
    'gd': [0x0091, 'Scottish Gaelic'],
    'gd-GB': [0x0491, 'Scottish Gaelic, United Kingdom'],
    'gl': [0x0056, 'Galician'],
    'gl-ES': [0x0456, 'Galician, Spain'],
    'gn-PY': [0x0474, 'Guarani, Paraguay'],
    'gsw': [0x0084, 'Swiss German'],
    'gsw-FR': [0x0484, 'Swiss German, France'],
    'gu': [0x0047, 'Gujarati'],
    'gu-IN': [0x0447, 'Gujarati, India'],
    'ha': [0x0068, 'Hausa'],
    'ha-Latn': [0x7c68, 'Hausa, Latin'],
    'ha-Latn-NG': [0x0468, 'Hausa, Latin, Nigeria'],
    'haw-US': [0x0475, 'Hawaiian, United States'],
    'he': [0x000d, 'Hebrew'],
    'he-IL': [0x040d, 'Hebrew, Israel'],
    'hi': [0x0039, 'Hindi'],
    'hi-IN': [0x0439, 'Hindi, India'],
    'hr': [0x001a, 'Croatian'],
    'hr-BA': [0x101a, 'Croatian, Bosnia and Herzegovina'],
    'hr-HR': [0x041a, 'Croatian, Croatia'],
    'hsb': [0x002e, 'Upper Sorbian'],
    'hu': [0x000e, 'Hungarian'],
    'hu-HU': [0x040e, 'Hungarian, Hungary'],
    'hy': [0x002b, 'Armenian'],
    'hy-AM': [0x042b, 'Armenian, Armenia'],
    'ibb-NG': [0x0469, 'Ibibio, Nigeria'],
    'id': [0x0021, 'Indonesian'],
    'id-ID': [0x0421, 'Indonesian, Indonesia'],
    'ig': [0x0070, 'Igbo'],
    'ig-NG': [0x0470, 'Igbo, Nigeria'],
    'ii': [0x0078, 'Sichuan Yi'],
    'ii-CN': [0x0478, 'Sichuan Yi, China'],
    'is': [0x000f, 'Icelandic'],
    'is-IS': [0x040f, 'Icelandic, Iceland'],
    'it': [0x0010, 'Italian'],
    'it-CH': [0x0810, 'Italian, Switzerland'],
    'it-IT': [0x0410, 'Italian, Italy'],
    'iu': [0x005d, 'Inuktitut'],
    'iu-Cans': [0x785d, 'Inuktitut, Unified Canadian Aboriginal Syllabics'],
    'iu-Cans-CA': [
        0x045d, 'Inuktitut, Unified Canadian Aboriginal Syllabics, Canada'],
    'iu-Latn': [0x7c5d, 'Inuktitut, Latin'],
    'iu-Latn-CA': [0x085d, 'Inuktitut, Latin, Canada'],
    'ja': [0x0011, 'Japanese'],
    'ja-JP': [0x0411, 'Japanese, Japan'],
    'ka': [0x0037, 'Georgian'],
    'ka-GE': [0x0437, 'Georgian, Georgia'],
    'kk': [0x003f, 'Kazakh'],
    'kk-KZ': [0x043f, 'Kazakh, Kazakhstan'],
    'kl': [0x006f, 'Kalaallisut'],
    'kl-GL': [0x046f, 'Kalaallisut, Greenland'],
    'km': [0x0053, 'Central Khmer'],
    'km-KH': [0x0453, 'Central Khmer, Cambodia'],
    'kn': [0x004b, 'Kannada'],
    'kn-IN': [0x044b, 'Kannada, India'],
    'ko': [0x0012, 'Korean'],
    'kok': [0x0057, 'Konkani (macrolanguage)'],
    'kok-IN': [0x0457, 'Konkani (macrolanguage), India'],
    'ko-KR': [0x0412, 'Korean, Republic of Korea'],
    'kr-NG': [0x0471, 'Kanuri, Nigeria'],
    'ky': [0x0040, 'Kirghiz'],
    'ky-KG': [0x0440, 'Kirghiz, Kyrgyzstan'],
    'lb': [0x006e, 'Luxembourgish'],
    'lb-LU': [0x046e, 'Luxembourgish, Luxembourg'],
    'lo': [0x0054, 'Lao'],
    'lo-LA': [0x0454, 'Lao, Lao People\'s Democratic Republic'],
    'lt': [0x0027, 'Lithuanian'],
    'lt-LT': [0x0427, 'Lithuanian, Lithuania'],
    'lv': [0x0026, 'Latvian'],
    'lv-LV': [0x0426, 'Latvian, Latvia'],
    'mi': [0x0081, 'Maori'],
    'mi-NZ': [0x0481, 'Maori, New Zealand'],
    'mk': [0x002f, 'Macedonian'],
    'mk-MK': [
        0x042f, 'Macedonian, The Former Yugoslav Republic of Macedonia'],
    'ml': [0x004c, 'Malayalam'],
    'ml-IN': [0x044c, 'Malayalam, India'],
    'mn': [0x0050, 'Mongolian'],
    'mn-Cyrl': [0x7850, 'Mongolian, Cyrillic'],
    'mni': [0x0458, 'Manipuri'],
    'mn-MN': [0x0450, 'Mongolian, Mongolia'],
    'mn-Mong': [0x7c50, 'Mongolian, Mongolian'],
    'mn-Mong-CN': [0x0850, 'Mongolian, Mongolian, China'],
    'moh': [0x007c, 'Mohawk'],
    'moh-CA': [0x047c, 'Mohawk, Canada'],
    'mr': [0x004e, 'Marathi'],
    'mr-IN': [0x044e, 'Marathi, India'],
    'ms': [0x003e, 'Malay (macrolanguage)'],
    'ms-BN': [0x083e, 'Malay (macrolanguage), Brunei Darussalam'],
    'ms-MY': [0x043e, 'Malay (macrolanguage), Malaysia'],
    'mt': [0x003a, 'Maltese'],
    'mt-MT': [0x043a, 'Maltese, Malta'],
    'my-MM': [0x0455, 'Burmese, Myanmar'],
    'nb': [0x7c14, 'Norwegian Bokmål'],
    'nb-NO': [0x0414, 'Norwegian Bokmål, Norway'],
    'ne': [0x0061, 'Nepali'],
    'ne-IN': [0x0861, 'Nepali, India'],
    'ne-NP': [0x0461, 'Nepali, Nepal'],
    'nl': [0x0013, 'Dutch'],
    'nl-BE': [0x0813, 'Dutch, Belgium'],
    'nl-NL': [0x0413, 'Dutch, Netherlands'],
    'nn': [0x7814, 'Norwegian Nynorsk'],
    'nn-NO': [0x0814, 'Norwegian Nynorsk, Norway'],
    'no': [0x0014, 'Norwegian'],
    'nso': [0x006c, 'Pedi'],
    'nso-ZA': [0x046c, 'Pedi, South Africa'],
    'oc': [0x0082, 'Occitan (post 1500)'],
    'oc-FR': [0x0482, 'Occitan (post 1500), France'],
    'or': [0x0048, 'Oriya'],
    'or-IN': [0x0448, 'Oriya, India'],
    'pa': [0x0046, 'Panjabi'],
    'pa-IN': [0x0446, 'Panjabi, India'],
    'pap-AN': [0x0479, 'Papiamento, Netherlands Antilles'],
    'pa-PK': [0x0846, 'Panjabi, Pakistan'],
    'pl': [0x0015, 'Polish'],
    'pl-PL': [0x0415, 'Polish, Poland'],
    'plt-MG': [0x048d, 'Plateau Malagasy, Madagascar'],
    'prs': [0x008c, 'Dari'],
    'prs-AF': [0x048c, 'Dari, Afghanistan'],
    'ps': [0x0063, 'Pushto'],
    'ps-AF': [0x0463, 'Pushto, Afghanistan'],
    'pt': [0x0016, 'Portuguese'],
    'pt-BR': [0x0416, 'Portuguese, Brazil'],
    'pt-PT': [0x0816, 'Portuguese, Portugal'],
    'qut': [0x0086, 'Guatemala'],
    'qut-GT': [0x0486, 'Guatemala'],
    'quz': [0x006b, 'Cusco Quechua'],
    'quz-BO': [0x046b, 'Cusco Quechua, Bolivia'],
    'quz-EC': [0x086b, 'Cusco Quechua, Ecuador'],
    'quz-PE': [0x0c6b, 'Cusco Quechua, Peru'],
    'rm': [0x0017, 'Romansh'],
    'rm-CH': [0x0417, 'Romansh, Switzerland'],
    'ro': [0x0018, 'Romanian'],
    'ro-MO': [0x0818, 'Romanian, Macao'],
    'ro-RO': [0x0418, 'Romanian, Romania'],
    'ru': [0x0019, 'Russian'],
    'ru-MO': [0x0819, 'Russian, Macao'],
    'ru-RU': [0x0419, 'Russian, Russian Federation'],
    'rw': [0x0087, 'Kinyarwanda'],
    'rw-RW': [0x0487, 'Kinyarwanda, Rwanda'],
    'sa': [0x004f, 'Sanskrit'],
    'sah': [0x0085, 'Yakut'],
    'sah-RU': [0x0485, 'Yakut, Russian Federation'],
    'sa-IN': [0x044f, 'Sanskrit, India'],
    'sd-IN': [0x0459, 'Sindhi, India'],
    'sd-PK': [0x0859, 'Sindhi, Pakistan'],
    'se': [0x003b, 'Northern Sami'],
    'se-FI': [0x0c3b, 'Northern Sami, Finland'],
    'se-NO': [0x043b, 'Northern Sami, Norway'],
    'se-SE': [0x083b, 'Northern Sami, Sweden'],
    'si': [0x005b, 'Sinhala'],
    'si-LK': [0x045b, 'Sinhala, Sri Lanka'],
    'sk': [0x001b, 'Slovak'],
    'sk-SK': [0x041b, 'Slovak, Slovakia'],
    'sl': [0x0024, 'Slovenian'],
    'sl-SI': [0x0424, 'Slovenian, Slovenia'],
    'sma': [0x783b, 'Southern Sami'],
    'sma-NO': [0x183b, 'Southern Sami, Norway'],
    'sma-SE': [0x1c3b, 'Southern Sami, Sweden'],
    'smj': [0x7c3b, 'Lule Sami'],
    'smj-NO': [0x103b, 'Lule Sami, Norway'],
    'smj-SE': [0x143b, 'Lule Sami, Sweden'],
    'smn': [0x703b, 'Inari Sami'],
    'smn-FI': [0x243b, 'Inari Sami, Finland'],
    'sms': [0x743b, 'Skolt Sami'],
    'sms-FI': [0x203b, 'Skolt Sami, Finland'],
    'so-SO': [0x0477, 'Somali, Somalia'],
    'sq': [0x001c, 'Albanian'],
    'sq-AL': [0x041c, 'Albanian, Albania'],
    'sr': [0x7c1a, 'Serbian'],
    'sr-Cyrl': [0x6c1a, 'Serbian, Cyrillic'],
    'sr-Cyrl-BA': [0x1c1a, 'Serbian, Cyrillic, Bosnia and Herzegovina'],
    'sr-Cyrl-CS': [0x0c1a, 'Serbian, Cyrillic, Serbia and Montenegro'],
    'sr-Cyrl-ME': [0x301a, 'Serbian, Cyrillic, Montenegro'],
    'sr-Cyrl-RS': [0x281a, 'Serbian, Cyrillic, Serbia'],
    'sr-Latn': [0x701a, 'Serbian, Latin'],
    'sr-Latn-BA': [0x181a, 'Serbian, Latin, Bosnia and Herzegovina'],
    'sr-Latn-CS': [0x081a, 'Serbian, Latin, Serbia and Montenegro'],
    'sr-Latn-ME': [0x2c1a, 'Serbian, Latin, Montenegro'],
    'sr-Latn-RS': [0x241a, 'Serbian, Latin, Serbia'],
    'st-ZA': [0x0430, 'Southern Sotho, South Africa'],
    'sv': [0x001d, 'Swedish'],
    'sv-FI': [0x081d, 'Swedish, Finland'],
    'sv-SE': [0x041d, 'Swedish, Sweden'],
    'sw': [0x0041, 'Swahili (macrolanguage)'],
    'sw-KE': [0x0441, 'Swahili (macrolanguage), Kenya'],
    'syr': [0x005a, 'Syriac'],
    'syr-SY': [0x045a, 'Syriac, Syrian Arab Republic'],
    'ta': [0x0049, 'Tamil'],
    'ta-IN': [0x0449, 'Tamil, India'],
    'te': [0x004a, 'Telugu'],
    'te-IN': [0x044a, 'Telugu, India'],
    'tg': [0x0028, 'Tajik'],
    'tg-Cyrl': [0x7c28, 'Tajik, Cyrillic'],
    'tg-Cyrl-TJ': [0x0428, 'Tajik, Cyrillic, Tajikistan'],
    'th': [0x001e, 'Thai'],
    'th-TH': [0x041e, 'Thai, Thailand'],
    'ti-ER': [0x0473, 'Tigrinya, Eritrea'],
    'ti-ET': [0x0873, 'Tigrinya, Ethiopia'],
    'tk': [0x0042, 'Turkmen'],
    'tk-TM': [0x0442, 'Turkmen, Turkmenistan'],
    'tmz': [0x045f, 'Tamanaku'],
    'tmz-MA': [0x0c5f, 'Tamanaku, Morocco'],
    'tn': [0x0032, 'Tswana'],
    'tn-ZA': [0x0432, 'Tswana, South Africa'],
    'tr': [0x001f, 'Turkish'],
    'tr-TR': [0x041f, 'Turkish, Turkey'],
    'ts-ZA': [0x0431, 'Tsonga, South Africa'],
    'tt': [0x0044, 'Tatar'],
    'tt-RU': [0x0444, 'Tatar, Russian Federation'],
    'tzm': [0x005f, 'Central Atlas Tamazight'],
    'tzm-Latn': [0x7c5f, 'Central Atlas Tamazight, Latin'],
    'tzm-Latn-DZ': [0x085f, 'Central Atlas Tamazight, Latin, Algeria'],
    'ug': [0x0080, 'Uighur'],
    'ug-CN': [0x0480, 'Uighur, China'],
    'uk': [0x0022, 'Ukrainian'],
    'uk-UA': [0x0422, 'Ukrainian, Ukraine'],
    'ur': [0x0020, 'Urdu'],
    'ur-IN': [0x0820, 'Urdu, India'],
    'ur-PK': [0x0420, 'Urdu, Pakistan'],
    'uz': [0x0043, 'Uzbek'],
    'uz-Cyrl': [0x7843, 'Uzbek, Cyrillic'],
    'uz-Cyrl-UZ': [0x0843, 'Uzbek, Cyrillic, Uzbekistan'],
    'uz-Latn': [0x7c43, 'Uzbek, Latin'],
    'uz-Latn-UZ': [0x0443, 'Uzbek, Latin, Uzbekistan'],
    'ven-ZA': [0x0433, 'South Africa'],
    'vi': [0x002a, 'Vietnamese'],
    'vi-VN': [0x042a, 'Vietnamese, Viet Nam'],
    'wen-DE': [0x042e, 'Sorbian languages, Germany'],
    'wo': [0x0088, 'Wolof'],
    'wo-SN': [0x0488, 'Wolof, Senegal'],
    'xh': [0x0034, 'Xhosa'],
    'xh-ZA': [0x0434, 'Xhosa, South Africa'],
    'yo': [0x006a, 'Yoruba'],
    'yo-NG': [0x046a, 'Yoruba, Nigeria'],
    'zh': [0x7804, 'Chinese'],
    'zh-CN': [0x0804, 'Chinese, China'],
    'zh-Hans': [0x0004, 'Chinese, Han (Simplified variant)'],
    'zh-Hant': [0x7c04, 'Chinese, Han (Traditional variant)'],
    'zh-HK': [0x0c04, 'Chinese, Hong Kong'],
    'zh-MO': [0x1404, 'Chinese, Macao'],
    'zh-SG': [0x1004, 'Chinese, Singapore'],
    'zh-TW': [0x0404, 'Chinese, Taiwan, Province of China'],
    'zu': [0x0035, 'Zulu'],
    'zu-ZA': [0x0435, 'Zulu, South Africa'],
}

# Make sure the language identifiers are lower case.
LANGUAGE_IDENTIFIERS = dict(
    (key.lower(), value) for key, value in LANGUAGE_IDENTIFIERS.items())
