(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/text/json#read-json__%
    (lambda (_port898_) (std/text/json#read-json-object__% _port898_ '#f)))
  (define std/text/json#read-json__0
    (lambda ()
      (let ((_port904_ (current-input-port)))
        (std/text/json#read-json__% _port904_))))
  (define std/text/json#read-json
    (lambda _g4580_
      (let ((_g4579_ (##length _g4580_)))
        (cond ((##fx= _g4579_ 0) (apply std/text/json#read-json__0 _g4580_))
              ((##fx= _g4579_ 1) (apply std/text/json#read-json__% _g4580_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/json#read-json
                _g4580_))))))
  (define std/text/json#string->json-object
    (lambda (_str895_)
      (std/text/json#read-json-object__% (open-input-string _str895_) '#f)))
  (define std/text/json#write-json__%
    (lambda (_obj882_ _port883_)
      (std/text/json#write-json-object _obj882_ _port883_)))
  (define std/text/json#write-json__0
    (lambda (_obj888_)
      (let ((_port890_ (current-output-port)))
        (std/text/json#write-json-object _obj888_ _port890_))))
  (define std/text/json#write-json
    (lambda _g4582_
      (let ((_g4581_ (##length _g4582_)))
        (cond ((##fx= _g4581_ 1) (apply std/text/json#write-json__0 _g4582_))
              ((##fx= _g4581_ 2)
               (apply std/text/json#write-json-object _g4582_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/json#write-json
                _g4582_))))))
  (define std/text/json#json-object->string
    (lambda (_obj877_)
      (let ((_port879_ (open-output-string)))
        (std/text/json#write-json-object _obj877_ _port879_)
        (get-output-string _port879_))))
  (define std/text/json#json-symbolic-keys (make-parameter '#t))
  (define std/text/json#raise-invalid-token
    (lambda (_port874_ _char875_)
      (if (eof-object? _char875_)
          (std/error#raise-io-error
           'read-json
           '"Incomplete JSON object; EOF reached"
           _port874_)
          (std/error#raise-io-error
           'read-json
           '"Invalid JSON token"
           _port874_
           _char875_))))
  (define std/text/json#read-json-object__%
    (lambda (_port842_ _raise-eof?843_)
      (std/text/json#skip-whitespace _port842_)
      (let ((_char845_ (peek-char _port842_)))
        (if (eof-object? _char845_)
            (if _raise-eof?843_
                (std/error#raise-io-error 'read-json '"EOF reached" _port842_)
                '#!eof)
            (let ((_$e847_ _char845_))
              (let ((_default849853_
                     (lambda ()
                       (std/text/json#raise-invalid-token
                        _port842_
                        _char845_)))
                    (_table850855_
                     '#(#f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        2
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        6
                        #f
                        #f
                        6
                        6
                        6
                        6
                        6
                        6
                        6
                        6
                        6
                        6
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        1
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        4
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        5
                        #f
                        #f
                        #f
                        #f
                        #f
                        3
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        0)))
                (if (char? _$e847_)
                    (let ((_ix858_ (##char->integer _$e847_)))
                      (if (##fx< _ix858_ '124)
                          (let ((_x861_ (##vector-ref _table850855_ _ix858_)))
                            (if _x861_
                                (if (##fx< _x861_ '3)
                                    (if (##fx= _x861_ '0)
                                        (std/text/json#read-json-hash
                                         _port842_)
                                        (if (##fx= _x861_ '1)
                                            (std/text/json#read-json-list
                                             _port842_)
                                            (std/text/json#read-json-string
                                             _port842_)))
                                    (if (##fx< _x861_ '5)
                                        (if (##fx= _x861_ '3)
                                            (std/text/json#read-json-true
                                             _port842_)
                                            (std/text/json#read-json-false
                                             _port842_))
                                        (if (##fx= _x861_ '5)
                                            (std/text/json#read-json-null
                                             _port842_)
                                            (std/text/json#read-json-number
                                             _port842_))))
                                (_default849853_)))
                          (_default849853_)))
                    (_default849853_))))))))
  (define std/text/json#read-json-object__0
    (lambda (_port867_)
      (let ((_raise-eof?869_ '#t))
        (std/text/json#read-json-object__% _port867_ _raise-eof?869_))))
  (define std/text/json#read-json-object
    (lambda _g4584_
      (let ((_g4583_ (##length _g4584_)))
        (cond ((##fx= _g4583_ 1)
               (apply std/text/json#read-json-object__0 _g4584_))
              ((##fx= _g4583_ 2)
               (apply std/text/json#read-json-object__% _g4584_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/json#read-json-object
                _g4584_))))))
  (define std/text/json#skip-whitespace
    (lambda (_port837_)
      (let ((_char839_ (peek-char _port837_)))
        (if (eof-object? _char839_)
            '#!void
            (if (char-whitespace? _char839_)
                (begin
                  (read-char _port837_)
                  (std/text/json#skip-whitespace _port837_))
                '#!void)))))
  (define std/text/json#skip-chars
    (lambda (_chars795_ _port796_)
      (let _lp798_ ((_rest800_ _chars795_))
        (let* ((_rest801809_ _rest800_)
               (_else803817_ (lambda () '#!void))
               (_K805825_
                (lambda (_rest820_ _char821_)
                  (let ((_next823_ (read-char _port796_)))
                    (if (eq? _next823_ _char821_)
                        (_lp798_ _rest820_)
                        (std/text/json#raise-invalid-token
                         _port796_
                         _next823_))))))
          (if (##pair? _rest801809_)
              (let ((_hd806828_ (##car _rest801809_))
                    (_tl807830_ (##cdr _rest801809_)))
                (let* ((_char833_ _hd806828_) (_rest835_ _tl807830_))
                  (_K805825_ _rest835_ _char833_)))
              '#!void)))))
  (define std/text/json#read-json-hash
    (lambda (_port779_)
      (read-char _port779_)
      (let ((_obj781_
             (if (std/text/json#json-symbolic-keys)
                 (make-table 'test: eq?)
                 (make-table))))
        (let _lp783_ ()
          (let ((_key786_ (std/text/json#read-json-hash-key _port779_)))
            (if _key786_
                (if (hash-key? _obj781_ _key786_)
                    (error '"Duplicate hash key in JSON input" _key786_)
                    (let ((_val788_
                           (std/text/json#read-json-object__0 _port779_)))
                      (table-set! _obj781_ _key786_ _val788_)
                      (std/text/json#skip-whitespace _port779_)
                      (let* ((_char790_ (peek-char _port779_))
                             (_$e792_ _char790_))
                        (if (eq? '#\, _$e792_)
                            (begin (read-char _port779_) (_lp783_))
                            (if (eq? '#\} _$e792_)
                                (begin (read-char _port779_) _obj781_)
                                (std/text/json#raise-invalid-token
                                 _port779_
                                 _char790_))))))
                _obj781_))))))
  (define std/text/json#read-json-hash-key
    (lambda (_port765_)
      (std/text/json#skip-whitespace _port765_)
      (let* ((_char767_ (peek-char _port765_)) (_$e769_ _char767_))
        (if (eq? '#\" _$e769_)
            (let ((_key772_ (std/text/json#read-json-string _port765_)))
              (std/text/json#skip-whitespace _port765_)
              (let* ((_char774_ (peek-char _port765_)) (_$e776_ _char774_))
                (if (eq? '#\: _$e776_)
                    (begin
                      (read-char _port765_)
                      (if (std/text/json#json-symbolic-keys)
                          (string->symbol _key772_)
                          _key772_))
                    (std/text/json#raise-invalid-token _port765_ _char774_))))
            (if (eq? '#\} _$e769_)
                (begin (read-char _port765_) '#f)
                (std/text/json#raise-invalid-token _port765_ _char767_))))))
  (define std/text/json#read-json-list
    (lambda (_port757_)
      (read-char _port757_)
      (let _lp759_ ((_els761_ '()))
        (let ((_next763_ (std/text/json#read-json-list-next _port757_)))
          (if _next763_
              (_lp759_ (cons _next763_ _els761_))
              (std/srfi/1#reverse! _els761_))))))
  (define std/text/json#read-json-list-next
    (lambda (_port743_)
      (std/text/json#skip-whitespace _port743_)
      (let* ((_char745_ (peek-char _port743_)) (_$e747_ _char745_))
        (if (eq? '#\] _$e747_)
            (begin (read-char _port743_) '#f)
            (let ((_obj750_ (std/text/json#read-json-object__0 _port743_)))
              (std/text/json#skip-whitespace _port743_)
              (let* ((_char752_ (peek-char _port743_)) (_$e754_ _char752_))
                (if (eq? '#\, _$e754_)
                    (begin (read-char _port743_) _obj750_)
                    (if (eq? '#\] _$e754_)
                        _obj750_
                        (std/text/json#raise-invalid-token
                         _port743_
                         _char752_)))))))))
  (define std/text/json#hexes '"0123456789abcdef")
  (define std/text/json#HEXES '"0123456789ABCDEF")
  (define std/text/json#hextab
    (let ((_ht731_ (make-table 'test: eq?)))
      (letrec ((_put733_
                (lambda (_str735_)
                  (let ((_len737_ (string-length _str735_)))
                    (let _lp739_ ((_k741_ '0))
                      (if (##fx< _k741_ _len737_)
                          (begin
                            (table-set!
                             _ht731_
                             (##string-ref _str735_ _k741_)
                             _k741_)
                            (_lp739_ (##fx+ _k741_ '1)))
                          '#!void))))))
        (_put733_ std/text/json#hexes)
        (_put733_ std/text/json#HEXES)
        _ht731_)))
  (define std/text/json#read-json-string
    (lambda (_port639_)
      (letrec ((_read-escape-char641_
                (lambda (_port710_)
                  (let* ((_char712_ (read-char _port710_)) (_$e714_ _char712_))
                    (let ((_default716720_
                           (lambda ()
                             (std/text/json#raise-invalid-token
                              _port710_
                              _char712_)))
                          (_table717722_
                           '#(#f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              0
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              0
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              0
                              #f
                              #f
                              #f
                              #f
                              #f
                              1
                              #f
                              #f
                              #f
                              3
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              2
                              #f
                              #f
                              #f
                              4
                              #f
                              5
                              6)))
                      (if (char? _$e714_)
                          (let ((_ix725_ (##char->integer _$e714_)))
                            (if (##fx< _ix725_ '118)
                                (let ((_x728_ (##vector-ref
                                               _table717722_
                                               _ix725_)))
                                  (if _x728_
                                      (if (##fx< _x728_ '3)
                                          (if (##fx= _x728_ '0)
                                              _char712_
                                              (if (##fx= _x728_ '1)
                                                  '#\backspace
                                                  '#\newline))
                                          (if (##fx< _x728_ '5)
                                              (if (##fx= _x728_ '3)
                                                  '#\page
                                                  '#\return)
                                              (if (##fx= _x728_ '5)
                                                  '#\tab
                                                  (_read-escape-unicode642_
                                                   _port710_))))
                                      (_default716720_)))
                                (_default716720_)))
                          (_default716720_))))))
               (_read-escape-unicode642_
                (lambda (_port659_)
                  (let _lp661_ ((_n663_ '0) (_chars664_ '()))
                    (if (##fx< _n663_ '4)
                        (_lp661_ (##fx+ _n663_ '1)
                                 (cons (read-char _port659_) _chars664_))
                        (let _lp666_ ((_rest668_ _chars664_)
                                      (_val669_ '0)
                                      (_shift670_ '0))
                          (let* ((_rest671679_ _rest668_)
                                 (_else673690_
                                  (lambda ()
                                    (if (and (##fx< _val669_ ##max-char)
                                             (or (##fx< _val669_ '55296)
                                                 (##fx< '57343 _val669_)))
                                        (##integer->char _val669_)
                                        '#\�)))
                                 (_K675698_
                                  (lambda (_rest693_ _char694_)
                                    (let ((_n696_ (##fxarithmetic-shift
                                                   (_hex-value643_ _char694_)
                                                   _shift670_)))
                                      (_lp666_ _rest693_
                                               (bitwise-ior _n696_ _val669_)
                                               (##fx+ _shift670_ '4))))))
                            (if (##pair? _rest671679_)
                                (let ((_hd676701_ (##car _rest671679_))
                                      (_tl677703_ (##cdr _rest671679_)))
                                  (let* ((_char706_ _hd676701_)
                                         (_rest708_ _tl677703_))
                                    (_K675698_ _rest708_ _char706_)))
                                (_else673690_))))))))
               (_hex-value643_
                (lambda (_char654_)
                  (let ((_$e656_ (table-ref
                                  std/text/json#hextab
                                  _char654_
                                  '#f)))
                    (if _$e656_
                        (values _$e656_)
                        (std/text/json#raise-invalid-token
                         _port639_
                         _char654_))))))
        (read-char _port639_)
        (let _lp645_ ((_chars647_ '()))
          (let* ((_char649_ (read-char _port639_)) (_$e651_ _char649_))
            (if (eq? '#\" _$e651_)
                (list->string (std/srfi/1#reverse! _chars647_))
                (if (eq? '#\\ _$e651_)
                    (_lp645_ (cons (_read-escape-char641_ _port639_)
                                   _chars647_))
                    (if (eof-object? _char649_)
                        (std/text/json#raise-invalid-token _port639_ _char649_)
                        (_lp645_ (cons _char649_ _chars647_))))))))))
  (define std/text/json#read-json-number
    (lambda (_port616_)
      (letrec ((_parse618_
                (lambda (_chars632_)
                  (let* ((_str634_
                          (list->string (std/srfi/1#reverse! _chars632_)))
                         (_$e636_ (string->number _str634_)))
                    (if _$e636_
                        _$e636_
                        (std/text/json#raise-invalid-token
                         _port616_
                         _str634_))))))
        (let _lp620_ ((_chars622_ (cons (read-char _port616_) '())))
          (let ((_char624_ (peek-char _port616_)))
            (if (or (eof-object? _char624_)
                    (memq _char624_ '(#\] #\} #\,))
                    (char-whitespace? _char624_))
                (_parse618_ _chars622_)
                (_lp620_ (cons (read-char _port616_) _chars622_))))))))
  (define std/text/json#read-json-true
    (lambda (_port614_)
      (std/text/json#skip-chars '(#\t #\r #\u #\e) _port614_)
      '#t))
  (define std/text/json#read-json-false
    (lambda (_port612_)
      (std/text/json#skip-chars '(#\f #\a #\l #\s #\e) _port612_)
      '#f))
  (define std/text/json#read-json-null
    (lambda (_port610_)
      (std/text/json#skip-chars '(#\n #\u #\l #\l) _port610_)
      '#!void))
  (define std/text/json#write-json-object
    (lambda (_obj607_ _port608_)
      (if (number? _obj607_)
          (if (exact-integer? _obj607_)
              (gerbil/gambit/ports#write-string__%
               (number->string _obj607_)
               _port608_)
              (if (inexact? _obj607_)
                  (std/text/json#write-json-inexact _obj607_ _port608_)
                  (if (rational? _obj607_)
                      (std/text/json#write-json-inexact
                       (exact->inexact _obj607_)
                       _port608_)
                      (error '"Bad JSON object" _obj607_))))
          (if (string? _obj607_)
              (std/text/json#write-json-string _obj607_ _port608_)
              (if (symbol? _obj607_)
                  (std/text/json#write-json-string
                   (symbol->string _obj607_)
                   _port608_)
                  (if (keyword? _obj607_)
                      (std/text/json#write-json-string
                       (keyword->string _obj607_)
                       _port608_)
                      (if (list? _obj607_)
                          (std/text/json#write-json-list _obj607_ _port608_)
                          (if (vector? _obj607_)
                              (std/text/json#write-json-vector
                               _obj607_
                               _port608_)
                              (if (table? _obj607_)
                                  (std/text/json#write-json-hash
                                   _obj607_
                                   _port608_)
                                  (if (eq? '#t _obj607_)
                                      (gerbil/gambit/ports#write-string__%
                                       '"true"
                                       _port608_)
                                      (if (eq? '#f _obj607_)
                                          (gerbil/gambit/ports#write-string__%
                                           '"false"
                                           _port608_)
                                          (if (eq? _obj607_ '#!void)
                                              (gerbil/gambit/ports#write-string__%
                                               '"null"
                                               _port608_)
                                              (std/text/json#write-json-object
                                               (let ((__method4578
                                                      (method-ref
                                                       _obj607_
                                                       ':json)))
                                                 (if __method4578
                                                     (__method4578 _obj607_)
                                                     (error '"Missing method"
                                                            _obj607_
                                                            ':json)))
                                               _port608_)))))))))))))
  (define std/text/json#write-json-inexact
    (lambda (_obj599_ _port600_)
      (let* ((_mag602_ (abs _obj599_)) (_str604_ (number->string _mag602_)))
        (if (flnegative? _obj599_) (write-char '#\- _port600_) '#!void)
        (if (eq? (string-ref _str604_ '0) '#\.)
            (write-char '#\0 _port600_)
            '#!void)
        (gerbil/gambit/ports#write-string__% _str604_ _port600_)
        (if (eq? (string-ref _str604_ (##fx- (string-length _str604_) '1))
                 '#\.)
            (write-char '#\0 _port600_)
            '#!void))))
  (define std/text/json#write-json-list
    (lambda (_obj534_ _port535_)
      (write-char '#\[ _port535_)
      (let _lp537_ ((_rest539_ _obj534_))
        (let* ((_rest540553_ _rest539_)
               (_E544557_
                (lambda () (error '"No clause matching" _rest540553_))))
          (let ((_K549589_
                 (lambda (_val587_)
                   (std/text/json#write-json-object _val587_ _port535_)
                   (write-char '#\] _port535_)))
                (_K546572_
                 (lambda (_rest569_ _val570_)
                   (std/text/json#write-json-object _val570_ _port535_)
                   (write-char '#\, _port535_)
                   (_lp537_ _rest569_)))
                (_K545562_ (lambda () (write-char '#\] _port535_))))
            (let ((_try-match543565_
                   (lambda ()
                     (if (##null? _rest540553_) (_K545562_) (_E544557_)))))
              (if (##pair? _rest540553_)
                  (let ((_tl551594_ (##cdr _rest540553_))
                        (_hd550592_ (##car _rest540553_)))
                    (if (##null? _tl551594_)
                        (let ((_val597_ _hd550592_)) (_K549589_ _val597_))
                        (let ((_val580_ _hd550592_) (_rest582_ _tl551594_))
                          (_K546572_ _rest582_ _val580_))))
                  (_try-match543565_))))))))
  (define std/text/json#write-json-vector
    (lambda (_obj523_ _port524_)
      (let ((_len526_ (vector-length _obj523_)))
        (if (##fxpositive? _len526_)
            (let ((_last528_ (##fx- _len526_ '1)))
              (write-char '#\[ _port524_)
              (let _lp530_ ((_n532_ '0))
                (if (##fx= _n532_ _last528_)
                    (begin
                      (std/text/json#write-json-object
                       (##vector-ref _obj523_ _n532_)
                       _port524_)
                      (write-char '#\] _port524_))
                    (begin
                      (std/text/json#write-json-object
                       (##vector-ref _obj523_ _n532_)
                       _port524_)
                      (write-char '#\, _port524_)
                      (_lp530_ (##fx+ _n532_ '1))))))
            (gerbil/gambit/ports#write-string__% '"[]" _port524_)))))
  (define std/text/json#write-json-hash
    (lambda (_obj432_ _port433_)
      (letrec ((_string-e435_
                (lambda (_key521_)
                  (if (string? _key521_)
                      _key521_
                      (if (symbol? _key521_)
                          (symbol->string _key521_)
                          (if (keyword? _key521_)
                              (keyword->string _key521_)
                              (error '"Illegal hash key; must be symbol, keyword or string"
                                     _obj432_
                                     _key521_)))))))
        (write-char '#\{ _port433_)
        (let ((_lst437_ (table->list _obj432_)))
          (let _lp439_ ((_rest441_ _lst437_))
            (let* ((_rest442459_ _rest441_)
                   (_E446463_
                    (lambda () (error '"No clause matching" _rest442459_))))
              (let ((_K453504_
                     (lambda (_val501_ _key502_)
                       (write (_string-e435_ _key502_) _port433_)
                       (write-char '#\: _port433_)
                       (std/text/json#write-json-object _val501_ _port433_)
                       (write-char '#\} _port433_)))
                    (_K448479_
                     (lambda (_rest475_ _val476_ _key477_)
                       (write (_string-e435_ _key477_) _port433_)
                       (write-char '#\: _port433_)
                       (std/text/json#write-json-object _val476_ _port433_)
                       (write-char '#\, _port433_)
                       (_lp439_ _rest475_)))
                    (_K447468_ (lambda () (write-char '#\} _port433_))))
                (let ((_try-match445471_
                       (lambda ()
                         (if (##null? _rest442459_) (_K447468_) (_E446463_)))))
                  (if (##pair? _rest442459_)
                      (let ((_tl455509_ (##cdr _rest442459_))
                            (_hd454507_ (##car _rest442459_)))
                        (if (##pair? _hd454507_)
                            (let ((_tl457514_ (##cdr _hd454507_))
                                  (_hd456512_ (##car _hd454507_)))
                              (if (##null? _tl455509_)
                                  (let ((_key517_ _hd456512_)
                                        (_val519_ _tl457514_))
                                    (_K453504_ _val519_ _key517_))
                                  (let ((_key492_ _hd456512_)
                                        (_val494_ _tl457514_)
                                        (_rest496_ _tl455509_))
                                    (_K448479_ _rest496_ _val494_ _key492_))))
                            (_E446463_)))
                      (_try-match445471_))))))))))
  (define std/text/json#write-json-string
    (lambda (_obj391_ _port392_)
      (letrec* ((_escape394_
                 '((#\" . #\")
                   (#\\ . #\\)
                   (#\backspace . #\b)
                   (#\newline . #\n)
                   (#\page . #\f)
                   (#\return . #\r)
                   (#\tab . #\t)))
                (_printable-char?395_
                 (lambda (_char428_)
                   (let ((_n430_ (char->integer _char428_)))
                     (if (##fx< _n430_ '32)
                         '#f
                         (if (##fx= _n430_ '127) '#f '#t)))))
                (_write-uchar396_
                 (lambda (_char415_ _port416_)
                   (let ((_int418_ (char->integer _char415_)))
                     (gerbil/gambit/ports#write-string__% '"\\u" _port416_)
                     (let _lp420_ ((_n422_ '0)
                                   (_mask423_ '61440)
                                   (_shift424_ '-12))
                       (if (##fx< _n422_ '4)
                           (let ((_char426_
                                  (string-ref
                                   std/text/json#hexes
                                   (arithmetic-shift
                                    (bitwise-and _int418_ _mask423_)
                                    _shift424_))))
                             (write-char _char426_ _port416_)
                             (_lp420_ (##fx+ _n422_ '1)
                                      (arithmetic-shift _mask423_ '-4)
                                      (##fx+ _shift424_ '4)))
                           '#!void)))))
                (_write-str397_
                 (lambda (_obj399_ _port400_)
                   (let ((_len402_ (string-length _obj399_)))
                     (let _lp404_ ((_n406_ '0))
                       (if (##fx< _n406_ _len402_)
                           (let ((_char408_ (string-ref _obj399_ _n406_)))
                             (let ((_$e410_ (assq _char408_ _escape394_)))
                               (if _$e410_
                                   ((lambda (_esc413_)
                                      (write-char '#\\ _port400_)
                                      (write-char (cdr _esc413_) _port400_))
                                    _$e410_)
                                   (if (_printable-char?395_ _char408_)
                                       (write-char _char408_ _port400_)
                                       (_write-uchar396_
                                        _char408_
                                        _port400_))))
                             (_lp404_ (##fx+ _n406_ '1)))
                           '#!void))))))
        (write-char '#\" _port392_)
        (_write-str397_ _obj391_ _port392_)
        (write-char '#\" _port392_)))))
