/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import org.eclipse.jetty.http2.AbstractFlowControlStrategy;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.util.Callback;

public class SimpleFlowControlStrategy
extends AbstractFlowControlStrategy {
    public SimpleFlowControlStrategy() {
        this(65535);
    }

    public SimpleFlowControlStrategy(int initialStreamSendWindow) {
        super(initialStreamSendWindow);
    }

    @Override
    public void onDataConsumed(ISession session, IStream stream, int length) {
        if (length <= 0) {
            return;
        }
        WindowUpdateFrame sessionFrame = new WindowUpdateFrame(0, length);
        session.updateRecvWindow(length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data consumed, increased session recv window by {} for {}", length, session);
        }
        Frame[] streamFrame = Frame.EMPTY_ARRAY;
        if (stream != null) {
            if (stream.isRemotelyClosed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Data consumed, ignoring update stream recv window by {} for remotely closed {}", length, stream);
                }
            } else {
                streamFrame = new Frame[]{new WindowUpdateFrame(stream.getId(), length)};
                stream.updateRecvWindow(length);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Data consumed, increased stream recv window by {} for {}", length, stream);
                }
            }
        }
        session.frames(stream, Callback.NOOP, sessionFrame, streamFrame);
    }
}

