"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var vega_util_1 = require("vega-util");
var util_1 = require("./util");
var Mark;
(function (Mark) {
    Mark.AREA = 'area';
    Mark.BAR = 'bar';
    Mark.LINE = 'line';
    Mark.POINT = 'point';
    Mark.RECT = 'rect';
    Mark.RULE = 'rule';
    Mark.TEXT = 'text';
    Mark.TICK = 'tick';
    Mark.TRAIL = 'trail';
    Mark.CIRCLE = 'circle';
    Mark.SQUARE = 'square';
    Mark.GEOSHAPE = 'geoshape';
})(Mark = exports.Mark || (exports.Mark = {}));
exports.AREA = Mark.AREA;
exports.BAR = Mark.BAR;
exports.LINE = Mark.LINE;
exports.POINT = Mark.POINT;
exports.TEXT = Mark.TEXT;
exports.TICK = Mark.TICK;
exports.TRAIL = Mark.TRAIL;
exports.RECT = Mark.RECT;
exports.RULE = Mark.RULE;
exports.GEOSHAPE = Mark.GEOSHAPE;
exports.CIRCLE = Mark.CIRCLE;
exports.SQUARE = Mark.SQUARE;
// Using mapped type to declare index, ensuring we always have all marks when we add more.
var MARK_INDEX = {
    area: 1,
    bar: 1,
    line: 1,
    point: 1,
    text: 1,
    tick: 1,
    trail: 1,
    rect: 1,
    geoshape: 1,
    rule: 1,
    circle: 1,
    square: 1
};
function isMark(m) {
    return !!MARK_INDEX[m];
}
exports.isMark = isMark;
function isPathMark(m) {
    return util_1.contains(['line', 'area', 'trail'], m);
}
exports.isPathMark = isPathMark;
exports.PRIMITIVE_MARKS = util_1.flagKeys(MARK_INDEX);
function isMarkDef(mark) {
    return mark['type'];
}
exports.isMarkDef = isMarkDef;
var PRIMITIVE_MARK_INDEX = vega_util_1.toSet(exports.PRIMITIVE_MARKS);
function isPrimitiveMark(mark) {
    var markType = isMarkDef(mark) ? mark.type : mark;
    return markType in PRIMITIVE_MARK_INDEX;
}
exports.isPrimitiveMark = isPrimitiveMark;
exports.STROKE_CONFIG = ['stroke', 'strokeWidth',
    'strokeDash', 'strokeDashOffset', 'strokeOpacity'];
exports.FILL_CONFIG = ['fill', 'fillOpacity'];
exports.FILL_STROKE_CONFIG = [].concat(exports.STROKE_CONFIG, exports.FILL_CONFIG);
exports.VL_ONLY_MARK_CONFIG_PROPERTIES = ['filled', 'color'];
exports.VL_ONLY_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX = {
    area: ['line', 'point'],
    bar: ['binSpacing', 'continuousBandSize', 'discreteBandSize'],
    line: ['point'],
    text: ['shortTimeLabels'],
    tick: ['bandSize', 'thickness']
};
exports.defaultMarkConfig = {
    color: '#4c78a8',
};
exports.defaultBarConfig = {
    binSpacing: 1,
    continuousBandSize: 5
};
exports.defaultTickConfig = {
    thickness: 1
};
//# sourceMappingURL=data:application/json;base64,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