"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var vega_util_1 = require("vega-util");
var channel_1 = require("../../channel");
var fielddef_1 = require("../../fielddef");
var mark_1 = require("../../mark");
var scale_1 = require("../../scale");
var util_1 = require("../../util");
var common_1 = require("../common");
var mixins = require("../mark/mixins");
function symbols(fieldDef, symbolsSpec, model, channel, type) {
    if (type === 'gradient') {
        return undefined;
    }
    var out = tslib_1.__assign({}, common_1.applyMarkConfig({}, model, mark_1.FILL_STROKE_CONFIG), mixins.color(model));
    switch (model.mark) {
        case mark_1.BAR:
        case mark_1.TICK:
        case mark_1.TEXT:
            out.shape = { value: 'square' };
            break;
        case mark_1.CIRCLE:
        case mark_1.SQUARE:
            out.shape = { value: model.mark };
            break;
        case mark_1.POINT:
        case mark_1.LINE:
        case mark_1.GEOSHAPE:
        case mark_1.AREA:
            // use default circle
            break;
    }
    var markDef = model.markDef, encoding = model.encoding;
    var filled = markDef.filled;
    if (out.fill) {
        // for fill legend, we don't want any fill in symbol
        if (channel === 'fill' || (filled && channel === channel_1.COLOR)) {
            delete out.fill;
        }
        else {
            if (out.fill['field']) {
                // For others, remove fill field
                delete out.fill;
            }
            else if (vega_util_1.isArray(out.fill)) {
                var fill = getFirstConditionValue(encoding.fill || encoding.color) || markDef.fill || (filled && markDef.color);
                if (fill) {
                    out.fill = { value: fill };
                }
            }
        }
    }
    if (out.stroke) {
        if (channel === 'stroke' || (!filled && channel === channel_1.COLOR)) {
            delete out.stroke;
        }
        else {
            if (out.stroke['field']) {
                // For others, remove stroke field
                delete out.stroke;
            }
            else if (vega_util_1.isArray(out.stroke)) {
                var stroke = getFirstConditionValue(encoding.stroke || encoding.color) || markDef.stroke || (!filled && markDef.color);
                if (stroke) {
                    out.stroke = { value: stroke };
                }
            }
        }
    }
    if (out.fill && out.fill['value'] !== 'transparent' && !out.stroke) {
        // for non color channel's legend, we need to override symbol stroke config from Vega config
        out.stroke = { value: 'transparent' };
    }
    if (channel !== channel_1.SHAPE) {
        var shape = getFirstConditionValue(encoding.shape) || markDef.shape;
        if (shape) {
            out.shape = { value: shape };
        }
    }
    if (channel !== channel_1.OPACITY) {
        var opacity = getMaxValue(encoding.opacity) || markDef.opacity;
        if (opacity) { // only apply opacity if it is neither zero or undefined
            out.opacity = { value: opacity };
        }
    }
    out = tslib_1.__assign({}, out, symbolsSpec);
    return util_1.keys(out).length > 0 ? out : undefined;
}
exports.symbols = symbols;
function gradient(fieldDef, gradientSpec, model, channel, type) {
    var out = {};
    if (type === 'gradient') {
        var opacity = getMaxValue(model.encoding.opacity) || model.markDef.opacity;
        if (opacity) { // only apply opacity if it is neither zero or undefined
            out.opacity = { value: opacity };
        }
    }
    out = tslib_1.__assign({}, out, gradientSpec);
    return util_1.keys(out).length > 0 ? out : undefined;
}
exports.gradient = gradient;
function labels(fieldDef, labelsSpec, model, channel, type) {
    var legend = model.legend(channel);
    var config = model.config;
    var out = {};
    if (fielddef_1.isTimeFieldDef(fieldDef)) {
        var isUTCScale = model.getScaleComponent(channel).get('type') === scale_1.ScaleType.UTC;
        labelsSpec = tslib_1.__assign({ text: {
                signal: common_1.timeFormatExpression('datum.value', fieldDef.timeUnit, legend.format, config.legend.shortTimeLabels, config.timeFormat, isUTCScale)
            } }, labelsSpec);
    }
    out = tslib_1.__assign({}, out, labelsSpec);
    return util_1.keys(out).length > 0 ? out : undefined;
}
exports.labels = labels;
function getMaxValue(channelDef) {
    return getConditionValue(channelDef, function (v, conditionalDef) { return Math.max(v, conditionalDef.value); });
}
function getFirstConditionValue(channelDef) {
    return getConditionValue(channelDef, function (v, conditionalDef) { return v !== undefined ? v : conditionalDef.value; });
}
function getConditionValue(channelDef, reducer) {
    if (fielddef_1.hasConditionalValueDef(channelDef)) {
        return (vega_util_1.isArray(channelDef.condition) ? channelDef.condition : [channelDef.condition])
            .reduce(reducer, channelDef.value);
    }
    else if (fielddef_1.isValueDef(channelDef)) {
        return channelDef.value;
    }
    return undefined;
}
//# sourceMappingURL=data:application/json;base64,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