'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KuiColorPickerSwatch = KuiColorPickerSwatch;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _color_picker_empty_swatch = require('./color_picker_empty_swatch');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

function KuiColorPickerSwatch(props) {
  var color = props.color,
      className = props.className;

  var isClear = !color;
  var classes = (0, _classnames2.default)('kuiColorPicker__swatch', className, {
    'kuiColorPicker__emptySwatch': isClear
  });
  var children = void 0;

  if (isClear) {
    children = _react2.default.createElement(_color_picker_empty_swatch.KuiColorPickerEmptySwatch, null);
  }

  return _react2.default.createElement(
    'div',
    {
      className: classes,
      'aria-label': props['aria-label'],
      'data-test-subj': 'colorSwatch',
      style: { background: color ? color : '' }
    },
    children
  );
}

KuiColorPickerSwatch.propTypes = {
  className: _propTypes2.default.string,
  color: _propTypes2.default.string
};
