import React, { Component } from 'react';
import { isString } from '../../services/predicate';
import { EuiButton, EuiButtonIcon } from '../button';

const defaults = {
  color: 'primary'
};

export class DefaultItemAction extends Component {

  constructor(props) {
    super(props);
  }

  render() {
    const { action, enabled, item, className } = this.props;
    if (!action.onClick) {
      throw new Error(`Cannot render item action [${action.name}]. Missing required 'onClick' callback. If you want
      to provide a custom action control, make sure to define the 'render' callback`);
    }
    const onClick = () => action.onClick(item);
    const color = this.resolveActionColor();
    const icon = this.resolveActionIcon();
    if (action.type === 'icon') {
      if (!icon) {
        throw new Error(`Cannot render item action [${action.name}]. It is configured to render as an icon but no
        icon is provided. Make sure to set the 'icon' property of the action`);
      }
      return (
        <EuiButtonIcon
          className={className}
          aria-label={action.name}
          isDisabled={!enabled}
          color={color}
          iconType={icon}
          title={action.description}
          onClick={onClick}
        />
      );
    }

    return (
      <EuiButton
        className={className}
        size="s"
        isDisabled={!enabled}
        color={color}
        iconType={icon}
        fill={false}
        title={action.description}
        onClick={onClick}
      >
        {action.name}
      </EuiButton>
    );
  }

  resolveActionIcon() {
    const { action, item } = this.props;
    if (action.icon) {
      return isString(action.icon) ? action.icon : action.icon(item);
    }
  }

  resolveActionColor() {
    const { action, item } = this.props;
    if (action.color) {
      return isString(action.color) ? action.color : action.color(item);
    }
    return defaults.color;
  }
}
